/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.BuildCraftCore;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;

public class RenderingMarkers
implements ISimpleBlockRenderingHandler {
    public static double[][][] frontX = new double[6][3][4];
    public static double[][][] frontZ = new double[6][3][4];
    public static double[][][] frontY = new double[6][3][4];

    public RenderingMarkers() {
        RenderingMarkers.initializeMarkerMatrix();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float f = block.func_71870_f(world, x, y, z);
        if (Block.field_71984_q[block.field_71990_ca] > 0) {
            f = 1.0f;
        }
        tessellator.func_78386_a(f, f, f);
        this.renderMarkerWithMeta(world, block, x, y, z, world.func_72805_g(x, y, z));
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return false;
    }

    public int getRenderId() {
        return BuildCraftCore.markerModel;
    }

    public static double[][] safeClone(double[][] d) {
        double[][] ret = new double[d.length][d[0].length];
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[0].length; ++j) {
                ret[i][j] = d[i][j];
            }
        }
        return ret;
    }

    public static void initializeMarkerMatrix() {
        double[][] frontXBase = new double[][]{{-0.0625, -0.0625, -0.0625, -0.0625}, {1.0, 0.0, 0.0, 1.0}, {-0.5, -0.5, 0.5, 0.5}};
        RenderingMarkers.frontX[3] = RenderingMarkers.safeClone(frontXBase);
        RenderingMarkers.rotateFace(frontX[3]);
        RenderingMarkers.rotateFace(frontX[3]);
        RenderingMarkers.rotateFace(frontX[3]);
        RenderingMarkers.frontX[4] = RenderingMarkers.safeClone(frontXBase);
        RenderingMarkers.rotateFace(frontX[4]);
        RenderingMarkers.frontX[5] = RenderingMarkers.safeClone(frontXBase);
        RenderingMarkers.frontX[0] = RenderingMarkers.safeClone(frontXBase);
        RenderingMarkers.rotateFace(frontX[0]);
        RenderingMarkers.rotateFace(frontX[0]);
        double[][] frontZBase = new double[][]{{-0.5, -0.5, 0.5, 0.5}, {1.0, 0.0, 0.0, 1.0}, {0.0625, 0.0625, 0.0625, 0.0625}};
        RenderingMarkers.frontZ[5] = RenderingMarkers.safeClone(frontZBase);
        RenderingMarkers.frontZ[1] = RenderingMarkers.safeClone(frontZBase);
        RenderingMarkers.rotateFace(frontZ[1]);
        RenderingMarkers.rotateFace(frontZ[1]);
        RenderingMarkers.rotateFace(frontZ[1]);
        RenderingMarkers.frontZ[2] = RenderingMarkers.safeClone(frontZBase);
        RenderingMarkers.rotateFace(frontZ[2]);
        RenderingMarkers.frontZ[0] = RenderingMarkers.safeClone(frontZBase);
        RenderingMarkers.rotateFace(frontZ[0]);
        RenderingMarkers.rotateFace(frontZ[0]);
        double[][] frontYBase = new double[][]{{-0.5, -0.5, 0.5, 0.5}, {-0.0625, -0.0625, -0.0625, -0.0625}, {0.5, -0.5, -0.5, 0.5}};
        RenderingMarkers.frontY[4] = RenderingMarkers.safeClone(frontYBase);
        RenderingMarkers.rotateFace(frontY[4]);
        RenderingMarkers.rotateFace(frontY[4]);
        RenderingMarkers.frontY[3] = RenderingMarkers.safeClone(frontYBase);
        RenderingMarkers.frontY[2] = RenderingMarkers.safeClone(frontYBase);
        RenderingMarkers.rotateFace(frontY[2]);
        RenderingMarkers.frontY[1] = RenderingMarkers.safeClone(frontYBase);
        RenderingMarkers.rotateFace(frontY[1]);
        RenderingMarkers.rotateFace(frontY[1]);
        RenderingMarkers.rotateFace(frontY[1]);
    }

    public void renderMarkerWithMeta(IBlockAccess iblockaccess, Block block, double x, double y, double z, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int xCoord = (int)x;
        int yCoord = (int)y;
        int zCoord = (int)z;
        Icon i = block.func_71895_b(iblockaccess, xCoord, yCoord, zCoord, 1);
        int m = meta;
        x += 0.5;
        z += 0.5;
        double minU = i.func_94214_a(7.0);
        double minV = i.func_94207_b(7.0);
        double maxU = i.func_94214_a(9.0);
        double maxV = i.func_94207_b(9.0);
        tessellator.func_78380_c(block.func_71874_e(iblockaccess, xCoord, yCoord, zCoord));
        double s = 0.0625;
        if (meta == 5) {
            tessellator.func_78374_a(x - s, y + 0.5 + s, z - s, minU, minV);
            tessellator.func_78374_a(x - s, y + 0.5 + s, z + s, minU, maxV);
            tessellator.func_78374_a(x + s, y + 0.5 + s, z + s, maxU, maxV);
            tessellator.func_78374_a(x + s, y + 0.5 + s, z - s, maxU, minV);
        } else if (meta == 0) {
            tessellator.func_78374_a(x + s, y + 0.5 - s, z - s, maxU, minV);
            tessellator.func_78374_a(x + s, y + 0.5 - s, z + s, maxU, maxV);
            tessellator.func_78374_a(x - s, y + 0.5 - s, z + s, minU, maxV);
            tessellator.func_78374_a(x - s, y + 0.5 - s, z - s, minU, minV);
        } else if (meta == 2) {
            tessellator.func_78374_a(x - s, y + 0.5 - s, z - s, minU, minV);
            tessellator.func_78374_a(x - s, y + 0.5 - s, z + s, minU, maxV);
            tessellator.func_78374_a(x - s, y + 0.5 + s, z + s, maxU, maxV);
            tessellator.func_78374_a(x - s, y + 0.5 + s, z - s, maxU, minV);
        } else if (meta == 1) {
            tessellator.func_78374_a(x + s, y + 0.5 + s, z - s, maxU, minV);
            tessellator.func_78374_a(x + s, y + 0.5 + s, z + s, maxU, maxV);
            tessellator.func_78374_a(x + s, y + 0.5 - s, z + s, minU, maxV);
            tessellator.func_78374_a(x + s, y + 0.5 - s, z - s, minU, minV);
        } else if (meta == 3) {
            tessellator.func_78374_a(x - s, y + 0.5 - s, z + s, minU, minV);
            tessellator.func_78374_a(x + s, y + 0.5 - s, z + s, minU, maxV);
            tessellator.func_78374_a(x + s, y + 0.5 + s, z + s, maxU, maxV);
            tessellator.func_78374_a(x - s, y + 0.5 + s, z + s, maxU, minV);
        } else if (meta == 4) {
            tessellator.func_78374_a(x - s, y + 0.5 + s, z - s, maxU, minV);
            tessellator.func_78374_a(x + s, y + 0.5 + s, z - s, maxU, maxV);
            tessellator.func_78374_a(x + s, y + 0.5 - s, z - s, minU, maxV);
            tessellator.func_78374_a(x - s, y + 0.5 - s, z - s, minU, minV);
        }
        i = block.func_71895_b(iblockaccess, xCoord, yCoord, zCoord, 0);
        minU = i.func_94209_e();
        maxU = i.func_94212_f();
        minV = i.func_94206_g();
        maxV = i.func_94210_h();
        if (meta == 5 || meta == 4 || meta == 3 || meta == 0) {
            tessellator.func_78374_a(x + frontX[m][0][0], y + frontX[m][1][0], z + frontX[m][2][0], minU, minV);
            tessellator.func_78374_a(x + frontX[m][0][1], y + frontX[m][1][1], z + frontX[m][2][1], minU, maxV);
            tessellator.func_78374_a(x + frontX[m][0][2], y + frontX[m][1][2], z + frontX[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x + frontX[m][0][3], y + frontX[m][1][3], z + frontX[m][2][3], maxU, minV);
            tessellator.func_78374_a(x - frontX[m][0][3], y + frontX[m][1][3], z + frontX[m][2][3], maxU, minV);
            tessellator.func_78374_a(x - frontX[m][0][2], y + frontX[m][1][2], z + frontX[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x - frontX[m][0][1], y + frontX[m][1][1], z + frontX[m][2][1], minU, maxV);
            tessellator.func_78374_a(x - frontX[m][0][0], y + frontX[m][1][0], z + frontX[m][2][0], minU, minV);
        }
        if (meta == 5 || meta == 2 || meta == 1 || meta == 0) {
            tessellator.func_78374_a(x + frontZ[m][0][0], y + frontZ[m][1][0], z + frontZ[m][2][0], minU, minV);
            tessellator.func_78374_a(x + frontZ[m][0][1], y + frontZ[m][1][1], z + frontZ[m][2][1], minU, maxV);
            tessellator.func_78374_a(x + frontZ[m][0][2], y + frontZ[m][1][2], z + frontZ[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x + frontZ[m][0][3], y + frontZ[m][1][3], z + frontZ[m][2][3], maxU, minV);
            tessellator.func_78374_a(x + frontZ[m][0][3], y + frontZ[m][1][3], z - frontZ[m][2][3], maxU, minV);
            tessellator.func_78374_a(x + frontZ[m][0][2], y + frontZ[m][1][2], z - frontZ[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x + frontZ[m][0][1], y + frontZ[m][1][1], z - frontZ[m][2][1], minU, maxV);
            tessellator.func_78374_a(x + frontZ[m][0][0], y + frontZ[m][1][0], z - frontZ[m][2][0], minU, minV);
        }
        if (meta == 4 || meta == 3 || meta == 2 || meta == 1) {
            tessellator.func_78374_a(x + frontY[m][0][0], y + 0.5 + frontY[m][1][0], z + frontY[m][2][0], minU, minV);
            tessellator.func_78374_a(x + frontY[m][0][1], y + 0.5 + frontY[m][1][1], z + frontY[m][2][1], minU, maxV);
            tessellator.func_78374_a(x + frontY[m][0][2], y + 0.5 + frontY[m][1][2], z + frontY[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x + frontY[m][0][3], y + 0.5 + frontY[m][1][3], z + frontY[m][2][3], maxU, minV);
            tessellator.func_78374_a(x + frontY[m][0][3], y + 0.5 - frontY[m][1][3], z + frontY[m][2][3], maxU, minV);
            tessellator.func_78374_a(x + frontY[m][0][2], y + 0.5 - frontY[m][1][2], z + frontY[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x + frontY[m][0][1], y + 0.5 - frontY[m][1][1], z + frontY[m][2][1], minU, maxV);
            tessellator.func_78374_a(x + frontY[m][0][0], y + 0.5 - frontY[m][1][0], z + frontY[m][2][0], minU, minV);
        }
    }

    private static void rotateFace(double[][] face) {
        for (int j = 0; j < 3; ++j) {
            double tmp = face[j][0];
            face[j][0] = face[j][1];
            face[j][1] = face[j][2];
            face[j][2] = face[j][3];
            face[j][3] = tmp;
        }
    }
}

