/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.inventory.InventoryWrapper;
import buildcraft.core.triggers.BCTrigger;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TriggerInventory
extends BCTrigger {
    public State state;

    public TriggerInventory(int id, State state) {
        super(id);
        this.state = state;
    }

    @Override
    public boolean hasParameter() {
        return this.state == State.Contains || this.state == State.Space;
    }

    @Override
    public String getDescription() {
        switch (this.state) {
            case Empty: {
                return "Inventory Empty";
            }
            case Contains: {
                return "Items in Inventory";
            }
            case Space: {
                return "Space in Inventory";
            }
        }
        return "Inventory Full";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        ItemStack searchedStack = null;
        if (parameter != null) {
            searchedStack = parameter.getItem();
        }
        if (tile instanceof IInventory) {
            ISidedInventory inv = InventoryWrapper.getWrappedInventory(tile);
            int invSize = inv.func_70302_i_();
            if (invSize <= 0) {
                return false;
            }
            boolean foundItems = false;
            boolean foundSpace = false;
            for (int i : inv.func_94128_d(side.ordinal())) {
                boolean slotEmpty;
                ItemStack stack = inv.func_70301_a(i);
                boolean bl = slotEmpty = stack == null || stack.field_77994_a == 0;
                if (searchedStack == null) {
                    foundItems |= !slotEmpty;
                } else if (!slotEmpty) {
                    foundItems |= stack.func_77969_a(searchedStack);
                }
                if (slotEmpty) {
                    foundSpace = true;
                    continue;
                }
                if (searchedStack == null || stack.field_77994_a >= stack.func_77976_d() || !stack.func_77969_a(searchedStack)) continue;
                foundSpace = true;
            }
            switch (this.state) {
                case Empty: {
                    return !foundItems;
                }
                case Contains: {
                    return foundItems;
                }
                case Space: {
                    return foundSpace;
                }
            }
            return !foundSpace;
        }
        return false;
    }

    @Override
    public int getIconIndex() {
        switch (this.state) {
            case Empty: {
                return 7;
            }
            case Contains: {
                return 8;
            }
            case Space: {
                return 9;
            }
        }
        return 10;
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

