/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.core.DefaultProps;
import buildcraft.core.utils.Utils;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;
import buildcraft.energy.gui.ContainerEngine;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class EngineIron
extends Engine {
    public static int MAX_LIQUID = 10000;
    public static int MAX_HEAT = 100000;
    public static int COOLANT_THRESHOLD = 49000;
    private ItemStack itemInInventory;
    int burnTime = 0;
    int heat = 0;
    private LiquidTank fuelTank;
    private LiquidTank coolantTank;
    private IronEngineFuel currentFuel = null;
    public int penaltyCooling = 0;
    boolean lastPowered = false;

    public EngineIron(TileEngine engine) {
        super(engine);
        this.maxEnergy = 100000;
        this.maxEnergyExtracted = 500;
        this.fuelTank = new LiquidTank(MAX_LIQUID);
        this.coolantTank = new LiquidTank(MAX_LIQUID);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_PATH_BLOCKS + "/base_iron.png";
    }

    @Override
    public int explosionRange() {
        return 8;
    }

    @Override
    public int maxEnergyReceived() {
        return 2000;
    }

    @Override
    public float getPistonSpeed() {
        switch (this.getEnergyStage()) {
            case Blue: {
                return 0.04f;
            }
            case Green: {
                return 0.05f;
            }
            case Yellow: {
                return 0.06f;
            }
            case Red: {
                return 0.07f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isBurning() {
        LiquidStack fuel = this.fuelTank.getLiquid();
        return fuel != null && fuel.amount > 0 && this.penaltyCooling == 0 && this.tile.isRedstonePowered;
    }

    @Override
    public void burn() {
        this.currentOutput = 0.0f;
        LiquidStack fuel = this.fuelTank.getLiquid();
        if (this.currentFuel == null) {
            this.currentFuel = IronEngineFuel.getFuelForLiquid(fuel);
        }
        if (this.currentFuel == null) {
            return;
        }
        if (this.penaltyCooling <= 0 && this.tile.isRedstonePowered) {
            this.lastPowered = true;
            if (this.burnTime > 0 || fuel.amount > 0) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                }
                if (this.burnTime <= 0) {
                    if (fuel != null) {
                        if (--fuel.amount <= 0) {
                            this.fuelTank.setLiquid(null);
                        }
                        this.burnTime = this.currentFuel.totalBurningTime / 1000;
                    } else {
                        this.currentFuel = null;
                        return;
                    }
                }
                this.currentOutput = this.currentFuel.powerPerCycle;
                this.addEnergy(this.currentFuel.powerPerCycle);
                this.heat = (int)((float)this.heat + this.currentFuel.powerPerCycle);
            }
        } else if (this.penaltyCooling <= 0 && this.lastPowered) {
            this.lastPowered = false;
            this.penaltyCooling = 600;
        }
    }

    @Override
    public void update() {
        LiquidStack liquid;
        super.update();
        if (this.itemInInventory != null && (liquid = Block.field_72036_aT.field_71990_ca == this.itemInInventory.field_77993_c && this.heat > COOLANT_THRESHOLD ? LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)new ItemStack(Item.field_77786_ax)) : LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)this.itemInInventory)) != null && this.fill(ForgeDirection.UNKNOWN, liquid, false) == liquid.amount) {
            this.fill(ForgeDirection.UNKNOWN, liquid, true);
            this.tile.func_70299_a(0, Utils.consumeItem(this.itemInInventory));
        }
        if (this.heat > COOLANT_THRESHOLD) {
            int extraHeat = this.heat - COOLANT_THRESHOLD;
            LiquidStack coolant = this.coolantTank.getLiquid();
            IronEngineCoolant currentCoolant = IronEngineCoolant.getCoolantForLiquid(coolant);
            if (currentCoolant != null) {
                if ((float)coolant.amount * currentCoolant.coolingPerUnit > (float)extraHeat) {
                    coolant.amount -= Math.round((float)extraHeat / currentCoolant.coolingPerUnit);
                    this.heat = COOLANT_THRESHOLD;
                } else {
                    this.heat = (int)((float)this.heat - (float)coolant.amount * currentCoolant.coolingPerUnit);
                    this.coolantTank.setLiquid(null);
                }
            }
        }
        if (!(this.heat <= 0 || this.penaltyCooling <= 0 && this.tile.isRedstonePowered)) {
            this.heat -= 10;
        }
        if (this.heat <= 0) {
            this.heat = 0;
        }
        if (this.heat == 0 && this.penaltyCooling > 0) {
            --this.penaltyCooling;
        }
    }

    @Override
    public void computeEnergyStage() {
        this.energyStage = this.heat <= MAX_HEAT / 4 ? Engine.EnergyStage.Blue : (this.heat <= MAX_HEAT / 2 ? Engine.EnergyStage.Green : ((float)this.heat <= (float)MAX_HEAT * 3.0f / 4.0f ? Engine.EnergyStage.Yellow : (this.heat <= MAX_HEAT ? Engine.EnergyStage.Red : Engine.EnergyStage.Explosion)));
    }

    @Override
    public int getScaledBurnTime(int i) {
        return this.fuelTank.getLiquid() != null ? (int)((float)this.fuelTank.getLiquid().amount / (float)MAX_LIQUID * (float)i) : 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("liquidId")) {
            this.fuelTank.setLiquid(new LiquidStack(nbttagcompound.func_74762_e("liquidId"), nbttagcompound.func_74762_e("liquidQty"), nbttagcompound.func_74762_e("liquidMeta")));
        } else {
            this.fuelTank.readFromNBT(nbttagcompound.func_74775_l("fuelTank"));
        }
        this.burnTime = nbttagcompound.func_74762_e("burnTime");
        if (nbttagcompound.func_74764_b("coolantId")) {
            this.coolantTank.setLiquid(new LiquidStack(nbttagcompound.func_74762_e("coolantId"), nbttagcompound.func_74762_e("coolantQty"), nbttagcompound.func_74762_e("coolantMeta")));
        } else {
            this.coolantTank.readFromNBT(nbttagcompound.func_74775_l("coolantTank"));
        }
        this.heat = nbttagcompound.func_74762_e("heat");
        this.penaltyCooling = nbttagcompound.func_74762_e("penaltyCooling");
        if (nbttagcompound.func_74764_b("itemInInventory")) {
            NBTTagCompound cpt = nbttagcompound.func_74775_l("itemInInventory");
            this.itemInInventory = ItemStack.func_77949_a((NBTTagCompound)cpt);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        nbttagcompound.func_74782_a("coolantTank", (NBTBase)this.coolantTank.writeToNBT(new NBTTagCompound()));
        nbttagcompound.func_74768_a("burnTime", this.burnTime);
        nbttagcompound.func_74768_a("heat", this.heat);
        nbttagcompound.func_74768_a("penaltyCooling", this.penaltyCooling);
        if (this.itemInInventory != null) {
            NBTTagCompound cpt = new NBTTagCompound();
            this.itemInInventory.func_77955_b(cpt);
            nbttagcompound.func_74782_a("itemInInventory", (NBTBase)cpt);
        }
    }

    public int getScaledCoolant(int i) {
        return this.coolantTank.getLiquid() != null ? (int)((float)this.coolantTank.getLiquid().amount / (float)MAX_LIQUID * (float)i) : 0;
    }

    @Override
    public void delete() {
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                int iEnergy = Math.round(this.energy * 10.0f);
                iEnergy = iEnergy & 0xFFFF0000 | j & 0xFFFF;
                this.energy = iEnergy / 10;
                break;
            }
            case 1: {
                int iEnergy = Math.round(this.energy * 10.0f);
                iEnergy = iEnergy & 0xFFFF | (j & 0xFFFF) << 16;
                this.energy = iEnergy / 10;
                break;
            }
            case 2: {
                this.currentOutput = j / 10;
                break;
            }
            case 3: {
                this.heat = this.heat & 0xFFFF0000 | j & 0xFFFF;
                break;
            }
            case 4: {
                this.heat = this.heat & 0xFFFF | (j & 0xFFFF) << 16;
                break;
            }
            case 5: {
                if (this.fuelTank.getLiquid() == null) {
                    this.fuelTank.setLiquid(new LiquidStack(0, j));
                    break;
                }
                this.fuelTank.getLiquid().amount = j;
                break;
            }
            case 6: {
                if (this.fuelTank.getLiquid() == null) {
                    this.fuelTank.setLiquid(new LiquidStack(j, 0));
                    break;
                }
                this.fuelTank.setLiquid(new LiquidStack(j, this.fuelTank.getLiquid().amount, this.fuelTank.getLiquid().itemMeta));
                break;
            }
            case 7: {
                if (this.coolantTank.getLiquid() == null) {
                    this.coolantTank.setLiquid(new LiquidStack(0, j));
                    break;
                }
                this.coolantTank.getLiquid().amount = j;
                break;
            }
            case 8: {
                if (this.coolantTank.getLiquid() == null) {
                    this.coolantTank.setLiquid(new LiquidStack(j, 0));
                    break;
                }
                this.coolantTank.setLiquid(new LiquidStack(j, this.coolantTank.getLiquid().amount, this.coolantTank.getLiquid().itemMeta));
                break;
            }
            case 9: {
                if (this.fuelTank.getLiquid() == null) {
                    this.fuelTank.setLiquid(new LiquidStack(0, 0, j));
                    break;
                }
                this.fuelTank.setLiquid(new LiquidStack(this.fuelTank.getLiquid().itemID, this.fuelTank.getLiquid().amount, j));
                break;
            }
            case 10: {
                if (this.coolantTank.getLiquid() == null) {
                    this.coolantTank.setLiquid(new LiquidStack(0, 0, j));
                    break;
                }
                this.coolantTank.setLiquid(new LiquidStack(this.coolantTank.getLiquid().itemID, this.coolantTank.getLiquid().amount, j));
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a((Container)containerEngine, 0, Math.round(this.energy * 10.0f) & 0xFFFF);
        iCrafting.func_71112_a((Container)containerEngine, 1, (Math.round(this.energy * 10.0f) & 0xFFFF0000) >> 16);
        iCrafting.func_71112_a((Container)containerEngine, 2, Math.round(this.currentOutput * 10.0f));
        iCrafting.func_71112_a((Container)containerEngine, 3, this.heat & 0xFFFF);
        iCrafting.func_71112_a((Container)containerEngine, 4, (this.heat & 0xFFFF0000) >> 16);
        iCrafting.func_71112_a((Container)containerEngine, 5, this.fuelTank.getLiquid() != null ? this.fuelTank.getLiquid().amount : 0);
        iCrafting.func_71112_a((Container)containerEngine, 6, this.fuelTank.getLiquid() != null ? this.fuelTank.getLiquid().itemID : 0);
        iCrafting.func_71112_a((Container)containerEngine, 7, this.coolantTank.getLiquid() != null ? this.coolantTank.getLiquid().amount : 0);
        iCrafting.func_71112_a((Container)containerEngine, 8, this.coolantTank.getLiquid() != null ? this.coolantTank.getLiquid().itemID : 0);
        iCrafting.func_71112_a((Container)containerEngine, 9, this.fuelTank.getLiquid() != null ? this.fuelTank.getLiquid().itemMeta : 0);
        iCrafting.func_71112_a((Container)containerEngine, 10, this.coolantTank.getLiquid() != null ? this.coolantTank.getLiquid().itemMeta : 0);
    }

    @Override
    public boolean isActive() {
        return this.penaltyCooling <= 0;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (IronEngineCoolant.getCoolantForLiquid(resource) != null) {
            return this.fillCoolant(from, resource, doFill);
        }
        if (IronEngineFuel.getFuelForLiquid(resource) != null) {
            return this.fuelTank.fill(resource, doFill);
        }
        return 0;
    }

    private int fillCoolant(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.coolantTank.fill(resource, doFill);
    }

    @Override
    public LiquidTank[] getLiquidSlots() {
        return new LiquidTank[]{this.fuelTank, this.coolantTank};
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.itemInInventory;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.itemInInventory = itemstack;
    }

    @Override
    public ItemStack decrStackSize(int slot, int amount) {
        if (this.itemInInventory != null) {
            if (this.itemInInventory.field_77994_a <= 0) {
                this.itemInInventory = null;
                return null;
            }
            ItemStack newStack = this.itemInInventory;
            if (amount >= newStack.field_77994_a) {
                this.itemInInventory = null;
            } else {
                newStack = this.itemInInventory.func_77979_a(amount);
            }
            return newStack;
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int var1) {
        if (this.itemInInventory == null) {
            return null;
        }
        ItemStack toReturn = this.itemInInventory;
        this.itemInInventory = null;
        return toReturn;
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        switch (direction) {
            case UP: {
                return this.fuelTank;
            }
            case DOWN: {
                return this.coolantTank;
            }
        }
        return null;
    }

    public LiquidStack getFuel() {
        return this.fuelTank.getLiquid();
    }

    public LiquidStack getCoolant() {
        return this.coolantTank.getLiquid();
    }
}

