/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.core.DefaultProps;
import buildcraft.core.utils.Utils;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;
import buildcraft.energy.gui.ContainerEngine;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class EngineStone
extends Engine {
    final float maxProduction = 1.0f;
    final float minProduction = 0.33333334f;
    final float target = 0.375f;
    final float kp = 1.0f;
    final float ki = 0.05f;
    final float eLimit = 13.333332f;
    int burnTime = 0;
    int totalBurnTime = 0;
    float esum = 0.0f;
    private ItemStack itemInInventory;

    public EngineStone(TileEngine engine) {
        super(engine);
        this.maxEnergy = 10000;
        this.maxEnergyExtracted = 100;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_PATH_BLOCKS + "/base_stone.png";
    }

    @Override
    public int explosionRange() {
        return 4;
    }

    @Override
    public int maxEnergyReceived() {
        return 200;
    }

    @Override
    public float getPistonSpeed() {
        switch (this.getEnergyStage()) {
            case Blue: {
                return 0.02f;
            }
            case Green: {
                return 0.04f;
            }
            case Yellow: {
                return 0.08f;
            }
            case Red: {
                return 0.16f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void burn() {
        this.currentOutput = 0.0f;
        if (this.burnTime > 0) {
            --this.burnTime;
            float e = 0.375f * (float)this.maxEnergy - this.energy;
            this.esum = Math.min(Math.max(this.esum + e, -13.333332f), 13.333332f);
            this.currentOutput = Math.min(Math.max(e * 1.0f + this.esum * 0.05f, 0.33333334f), 1.0f);
            this.addEnergy(this.currentOutput);
        }
        if (this.burnTime == 0 && this.tile.isRedstonePowered) {
            this.burnTime = this.totalBurnTime = this.getItemBurnTime(this.tile.func_70301_a(0));
            if (this.burnTime > 0) {
                this.tile.func_70299_a(0, Utils.consumeItem(this.tile.func_70301_a(0)));
            }
        }
    }

    @Override
    public int getScaledBurnTime(int i) {
        return (int)((float)this.burnTime / (float)this.totalBurnTime * (float)i);
    }

    private int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        return TileEntityFurnace.func_70398_a((ItemStack)itemstack);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.burnTime = nbttagcompound.func_74762_e("burnTime");
        this.totalBurnTime = nbttagcompound.func_74762_e("totalBurnTime");
        if (nbttagcompound.func_74764_b("itemInInventory")) {
            NBTTagCompound cpt = nbttagcompound.func_74775_l("itemInInventory");
            this.itemInInventory = ItemStack.func_77949_a((NBTTagCompound)cpt);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("burnTime", this.burnTime);
        nbttagcompound.func_74768_a("totalBurnTime", this.totalBurnTime);
        if (this.itemInInventory != null) {
            NBTTagCompound cpt = new NBTTagCompound();
            this.itemInInventory.func_77955_b(cpt);
            nbttagcompound.func_74782_a("itemInInventory", (NBTBase)cpt);
        }
    }

    @Override
    public void delete() {
        ItemStack stack = this.tile.func_70301_a(0);
        if (stack != null) {
            Utils.dropItems(this.tile.field_70331_k, stack, this.tile.field_70329_l, this.tile.field_70330_m, this.tile.field_70327_n);
        }
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.energy = j;
                break;
            }
            case 1: {
                this.currentOutput = (float)j / 100.0f;
                break;
            }
            case 2: {
                this.burnTime = j;
                break;
            }
            case 3: {
                this.totalBurnTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a((Container)containerEngine, 0, Math.round(this.energy));
        iCrafting.func_71112_a((Container)containerEngine, 1, Math.round(this.currentOutput * 100.0f));
        iCrafting.func_71112_a((Container)containerEngine, 2, this.burnTime);
        iCrafting.func_71112_a((Container)containerEngine, 3, this.totalBurnTime);
    }

    @Override
    public int getHeat() {
        return Math.round(this.energy);
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.itemInInventory;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.itemInInventory = itemstack;
    }

    @Override
    public ItemStack decrStackSize(int slot, int amount) {
        if (this.itemInInventory != null) {
            if (this.itemInInventory.field_77994_a <= 0) {
                this.itemInInventory = null;
                return null;
            }
            ItemStack newStack = this.itemInInventory;
            if (amount >= newStack.field_77994_a) {
                this.itemInInventory = null;
            } else {
                newStack = this.itemInInventory.func_77979_a(amount);
            }
            return newStack;
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int var1) {
        if (this.itemInInventory == null) {
            return null;
        }
        ItemStack toReturn = this.itemInInventory;
        this.itemInInventory = null;
        return toReturn;
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return null;
    }
}

