/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class OilPopulate {
    public static final Set surfaceDepositBiomes = new HashSet();
    public static final Set excludedBiomes = new HashSet();

    @ForgeSubscribe
    public void populate(PopulateChunkEvent.Post event) {
        boolean doGen = TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkX, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        if (!doGen) {
            return;
        }
        int worldX = event.chunkX << 4;
        int worldZ = event.chunkZ << 4;
        OilPopulate.doPopulate(event.world, event.rand, worldX, worldZ);
    }

    public static void doPopulate(World world, Random rand, int x, int z) {
        boolean largeDeposit;
        int lakeZ;
        int lakeY;
        int lakeX;
        int blockId;
        BiomeGenBase biome = world.func_72807_a(x + 16, z + 16);
        if (excludedBiomes.contains(biome.field_76756_M)) {
            return;
        }
        if (surfaceDepositBiomes.contains(biome.field_76756_M) && rand.nextDouble() <= 0.02 && (blockId = world.func_72798_a(lakeX = rand.nextInt(10) + 2 + x, lakeY = world.func_72825_h(lakeX, lakeZ = rand.nextInt(10) + 2 + z) - 1, lakeZ)) == biome.field_76752_A) {
            OilPopulate.generateSurfaceDeposit(world, rand, lakeX, lakeY, lakeZ, 3);
        }
        double bonus = surfaceDepositBiomes.contains(biome.field_76756_M) ? 1.5 : 1.0;
        boolean mediumDeposit = rand.nextDouble() <= 0.0015 * bonus;
        boolean bl = largeDeposit = rand.nextDouble() <= 5.0E-4 * bonus;
        if (BuildCraftCore.debugMode && x == 0 && z == 0) {
            largeDeposit = true;
        }
        if (mediumDeposit || largeDeposit) {
            int baseX = x;
            int baseZ = z;
            int wellY = 20 + rand.nextInt(10);
            int baseY = largeDeposit && BuildCraftEnergy.spawnOilSprings && (BuildCraftCore.debugMode || rand.nextDouble() <= 0.25) ? 0 : wellY;
            int radius = 0;
            if (largeDeposit) {
                radius = 8 + rand.nextInt(9);
            } else if (mediumDeposit) {
                radius = 4 + rand.nextInt(4);
            }
            int radiusSq = radius * radius;
            for (int poolX = -radius; poolX <= radius; ++poolX) {
                for (int poolY = -radius; poolY <= radius; ++poolY) {
                    for (int poolZ = -radius; poolZ <= radius; ++poolZ) {
                        int distance = poolX * poolX + poolY * poolY + poolZ * poolZ;
                        if (distance > radiusSq) continue;
                        world.func_94575_c(poolX + baseX, poolY + wellY, poolZ + baseZ, BuildCraftEnergy.oilStill.field_71990_ca);
                    }
                }
            }
            boolean started = false;
            for (int y = world.func_72940_L(); y >= baseY; --y) {
                int blockId2;
                if (started) {
                    blockId2 = world.func_72798_a(baseX, y, baseZ);
                    if (blockId2 == Block.field_71986_z.field_71990_ca) {
                        if (!BuildCraftEnergy.spawnOilSprings) break;
                        world.func_72832_d(baseX, y, baseZ, BuildCraftCore.springBlock.field_71990_ca, 1, 2);
                        break;
                    }
                    world.func_94575_c(baseX, y, baseZ, BuildCraftEnergy.oilStill.field_71990_ca);
                    continue;
                }
                blockId2 = world.func_72798_a(baseX, y, baseZ);
                Block block = Block.field_71973_m[blockId2];
                if (blockId2 == 0 || block.isLeaves(world, baseX, y, baseZ) || block.isWood(world, baseX, y, baseZ)) continue;
                started = true;
                if (largeDeposit) {
                    OilPopulate.generateSurfaceDeposit(world, rand, baseX, y, baseZ, 20 + rand.nextInt(20));
                } else if (mediumDeposit) {
                    OilPopulate.generateSurfaceDeposit(world, rand, baseX, y, baseZ, 5 + rand.nextInt(5));
                }
                int wellHeight = 4;
                if (largeDeposit) {
                    wellHeight = 16;
                }
                int ymax = Math.min(y + wellHeight, world.func_72940_L() - 1);
                for (int h = y + 1; h <= ymax; ++h) {
                    world.func_94575_c(baseX, h, baseZ, BuildCraftEnergy.oilStill.field_71990_ca);
                }
            }
        }
    }

    public static void generateSurfaceDeposit(World world, Random rand, int x, int y, int z, int radius) {
        int depth = rand.nextDouble() < 0.5 ? 1 : 2;
        OilPopulate.setOilWithProba(world, rand, 1.0f, x, y, z, true, depth);
        for (int w = 1; w <= radius; ++w) {
            float proba = (float)(radius - w + 4) / (float)(radius + 4);
            for (int d = -w; d <= w; ++d) {
                OilPopulate.setOilWithProba(world, rand, proba, x + d, y, z + w, false, depth);
                OilPopulate.setOilWithProba(world, rand, proba, x + d, y, z - w, false, depth);
                OilPopulate.setOilWithProba(world, rand, proba, x + w, y, z + d, false, depth);
                OilPopulate.setOilWithProba(world, rand, proba, x - w, y, z + d, false, depth);
            }
        }
        for (int dx = x - radius; dx <= x + radius; ++dx) {
            for (int dz = z - radius; dz <= z + radius; ++dz) {
                if (world.func_72798_a(dx, y - 1, dz) == BuildCraftEnergy.oilStill.field_71990_ca || !OilPopulate.isOil(world, dx + 1, y - 1, dz) || !OilPopulate.isOil(world, dx - 1, y - 1, dz) || !OilPopulate.isOil(world, dx, y - 1, dz + 1) || !OilPopulate.isOil(world, dx, y - 1, dz - 1)) continue;
                OilPopulate.setOilWithProba(world, rand, 1.0f, dx, y, dz, true, depth);
            }
        }
    }

    private static boolean isOilOrWater(World world, int x, int y, int z) {
        int blockId = world.func_72798_a(x, y, z);
        return blockId == Block.field_71942_A.field_71990_ca || blockId == Block.field_71943_B.field_71990_ca || blockId == BuildCraftEnergy.oilStill.field_71990_ca || blockId == BuildCraftEnergy.oilMoving.field_71990_ca;
    }

    private static boolean isOil(World world, int x, int y, int z) {
        int blockId = world.func_72798_a(x, y, z);
        return blockId == BuildCraftEnergy.oilStill.field_71990_ca || blockId == BuildCraftEnergy.oilMoving.field_71990_ca;
    }

    public static void setOilWithProba(World world, Random rand, float proba, int x, int y, int z, boolean force, int depth) {
        if (rand.nextFloat() <= proba && world.func_72798_a(x, y - 2, z) != 0 || force) {
            int d;
            boolean adjacentOil = false;
            for (d = -1; d <= 1; ++d) {
                if (!OilPopulate.isOil(world, x + d, y - 1, z) && !OilPopulate.isOil(world, x - d, y - 1, z) && !OilPopulate.isOil(world, x, y - 1, z + d) && !OilPopulate.isOil(world, x, y - 1, z - d)) continue;
                adjacentOil = true;
            }
            if ((adjacentOil || force) && (world.func_72799_c(x, y + 1, z) || !world.func_72804_r(x, y + 1, z) || Block.field_71973_m[world.func_72798_a(x, y + 1, z)] instanceof BlockFlower)) {
                world.func_94571_i(x, y + 1, z);
                if (OilPopulate.isOilOrWater(world, x, y, z)) {
                    world.func_94575_c(x, y, z, BuildCraftEnergy.oilStill.field_71990_ca);
                } else {
                    world.func_94571_i(x, y, z);
                }
                for (d = depth; d > 0; --d) {
                    if (!OilPopulate.isOilOrWater(world, x, y - d - 1, z) && !world.isBlockSolidOnSide(x, y - d - 1, z, ForgeDirection.UP)) continue;
                    world.func_94575_c(x, y - d, z, BuildCraftEnergy.oilStill.field_71990_ca);
                }
            }
        }
    }

    static {
        surfaceDepositBiomes.add(BiomeGenBase.field_76769_d.field_76756_M);
        surfaceDepositBiomes.add(BiomeGenBase.field_76768_g.field_76756_M);
        excludedBiomes.add(BiomeGenBase.field_76779_k.field_76756_M);
        excludedBiomes.add(BiomeGenBase.field_76778_j.field_76756_M);
    }
}

