/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.core.Position;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.core.inventory.InventoryWrapper;
import buildcraft.core.inventory.TransactorRoundRobin;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.CraftingHelper;
import buildcraft.core.utils.Utils;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class TileAutoWorkbench
extends TileEntity
implements ISpecialInventory {
    private ItemStack[] stackList = new ItemStack[9];
    private IRecipe currentRecipe = null;

    public IRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public int func_70302_i_() {
        return this.stackList.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.stackList[i];
    }

    public ItemStack func_70298_a(int slotId, int count) {
        if (this.stackList[slotId] == null) {
            return null;
        }
        if (this.stackList[slotId].field_77994_a > count) {
            return this.stackList[slotId].func_77979_a(count);
        }
        ItemStack stack = this.stackList[slotId];
        this.stackList[slotId] = null;
        return stack;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.stackList[i] = itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.stackList[slot] == null) {
            return null;
        }
        ItemStack stackToTake = this.stackList[slot];
        this.stackList[slot] = null;
        return stackToTake;
    }

    public String func_70303_b() {
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        Utils.readStacksFromNBT(nbttagcompound, "stackList", this.stackList);
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        Utils.writeStacksToNBT(nbttagcompound, "stackList", this.stackList);
    }

    public ItemStack findRecipe() {
        LocalInventoryCrafting craftMatrix = new LocalInventoryCrafting();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            craftMatrix.func_70299_a(i, stack);
        }
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((InventoryCrafting)craftMatrix, this.field_70331_k)) {
            this.currentRecipe = CraftingHelper.findMatchingRecipe(craftMatrix, this.field_70331_k);
        }
        if (this.currentRecipe != null) {
            return this.currentRecipe.func_77572_b((InventoryCrafting)craftMatrix);
        }
        return null;
    }

    public ItemStack extractItem(boolean doRemove, boolean removeRecipe) {
        LocalInventoryCrafting craftMatrix = new LocalInventoryCrafting();
        LinkedList<StackPointer> pointerList = new LinkedList<StackPointer>();
        int itemsToLeave = removeRecipe ? 0 : 1;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack != null) {
                StackPointer pointer;
                if (stack.field_77994_a <= itemsToLeave) {
                    pointer = this.getNearbyItem(stack);
                    if (pointer == null) {
                        this.resetPointers(pointerList);
                        return null;
                    }
                    pointerList.add(pointer);
                } else {
                    pointer = new StackPointer();
                    pointer.inventory = this;
                    pointer.item = this.func_70298_a(i, 1);
                    pointer.index = i;
                    stack = pointer.item;
                    pointerList.add(pointer);
                }
            }
            craftMatrix.func_70299_a(i, stack);
        }
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((InventoryCrafting)craftMatrix, this.field_70331_k)) {
            this.currentRecipe = CraftingHelper.findMatchingRecipe(craftMatrix, this.field_70331_k);
        }
        ItemStack resultStack = null;
        if (this.currentRecipe != null) {
            resultStack = this.currentRecipe.func_77572_b((InventoryCrafting)craftMatrix);
        }
        if (resultStack == null || !doRemove) {
            this.resetPointers(pointerList);
        } else {
            for (StackPointer p : pointerList) {
                if (p.item.func_77973_b().func_77668_q() == null) continue;
                ItemStack newStack = p.item.func_77973_b().getContainerItemStack(p.item);
                if (p.item.func_77984_f() && newStack.func_77960_j() >= p.item.func_77958_k()) {
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(CoreProxy.proxy.getBuildCraftPlayer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n), newStack));
                    this.field_70331_k.func_72956_a((Entity)CoreProxy.proxy.getBuildCraftPlayer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n), "random.break", 0.8f, 0.8f + this.field_70331_k.field_73012_v.nextFloat() * 0.4f);
                    newStack = null;
                }
                p.inventory.func_70299_a(p.index, newStack);
            }
        }
        return resultStack;
    }

    public void resetPointers(LinkedList pointers) {
        for (StackPointer p : pointers) {
            ItemStack item = p.inventory.func_70301_a(p.index);
            if (item == null) {
                p.inventory.func_70299_a(p.index, p.item);
                continue;
            }
            ++p.inventory.func_70301_a((int)p.index).field_77994_a;
        }
    }

    public StackPointer getNearbyItem(ItemStack stack) {
        StackPointer pointer = null;
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(stack, ForgeDirection.WEST);
        }
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(stack, ForgeDirection.EAST);
        }
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(stack, ForgeDirection.DOWN);
        }
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(stack, ForgeDirection.UP);
        }
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(stack, ForgeDirection.NORTH);
        }
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(stack, ForgeDirection.SOUTH);
        }
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(stack, ForgeDirection.UNKNOWN);
        }
        return pointer;
    }

    public StackPointer getNearbyItemFromOrientation(ItemStack itemStack, ForgeDirection direction) {
        TileEntity tile = this.field_70331_k.func_72796_p(this.field_70329_l + direction.offsetX, this.field_70330_m + direction.offsetY, this.field_70327_n + direction.offsetZ);
        if (tile instanceof ISpecialInventory) {
            return null;
        }
        ISidedInventory inventory = InventoryWrapper.getWrappedInventory(tile);
        if (inventory == null) {
            return null;
        }
        for (int j : inventory.func_94128_d(direction.ordinal())) {
            ItemStack stack = inventory.func_70301_a(j);
            if (stack == null || stack.field_77994_a <= 0 || !inventory.func_102008_b(j, stack, direction.ordinal()) || stack.field_77993_c != itemStack.field_77993_c) continue;
            if (!stack.func_77984_f()) {
                if (stack.field_77993_c != itemStack.field_77993_c || stack.func_77960_j() != itemStack.func_77960_j()) continue;
                inventory.func_70298_a(j, 1);
                StackPointer result = new StackPointer();
                result.inventory = inventory;
                result.index = j;
                result.item = stack;
                return result;
            }
            if (stack.field_77993_c != itemStack.field_77993_c) continue;
            inventory.func_70298_a(j, 1);
            StackPointer result = new StackPointer();
            result.inventory = inventory;
            result.index = j;
            result.item = stack;
            return result;
        }
        return null;
    }

    public StackPointer getNearbyItem(int itemId, int damage) {
        StackPointer pointer = null;
        pointer = this.getNearbyItemFromOrientation(itemId, damage, ForgeDirection.WEST);
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(itemId, damage, ForgeDirection.EAST);
        }
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(itemId, damage, ForgeDirection.DOWN);
        }
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(itemId, damage, ForgeDirection.UP);
        }
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(itemId, damage, ForgeDirection.NORTH);
        }
        if (pointer == null) {
            pointer = this.getNearbyItemFromOrientation(itemId, damage, ForgeDirection.SOUTH);
        }
        return pointer;
    }

    public StackPointer getNearbyItemFromOrientation(int itemId, int damage, ForgeDirection orientation) {
        Position p = new Position(this.field_70329_l, this.field_70330_m, this.field_70327_n, orientation);
        p.moveForwards(1.0);
        TileEntity tile = this.field_70331_k.func_72796_p((int)p.x, (int)p.y, (int)p.z);
        if (!(tile instanceof ISpecialInventory) && tile instanceof IInventory) {
            IInventory inventory = Utils.getInventory((IInventory)tile);
            for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                ItemStack stack = inventory.func_70301_a(j);
                if (stack == null || stack.field_77994_a <= 0 || stack.field_77993_c != itemId || stack.func_77960_j() != damage) continue;
                inventory.func_70298_a(j, 1);
                StackPointer result = new StackPointer();
                result.inventory = inventory;
                result.index = j;
                result.item = stack;
                return result;
            }
        }
        return null;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        return new TransactorRoundRobin((IInventory)this).add((ItemStack)stack, (ForgeDirection)from, (boolean)doAdd).field_77994_a;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return new ItemStack[]{this.extractItem(doRemove, false)};
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    class StackPointer {
        IInventory inventory;
        int index;
        ItemStack item;

        StackPointer() {
        }
    }

    class LocalInventoryCrafting
    extends InventoryCrafting {
        public LocalInventoryCrafting() {
            super(new Container(){

                public boolean isUsableByPlayer(EntityPlayer entityplayer) {
                    return false;
                }

                public boolean func_75145_c(EntityPlayer entityplayer) {
                    return false;
                }
            }, 3, 3);
        }
    }
}

