/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.BlockIndex;
import buildcraft.core.EntityBlock;
import buildcraft.core.IMachine;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.TileMachine;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TilePump
extends TileMachine
implements IMachine,
IPowerReceptor,
ITankContainer {
    public static int MAX_LIQUID = 1000;
    EntityBlock tube;
    private TreeMap blocksToPump = new TreeMap();
    LiquidTank tank;
    double tubeY = Double.NaN;
    int aimY = 0;
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TilePump() {
        this.powerProvider.configure(20, 1, 10, 10, 100);
        this.tank = new LiquidTank(MAX_LIQUID);
    }

    @Override
    public void func_70316_g() {
        LiquidStack liquid;
        super.func_70316_g();
        if (this.tube == null) {
            return;
        }
        if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            if (this.tube.field_70163_u - (double)this.aimY > 0.01) {
                this.tubeY = this.tube.field_70163_u - 0.01;
                this.setTubePosition();
                if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
                    this.sendNetworkUpdate();
                }
                return;
            }
            if (this.tank.getLiquid() == null || this.tank.getLiquid().amount <= 0) {
                BlockIndex index = this.getNextIndexToPump(false);
                if (this.isPumpableLiquid(index)) {
                    LiquidStack liquidToPump = Utils.liquidFromBlockId(this.field_70331_k.func_72798_a(index.i, index.j, index.k));
                    if (this.tank.fill(liquidToPump, false) == liquidToPump.amount && this.powerProvider.useEnergy(10.0f, 10.0f, true) == 10.0f) {
                        index = this.getNextIndexToPump(true);
                        if (liquidToPump.itemID != Block.field_71943_B.field_71990_ca || BuildCraftCore.consumeWaterSources) {
                            this.field_70331_k.func_94575_c(index.i, index.j, index.k, 0);
                        }
                        this.tank.fill(liquidToPump, true);
                        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
                            this.sendNetworkUpdate();
                        }
                    }
                } else if (this.field_70331_k.func_72820_D() % 100L == 0L) {
                    this.initializePumpFromPosition(this.field_70329_l, this.aimY, this.field_70327_n);
                    if (this.getNextIndexToPump(false) == null) {
                        for (int y = this.field_70330_m - 1; y > 0; --y) {
                            if (this.isLiquid(new BlockIndex(this.field_70329_l, y, this.field_70327_n))) {
                                this.aimY = y;
                                return;
                            }
                            if (this.field_70331_k.func_72798_a(this.field_70329_l, y, this.field_70327_n) == 0) continue;
                            return;
                        }
                    }
                }
            }
        }
        if ((liquid = this.tank.getLiquid()) != null && liquid.amount >= 0) {
            for (int i = 0; i < 6; ++i) {
                Position p = new Position(this.field_70329_l, this.field_70330_m, this.field_70327_n, ForgeDirection.values()[i]);
                p.moveForwards(1.0);
                TileEntity tile = this.field_70331_k.func_72796_p((int)p.x, (int)p.y, (int)p.z);
                if (!(tile instanceof ITankContainer)) continue;
                int moved = ((ITankContainer)tile).fill(p.orientation.getOpposite(), liquid, true);
                this.tank.drain(moved, true);
                if (liquid.amount <= 0) break;
            }
        }
    }

    @Override
    public void initialize() {
        this.tube = FactoryProxy.proxy.newPumpTube(this.field_70331_k);
        this.tube.field_70163_u = !Double.isNaN(this.tubeY) ? this.tubeY : (double)this.field_70330_m;
        this.tubeY = this.tube.field_70163_u;
        if (this.aimY == 0) {
            this.aimY = this.field_70330_m;
        }
        this.setTubePosition();
        this.field_70331_k.func_72838_d((Entity)this.tube);
        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            this.sendNetworkUpdate();
        }
    }

    private BlockIndex getNextIndexToPump(boolean remove) {
        LinkedList topLayer = null;
        int topLayerHeight = 0;
        for (Integer layer : this.blocksToPump.keySet()) {
            if (layer <= topLayerHeight || ((LinkedList)this.blocksToPump.get(layer)).size() == 0) continue;
            topLayerHeight = layer;
            topLayer = (LinkedList)this.blocksToPump.get(layer);
        }
        if (topLayer != null) {
            if (remove) {
                BlockIndex index = (BlockIndex)topLayer.pop();
                if (topLayer.size() == 0) {
                    this.blocksToPump.remove(topLayerHeight);
                }
                return index;
            }
            return (BlockIndex)topLayer.getLast();
        }
        return null;
    }

    private void initializePumpFromPosition(int x, int y, int z) {
        int liquidId = 0;
        HashSet markedBlocks = new HashSet();
        TreeSet lastFound = new TreeSet();
        if (!this.blocksToPump.containsKey(y)) {
            this.blocksToPump.put(y, new LinkedList());
        }
        LinkedList pumpList = (LinkedList)this.blocksToPump.get(y);
        liquidId = this.field_70331_k.func_72798_a(x, y, z);
        if (!this.isLiquid(new BlockIndex(x, y, z))) {
            return;
        }
        this.addToPumpIfLiquid(new BlockIndex(x, y, z), markedBlocks, lastFound, pumpList, liquidId);
        while (lastFound.size() > 0) {
            TreeSet visitIteration = new TreeSet(lastFound);
            lastFound.clear();
            for (BlockIndex index : visitIteration) {
                this.addToPumpIfLiquid(new BlockIndex(index.i + 1, index.j, index.k), markedBlocks, lastFound, pumpList, liquidId);
                this.addToPumpIfLiquid(new BlockIndex(index.i - 1, index.j, index.k), markedBlocks, lastFound, pumpList, liquidId);
                this.addToPumpIfLiquid(new BlockIndex(index.i, index.j, index.k + 1), markedBlocks, lastFound, pumpList, liquidId);
                this.addToPumpIfLiquid(new BlockIndex(index.i, index.j, index.k - 1), markedBlocks, lastFound, pumpList, liquidId);
                if (!this.blocksToPump.containsKey(index.j + 1)) {
                    this.blocksToPump.put(index.j + 1, new LinkedList());
                }
                pumpList = (LinkedList)this.blocksToPump.get(index.j + 1);
                this.addToPumpIfLiquid(new BlockIndex(index.i, index.j + 1, index.k), markedBlocks, lastFound, pumpList, liquidId);
            }
        }
    }

    public void addToPumpIfLiquid(BlockIndex index, Set markedBlocks, TreeSet lastFound, LinkedList pumpList, int liquidId) {
        if (liquidId != this.field_70331_k.func_72798_a(index.i, index.j, index.k)) {
            return;
        }
        if (markedBlocks.add(index)) {
            if ((index.i - this.field_70329_l) * (index.i - this.field_70329_l) + (index.k - this.field_70327_n) * (index.k - this.field_70327_n) > 4096) {
                return;
            }
            if (this.isPumpableLiquid(index)) {
                pumpList.push(index);
            }
            if (this.isLiquid(index)) {
                lastFound.add(index);
            }
        }
    }

    private boolean isPumpableLiquid(BlockIndex index) {
        return this.isLiquid(index) && this.field_70331_k.func_72805_g(index.i, index.j, index.k) == 0;
    }

    private boolean isLiquid(BlockIndex index) {
        return index != null && Utils.liquidFromBlockId(this.field_70331_k.func_72798_a(index.i, index.j, index.k)) != null;
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("internalLiquid")) {
            this.tank.setLiquid(new LiquidStack(nbttagcompound.func_74762_e("liquidId"), nbttagcompound.func_74762_e("internalLiquid")));
        } else if (nbttagcompound.func_74764_b("tank")) {
            this.tank.setLiquid(LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)nbttagcompound.func_74775_l("tank")));
        }
        this.aimY = nbttagcompound.func_74762_e("aimY");
        this.tubeY = nbttagcompound.func_74760_g("tubeY");
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.powerProvider.configure(20, 1, 10, 10, 100);
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        if (this.tank.getLiquid() != null) {
            nbttagcompound.func_74782_a("tank", (NBTBase)this.tank.getLiquid().writeToNBT(new NBTTagCompound()));
        }
        nbttagcompound.func_74768_a("aimY", this.aimY);
        if (this.tube != null) {
            nbttagcompound.func_74776_a("tubeY", (float)this.tube.field_70163_u);
        } else {
            nbttagcompound.func_74776_a("tubeY", (float)this.field_70330_m);
        }
    }

    @Override
    public boolean isActive() {
        return this.isPumpableLiquid(this.getNextIndexToPump(false));
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(4, 1, 0);
        if (this.tank.getLiquid() != null) {
            payload.intPayload[0] = this.tank.getLiquid().itemID;
            payload.intPayload[1] = this.tank.getLiquid().itemMeta;
            payload.intPayload[2] = this.tank.getLiquid().amount;
        } else {
            payload.intPayload[0] = 0;
            payload.intPayload[1] = 0;
            payload.intPayload[2] = 0;
        }
        payload.intPayload[3] = this.aimY;
        payload.floatPayload[0] = (float)this.tubeY;
        return payload;
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        this.handleUpdatePacket(packet);
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        if (packet.payload.intPayload[0] > 0) {
            this.tank.setLiquid(new LiquidStack(packet.payload.intPayload[0], packet.payload.intPayload[2], packet.payload.intPayload[1]));
        } else {
            this.tank.setLiquid(null);
        }
        this.aimY = packet.payload.intPayload[3];
        this.tubeY = packet.payload.floatPayload[0];
        this.setTubePosition();
    }

    private void setTubePosition() {
        if (this.tube != null) {
            this.tube.iSize = 0.5;
            this.tube.kSize = 0.5;
            this.tube.jSize = (double)this.field_70330_m - this.tube.field_70163_u;
            this.tube.func_70107_b((float)this.field_70329_l + 0.25f, this.tubeY, (float)this.field_70327_n + 0.25f);
        }
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.tube != null) {
            CoreProxy.proxy.removeEntity(this.tube);
            this.tube = null;
            this.tubeY = Double.NaN;
            this.aimY = 0;
            this.blocksToPump.clear();
        }
    }

    @Override
    public boolean manageLiquids() {
        return true;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowActions() {
        return false;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (tankIndex == 0) {
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tank;
    }
}

