/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileTank
extends TileBuildCraft
implements ITankContainer {
    public final LiquidTank tank = new LiquidTank(16000);
    public boolean hasUpdate = false;
    public SafeTimeTracker tracker = new SafeTimeTracker();

    @Override
    public void func_70316_g() {
        if (CoreProxy.proxy.isSimulating(this.field_70331_k) && this.hasUpdate && this.tracker.markTimeIfDelay(this.field_70331_k, 2 * BuildCraftCore.updateFactor)) {
            this.sendNetworkUpdate();
            this.hasUpdate = false;
        }
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        if (this.tank.getLiquid() != null) {
            this.moveLiquidBelow();
        }
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(3, 0, 0);
        if (this.tank.getLiquid() != null) {
            payload.intPayload[0] = this.tank.getLiquid().itemID;
            payload.intPayload[1] = this.tank.getLiquid().itemMeta;
            payload.intPayload[2] = this.tank.getLiquid().amount;
        } else {
            payload.intPayload[0] = 0;
            payload.intPayload[1] = 0;
            payload.intPayload[2] = 0;
        }
        return payload;
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        if (packet.payload.intPayload[0] > 0) {
            LiquidStack liquid = new LiquidStack(packet.payload.intPayload[0], packet.payload.intPayload[2], packet.payload.intPayload[1]);
            this.tank.setLiquid(liquid);
        } else {
            this.tank.setLiquid(null);
        }
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        if (data.func_74764_b("stored") && data.func_74764_b("liquidId")) {
            LiquidStack liquid = new LiquidStack(data.func_74762_e("liquidId"), data.func_74762_e("stored"), 0);
            this.tank.setLiquid(liquid);
        } else {
            LiquidStack liquid = LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)data.func_74775_l("tank"));
            if (liquid != null) {
                this.tank.setLiquid(liquid);
            }
        }
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        if (this.tank.containsValidLiquid()) {
            data.func_74782_a("tank", (NBTBase)this.tank.getLiquid().writeToNBT(new NBTTagCompound()));
        }
    }

    public TileTank getBottomTank() {
        TileTank below;
        TileTank lastTank = this;
        while ((below = TileTank.getTankBelow(lastTank)) != null) {
            lastTank = below;
        }
        return lastTank;
    }

    public TileTank getTopTank() {
        TileTank above;
        TileTank lastTank = this;
        while ((above = TileTank.getTankAbove(lastTank)) != null) {
            lastTank = above;
        }
        return lastTank;
    }

    public static TileTank getTankBelow(TileTank tile) {
        TileEntity below = tile.field_70331_k.func_72796_p(tile.field_70329_l, tile.field_70330_m - 1, tile.field_70327_n);
        if (below instanceof TileTank) {
            return (TileTank)below;
        }
        return null;
    }

    public static TileTank getTankAbove(TileTank tile) {
        TileEntity above = tile.field_70331_k.func_72796_p(tile.field_70329_l, tile.field_70330_m + 1, tile.field_70327_n);
        if (above instanceof TileTank) {
            return (TileTank)above;
        }
        return null;
    }

    public void moveLiquidBelow() {
        TileTank below = TileTank.getTankBelow(this);
        if (below == null) {
            return;
        }
        int used = below.tank.fill(this.tank.getLiquid(), true);
        if (used > 0) {
            this.hasUpdate = true;
            below.hasUpdate = true;
            this.tank.drain(used, true);
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex != 0 || resource == null) {
            return 0;
        }
        resource = resource.copy();
        int totalUsed = 0;
        TileTank tankToFill = this.getBottomTank();
        LiquidStack liquid = tankToFill.tank.getLiquid();
        if (liquid != null && liquid.amount > 0 && !liquid.isLiquidEqual(resource)) {
            return 0;
        }
        while (tankToFill != null && resource.amount > 0) {
            int used = tankToFill.tank.fill(resource, doFill);
            resource.amount -= used;
            if (used > 0) {
                tankToFill.hasUpdate = true;
            }
            totalUsed += used;
            tankToFill = TileTank.getTankAbove(tankToFill);
        }
        return totalUsed;
    }

    public LiquidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        return this.drain(0, maxEmpty, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxEmpty, boolean doDrain) {
        TileTank bottom = this.getBottomTank();
        bottom.hasUpdate = true;
        return bottom.tank.drain(maxEmpty, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        LiquidTank compositeTank = new LiquidTank(this.tank.getCapacity());
        TileTank tile = this.getBottomTank();
        int capacity = this.tank.getCapacity();
        if (tile == null || tile.tank.getLiquid() == null) {
            return new ILiquidTank[]{compositeTank};
        }
        compositeTank.setLiquid(tile.tank.getLiquid().copy());
        tile = TileTank.getTankAbove(tile);
        while (tile != null) {
            LiquidStack liquid = tile.tank.getLiquid();
            if (liquid != null && liquid.amount != 0) {
                if (!compositeTank.getLiquid().isLiquidEqual(liquid)) break;
                compositeTank.getLiquid().amount += liquid.amount;
            }
            capacity += tile.tank.getCapacity();
            tile = TileTank.getTankAbove(tile);
        }
        compositeTank.setCapacity(capacity);
        return new ILiquidTank[]{compositeTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.DOWN && this.field_70331_k != null && this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) != BuildCraftFactory.tankBlock.field_71990_ca) {
            return this.tank;
        }
        return null;
    }
}

