/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.DefaultProps;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.utils.StringUtils;
import buildcraft.silicon.TileAssemblyAdvancedWorkbench;
import buildcraft.silicon.gui.ContainerAssemblyAdvancedWorkbench;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import org.lwjgl.opengl.GL11;

public class GuiAssemblyAdvancedWorkbench
extends GuiAdvancedInterface {
    TileAssemblyAdvancedWorkbench workbench;

    public GuiAssemblyAdvancedWorkbench(InventoryPlayer playerInventory, TileAssemblyAdvancedWorkbench advancedWorkbench) {
        super(new ContainerAssemblyAdvancedWorkbench(playerInventory, advancedWorkbench), advancedWorkbench);
        this.workbench = advancedWorkbench;
        this.field_74194_b = 175;
        this.field_74195_c = 240;
        this.slots = new GuiAdvancedInterface.AdvancedSlot[10];
        int id = 0;
        for (int k = 0; k < 3; ++k) {
            for (int j1 = 0; j1 < 3; ++j1) {
                this.slots[id++] = new GuiAdvancedInterface.IInventorySlot(31 + j1 * 18, 16 + k * 18, this.workbench.getCraftingSlots(), j1 + k * 3);
            }
        }
        this.slots[id] = new OutputSlot(124, 35);
    }

    @Override
    protected void func_74189_g(int par1, int par2) {
        super.func_74189_g(par1, par2);
        String title = StringUtils.localize("tile.assemblyWorkbenchBlock");
        this.field_73886_k.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_73886_k.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_74195_c - 97, 0x404040);
        this.drawForegroundSelection(par1, par2);
    }

    protected void func_74185_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(DefaultProps.TEXTURE_PATH_GUI + "/assembly_advancedworkbench.png");
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(cornerX, cornerY, 0, 0, this.field_74194_b, this.field_74195_c);
        this.drawBackgroundSlots();
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        int position = this.getSlotAtLocation(i - cornerX, j - cornerY);
        GuiAdvancedInterface.IInventorySlot slot = null;
        if (position >= 0 && position < 9) {
            slot = (GuiAdvancedInterface.IInventorySlot)this.slots[position];
        }
        if (slot != null) {
            ItemStack playerStack = this.field_73882_e.field_71439_g.field_71071_by.func_70445_o();
            ItemStack newStack = playerStack != null ? new ItemStack(playerStack.field_77993_c, 1, playerStack.func_77960_j()) : null;
            this.workbench.updateCraftingMatrix(position, newStack);
        }
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.add(new AssemblyWorkbenchLedger());
    }

    class OutputSlot
    extends GuiAdvancedInterface.AdvancedSlot {
        public IRecipe recipe;

        public OutputSlot(int x, int y) {
            super(x, y);
        }

        @Override
        public ItemStack getItemStack() {
            return GuiAssemblyAdvancedWorkbench.this.workbench.getOutputSlot();
        }
    }

    class AssemblyWorkbenchLedger
    extends GuiBuildCraft.Ledger {
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public AssemblyWorkbenchLedger() {
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_98187_b("/gui/items.png");
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiAssemblyAdvancedWorkbench.this.field_73886_k.func_78261_a(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiAssemblyAdvancedWorkbench.this.field_73886_k.func_78261_a(StringUtils.localize("gui.assemblyCurrentRequired") + ":", x + 22, y + 20, this.subheaderColour);
            GuiAssemblyAdvancedWorkbench.this.field_73886_k.func_78276_b(String.format("%2.1f MJ", Float.valueOf(GuiAssemblyAdvancedWorkbench.this.workbench.getRequiredEnergy())), x + 22, y + 32, this.textColour);
            GuiAssemblyAdvancedWorkbench.this.field_73886_k.func_78261_a(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiAssemblyAdvancedWorkbench.this.field_73886_k.func_78276_b(String.format("%2.1f MJ", Float.valueOf(GuiAssemblyAdvancedWorkbench.this.workbench.getStoredEnergy())), x + 22, y + 56, this.textColour);
            GuiAssemblyAdvancedWorkbench.this.field_73886_k.func_78261_a(StringUtils.localize("gui.assemblyRate") + ":", x + 22, y + 68, this.subheaderColour);
            GuiAssemblyAdvancedWorkbench.this.field_73886_k.func_78276_b(String.format("%3.2f MJ/t", Float.valueOf((float)GuiAssemblyAdvancedWorkbench.this.workbench.getRecentEnergyAverage() / 100.0f)), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%3.2f MJ/t", Float.valueOf((float)GuiAssemblyAdvancedWorkbench.this.workbench.getRecentEnergyAverage() / 100.0f));
        }
    }
}

