/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.network;

import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketSlotChange;
import buildcraft.core.network.PacketUpdate;
import buildcraft.silicon.TileAssemblyAdvancedWorkbench;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.gui.ContainerAssemblyTable;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketHandlerSilicon
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            int packetID = data.read();
            switch (packetID) {
                case 22: {
                    PacketUpdate packetT = new PacketUpdate();
                    packetT.readData(data);
                    this.onSelectionUpdate((EntityPlayer)player, packetT);
                    break;
                }
                case 21: {
                    PacketUpdate packetA = new PacketUpdate();
                    packetA.readData(data);
                    this.onAssemblySelect((EntityPlayer)player, packetA);
                    break;
                }
                case 20: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    this.onAssemblyGetSelection((EntityPlayer)player, packetC);
                    break;
                }
                case 70: {
                    PacketSlotChange packet1 = new PacketSlotChange();
                    packet1.readData(data);
                    this.onAdvancedWorkbenchSet((EntityPlayer)player, packet1);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onSelectionUpdate(EntityPlayer player, PacketUpdate packet) {
        Container container = player.field_71070_bA;
        if (container instanceof ContainerAssemblyTable) {
            TileAssemblyTable.SelectionMessage message = new TileAssemblyTable.SelectionMessage();
            TileAssemblyTable.selectionMessageWrapper.fromPayload(message, packet.payload);
            ((ContainerAssemblyTable)container).handleSelectionMessage(message);
        }
    }

    private TileAssemblyTable getAssemblyTable(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileAssemblyTable)) {
            return null;
        }
        return (TileAssemblyTable)tile;
    }

    private TileAssemblyAdvancedWorkbench getAdvancedWorkbench(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileAssemblyAdvancedWorkbench)) {
            return null;
        }
        return (TileAssemblyAdvancedWorkbench)tile;
    }

    private void onAssemblyGetSelection(EntityPlayer player, PacketCoordinates packet) {
        TileAssemblyTable tile = this.getAssemblyTable(player.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        tile.sendSelectionTo(player);
    }

    private void onAssemblySelect(EntityPlayer player, PacketUpdate packet) {
        TileAssemblyTable tile = this.getAssemblyTable(player.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        TileAssemblyTable.SelectionMessage message = new TileAssemblyTable.SelectionMessage();
        TileAssemblyTable.selectionMessageWrapper.fromPayload(message, packet.payload);
        tile.handleSelectionMessage(message);
    }

    private void onAdvancedWorkbenchSet(EntityPlayer player, PacketSlotChange packet1) {
        TileAssemblyAdvancedWorkbench tile = this.getAdvancedWorkbench(player.field_70170_p, packet1.posX, packet1.posY, packet1.posZ);
        if (tile == null) {
            return;
        }
        tile.updateCraftingMatrix(packet1.slot, packet1.stack);
    }
}

