/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.TileGenericPipe;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ItemFacade
extends ItemBuildCraft {
    public static final LinkedList allFacades = new LinkedList();

    public ItemFacade(int i) {
        super(i);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(CreativeTabBuildCraft.tabBuildCraft);
    }

    @Override
    public String func_77628_j(ItemStack itemstack) {
        String name = super.func_77628_j(itemstack);
        int decodedBlockId = ItemFacade.getBlockId(itemstack.func_77960_j());
        int decodedMeta = ItemFacade.getMetaData(itemstack.func_77960_j());
        ItemStack newStack = new ItemStack(decodedBlockId, 1, decodedMeta);
        name = Item.field_77698_e[decodedBlockId] != null ? name + ": " + CoreProxy.proxy.getItemDisplayName(newStack) : name + " < BROKEN (" + decodedBlockId + ":" + decodedMeta + " )>";
        return name;
    }

    public String func_77667_c(ItemStack itemstack) {
        return "item.Facade";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (ItemStack stack : allFacades) {
            itemList.add(stack.func_77946_l());
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World worldObj, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (worldObj.field_72995_K) {
            return false;
        }
        TileEntity tile = worldObj.func_72796_p(x, y, z);
        if (!(tile instanceof TileGenericPipe)) {
            return false;
        }
        TileGenericPipe pipeTile = (TileGenericPipe)tile;
        if (player.func_70093_af()) {
            if (!pipeTile.hasFacade(ForgeDirection.VALID_DIRECTIONS[side])) {
                return false;
            }
            pipeTile.dropFacade(ForgeDirection.VALID_DIRECTIONS[side]);
            return true;
        }
        if (((TileGenericPipe)tile).addFacade(ForgeDirection.values()[side], ItemFacade.getBlockId(stack.func_77960_j()), ItemFacade.getMetaData(stack.func_77960_j()))) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public static void initialize() {
        for (Field f : Block.class.getDeclaredFields()) {
            Block b;
            if (!Modifier.isStatic(f.getModifiers()) || !Block.class.isAssignableFrom(f.getType())) continue;
            try {
                b = (Block)f.get(null);
            }
            catch (Exception e) {
                continue;
            }
            if (b.field_71990_ca != 20 && (b.field_71990_ca == 7 || b.field_71990_ca == 18 || b.field_71990_ca == 19 || b.field_71990_ca == 95 || !b.func_71926_d() || b.hasTileEntity(0) || !b.func_71886_c())) continue;
            ItemStack base = new ItemStack(b, 1);
            if (base.func_77981_g()) {
                HashSet names = Sets.newHashSet();
                for (int meta = 0; meta <= 15; ++meta) {
                    ItemStack is = new ItemStack(b, 1, meta);
                    if (Strings.isNullOrEmpty((String)is.func_77977_a()) || !names.add(is.func_77977_a())) continue;
                    ItemFacade.addFacade(is);
                }
                continue;
            }
            ItemFacade.addFacade(base);
        }
    }

    public static int encode(int blockId, int metaData) {
        return metaData & 0xF | (blockId & 0xFFF) << 4;
    }

    public static int getMetaData(int encoded) {
        return encoded & 0xF;
    }

    public static int getBlockId(int encoded) {
        return (encoded & 0xFFF0) >>> 4;
    }

    public boolean shouldPassSneakingClickToBlock(World worldObj, int x, int y, int z) {
        return true;
    }

    public static void addFacade(ItemStack itemStack) {
        allFacades.add(new ItemStack(BuildCraftTransport.facadeItem, 1, ItemFacade.encode(itemStack.field_77993_c, itemStack.func_77960_j())));
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ItemStack[]{new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack}, 8000, new ItemStack(BuildCraftTransport.facadeItem, 6, ItemFacade.encode(itemStack.field_77993_c, itemStack.func_77960_j()))));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }
}

