/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.core.network.IClientState;
import buildcraft.transport.utils.ConnectionMatrix;
import buildcraft.transport.utils.FacadeMatrix;
import buildcraft.transport.utils.TextureMatrix;
import buildcraft.transport.utils.WireMatrix;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.util.Icon;

public class PipeRenderState
implements IClientState {
    private boolean hasGate = false;
    private int gateIconIndex = 0;
    public final ConnectionMatrix pipeConnectionMatrix = new ConnectionMatrix();
    public final TextureMatrix textureMatrix = new TextureMatrix();
    public final WireMatrix wireMatrix = new WireMatrix();
    public final ConnectionMatrix plugMatrix = new ConnectionMatrix();
    public final FacadeMatrix facadeMatrix = new FacadeMatrix();
    private boolean dirty = true;
    @SideOnly(value=Side.CLIENT)
    public Icon currentTexture;

    public void setHasGate(boolean value) {
        if (this.hasGate != value) {
            this.hasGate = value;
            this.dirty = true;
        }
    }

    public boolean hasGate() {
        return this.hasGate;
    }

    public void setGateIconIndex(int value) {
        if (this.gateIconIndex != value) {
            this.gateIconIndex = value;
            this.dirty = true;
        }
    }

    public int getGateIconIndex() {
        return this.gateIconIndex;
    }

    public void clean() {
        this.dirty = false;
        this.pipeConnectionMatrix.clean();
        this.textureMatrix.clean();
        this.wireMatrix.clean();
        this.facadeMatrix.clean();
    }

    public boolean isDirty() {
        return this.dirty || this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty() || this.wireMatrix.isDirty() || this.facadeMatrix.isDirty() || this.plugMatrix.isDirty();
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.hasGate);
        data.writeInt(this.gateIconIndex);
        this.pipeConnectionMatrix.writeData(data);
        this.textureMatrix.writeData(data);
        this.wireMatrix.writeData(data);
        this.facadeMatrix.writeData(data);
        this.plugMatrix.writeData(data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.hasGate = data.readBoolean();
        this.gateIconIndex = data.readInt();
        this.pipeConnectionMatrix.readData(data);
        this.textureMatrix.readData(data);
        this.wireMatrix.readData(data);
        this.facadeMatrix.readData(data);
        this.plugMatrix.readData(data);
    }
}

