/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.blueprints;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.blueprints.BlockSignature;
import buildcraft.api.blueprints.BptBlock;
import buildcraft.api.blueprints.BptSlotInfo;
import buildcraft.api.blueprints.IBptContext;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.GateVanilla;
import buildcraft.transport.Pipe;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

@Deprecated
public class BptBlockPipe
extends BptBlock {
    public BptBlockPipe(int blockId) {
        super(blockId);
    }

    @Override
    public void addRequirements(BptSlotInfo slot, IBptContext context, LinkedList requirements) {
        int pipeId = slot.cpt.func_74762_e("pipeId");
        requirements.add(new ItemStack(pipeId, 1, 0));
        if (slot.cpt.func_74764_b("wire0")) {
            requirements.add(new ItemStack(BuildCraftTransport.redPipeWire));
        }
        if (slot.cpt.func_74764_b("wire1")) {
            requirements.add(new ItemStack(BuildCraftTransport.bluePipeWire));
        }
        if (slot.cpt.func_74764_b("wire2")) {
            requirements.add(new ItemStack(BuildCraftTransport.greenPipeWire));
        }
        if (slot.cpt.func_74764_b("wire3")) {
            requirements.add(new ItemStack(BuildCraftTransport.yellowPipeWire));
        }
        if (slot.cpt.func_74764_b("gate")) {
            int gateId = slot.cpt.func_74762_e("gate");
            if (slot.cpt.func_74764_b("hasPulser") && slot.cpt.func_74767_n("hasPulser")) {
                requirements.add(new ItemStack(BuildCraftTransport.pipeGateAutarchic, 1, gateId - 1));
            } else {
                requirements.add(new ItemStack(BuildCraftTransport.pipeGate, 1, gateId - 1));
            }
        }
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].addRequirements(slot, requirements);
        }
    }

    @Override
    public boolean isValid(BptSlotInfo slot, IBptContext context) {
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), slot.x, slot.y, slot.z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.itemID == slot.cpt.func_74762_e("pipeId");
        }
        return false;
    }

    @Override
    public void rotateLeft(BptSlotInfo slot, IBptContext context) {
        int pipeId = slot.cpt.func_74762_e("pipeId");
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].rotateLeft(slot, context);
        }
    }

    @Override
    public void buildBlock(BptSlotInfo slot, IBptContext context) {
        int pipeId = slot.cpt.func_74762_e("pipeId");
        Pipe pipe = BlockGenericPipe.createPipe(pipeId);
        for (int i = 0; i < pipe.wireSet.length; ++i) {
            if (!slot.cpt.func_74764_b("wire" + i)) continue;
            pipe.wireSet[i] = true;
        }
        if (slot.cpt.func_74764_b("gate")) {
            int gateId = slot.cpt.func_74762_e("gate");
            GateVanilla newGate = slot.cpt.func_74764_b("hasPulser") && slot.cpt.func_74767_n("hasPulser") ? new GateVanilla(pipe, new ItemStack(BuildCraftTransport.pipeGateAutarchic, 1, gateId - 1)) : new GateVanilla(pipe, new ItemStack(BuildCraftTransport.pipeGate, 1, gateId - 1));
            pipe.gate = newGate;
            for (int i = 0; i < 8; ++i) {
                ItemStack s;
                if (slot.cpt.func_74764_b("trigger" + i)) {
                    pipe.activatedTriggers[i] = ActionManager.triggers[slot.cpt.func_74762_e("trigger" + i)];
                }
                if (slot.cpt.func_74764_b("triggerParameter" + i) && (s = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)slot.cpt.func_74781_a("triggerParameter" + i)))) != null) {
                    pipe.triggerParameters[i] = new TriggerParameter();
                    pipe.triggerParameters[i].set(s);
                }
                if (!slot.cpt.func_74764_b("action" + i)) continue;
                pipe.activatedActions[i] = ActionManager.actions[slot.cpt.func_74762_e("action" + i)];
            }
        }
        BlockGenericPipe.placePipe(pipe, context.world(), slot.x, slot.y, slot.z, slot.blockId, slot.meta);
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].buildBlock(slot, context);
        }
    }

    @Override
    public void initializeFromWorld(BptSlotInfo bptSlot, IBptContext context, int x, int y, int z) {
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            int i;
            bptSlot.cpt.func_74768_a("pipeId", pipe.itemID);
            for (i = 0; i < pipe.wireSet.length; ++i) {
                if (!pipe.wireSet[i]) continue;
                bptSlot.cpt.func_74768_a("wire" + i, 1);
            }
            if (pipe.hasGate()) {
                bptSlot.cpt.func_74768_a("gate", pipe.gate.kind.ordinal());
                if (pipe.gate instanceof GateVanilla) {
                    bptSlot.cpt.func_74757_a("hasPulser", ((GateVanilla)pipe.gate).hasPulser());
                }
                for (i = 0; i < 8; ++i) {
                    if (pipe.activatedTriggers[i] != null) {
                        bptSlot.cpt.func_74768_a("trigger" + i, pipe.activatedTriggers[i].getId());
                    }
                    if (pipe.triggerParameters[i] != null) {
                        NBTTagCompound subCpt = new NBTTagCompound();
                        pipe.triggerParameters[i].getItemStack().func_77955_b(subCpt);
                        bptSlot.cpt.func_74782_a("triggerParameter" + i, (NBTBase)subCpt);
                    }
                    if (pipe.activatedActions[i] == null) continue;
                    bptSlot.cpt.func_74768_a("action" + i, pipe.activatedActions[i].getId());
                }
            }
            if (BuildCraftCore.itemBptProps[pipe.itemID] != null) {
                BuildCraftCore.itemBptProps[pipe.itemID].initializeFromWorld(bptSlot, context, x, y, z);
            }
        }
    }

    @Override
    public void postProcessing(BptSlotInfo slot, IBptContext context) {
        int pipeId = slot.cpt.func_74762_e("pipeId");
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].postProcessing(slot, context);
        }
    }

    @Override
    public BlockSignature getSignature(Block block) {
        BlockSignature sig = super.getSignature(block);
        sig.mod = "BuildCraftTransport";
        sig.modVersion = "3.5.3";
        return sig;
    }
}

