/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLiquidsWood;
import buildcraft.transport.pipes.PipeLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;

public class PipeLogicWood
extends PipeLogic {
    public void switchSource() {
        int meta = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        int newMeta = 6;
        for (int i = meta + 1; i <= meta + 6; ++i) {
            ForgeDirection o = ForgeDirection.values()[i % 6];
            TileEntity tile = this.container.getTile(o);
            if (!this.isInput(tile) || !PipeManager.canExtractItems(this.container.getPipe(), tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n) && !PipeManager.canExtractLiquids(this.container.getPipe(), tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n)) continue;
            newMeta = o.ordinal();
            break;
        }
        if (newMeta != meta) {
            this.worldObj.func_72921_c(this.xCoord, this.yCoord, this.zCoord, newMeta, 0);
            this.container.scheduleRenderUpdate();
        }
    }

    public boolean isInput(TileEntity tile) {
        return !(tile instanceof TileGenericPipe) && (tile instanceof IInventory || tile instanceof ITankContainer) && Utils.checkPipesConnections(this.container, tile);
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        Item equipped;
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.xCoord, this.yCoord, this.zCoord)) {
            this.switchSource();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe2 = null;
        if (tile instanceof TileGenericPipe) {
            pipe2 = ((TileGenericPipe)tile).pipe;
        }
        return (pipe2 == null || !(pipe2.logic instanceof PipeLogicWood)) && super.canPipeConnect(tile, side);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            this.switchSourceIfNeeded();
        }
    }

    private void switchSourceIfNeeded() {
        int meta = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            this.switchSource();
        } else {
            TileEntity tile = this.container.getTile(ForgeDirection.values()[meta]);
            if (!this.isInput(tile)) {
                this.switchSource();
            }
        }
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        if (!CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            this.switchSourceIfNeeded();
        }
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        if (this.container.pipe instanceof PipeLiquidsWood) {
            int meta = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
            return meta != to.ordinal();
        }
        return super.outputOpen(to);
    }
}

