/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;

public class TextureMatrix {
    private final int[] _iconIndexes = new int[ForgeDirection.values().length];
    private boolean dirty = false;

    public int getTextureIndex(ForgeDirection direction) {
        return this._iconIndexes[direction.ordinal()];
    }

    public void setIconIndex(ForgeDirection direction, int value) {
        if (this._iconIndexes[direction.ordinal()] != value) {
            this._iconIndexes[direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(DataOutputStream data) throws IOException {
        for (int i = 0; i < ForgeDirection.values().length; ++i) {
            data.writeInt(this._iconIndexes[i]);
        }
    }

    public void readData(DataInputStream data) throws IOException {
        for (int i = 0; i < ForgeDirection.values().length; ++i) {
            this._iconIndexes[i] = data.readInt();
        }
    }
}

