/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.core.handlers;

import com.pahimar.ee3.client.renderer.RenderUtils;
import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.core.util.TransmutationHelper;
import com.pahimar.ee3.item.ITransmutationStone;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TransmutationTargetOverlayHandler
implements ITickHandler {
    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = minecraft.field_71439_g;
        ItemStack currentItemStack = null;
        if (type.contains(TickType.RENDER) && player != null) {
            currentItemStack = player.field_71071_by.func_70448_g();
            if (Minecraft.func_71382_s() && minecraft.field_71415_G && currentItemStack != null && currentItemStack.func_77973_b() instanceof ITransmutationStone && ConfigurationSettings.ENABLE_OVERLAY_WORLD_TRANSMUTATION) {
                TransmutationTargetOverlayHandler.renderStoneHUD(minecraft, (EntityPlayer)player, currentItemStack, ((Float)tickData[0]).floatValue());
            }
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.CLIENT, TickType.RENDER);
    }

    public String getLabel() {
        return "Equivalent Exchange 3: " + this.getClass().getSimpleName();
    }

    private static void renderStoneHUD(Minecraft minecraft, EntityPlayer player, ItemStack stack, float partialTicks) {
        float overlayScale = ConfigurationSettings.TARGET_BLOCK_OVERLAY_SCALE;
        float blockScale = overlayScale / 2.0f;
        float overlayOpacity = ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY;
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(minecraft.field_71474_y, minecraft.field_71443_c, minecraft.field_71440_d);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        int hudOverlayX = 0;
        int hudOverlayY = 0;
        int hudBlockX = 0;
        int hudBlockY = 0;
        switch (ConfigurationSettings.TARGET_BLOCK_OVERLAY_POSITION) {
            case 0: {
                hudOverlayX = 0;
                hudBlockX = (int)(16.0f * overlayScale / 2.0f - 8.0f);
                hudOverlayY = 0;
                hudBlockY = (int)(16.0f * overlayScale / 2.0f - 8.0f);
                break;
            }
            case 1: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudBlockX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale / 2.0f - 8.0f);
                hudOverlayY = 0;
                hudBlockY = (int)(16.0f * overlayScale / 2.0f - 8.0f);
                break;
            }
            case 2: {
                hudOverlayX = 0;
                hudBlockX = (int)(16.0f * overlayScale / 2.0f - 8.0f);
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                hudBlockY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale / 2.0f - 8.0f);
                break;
            }
            case 3: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale);
                hudBlockX = (int)((float)sr.func_78326_a() - 16.0f * overlayScale / 2.0f - 8.0f);
                hudOverlayY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale);
                hudBlockY = (int)((float)sr.func_78328_b() - 16.0f * overlayScale / 2.0f - 8.0f);
                break;
            }
        }
        RenderUtils.renderItemIntoGUI(minecraft.field_71466_p, minecraft.field_71446_o, stack, hudOverlayX, hudOverlayY, overlayOpacity, overlayScale);
        if (TransmutationHelper.targetBlockStack != null && TransmutationHelper.targetBlockStack.func_77973_b() instanceof ItemBlock) {
            RenderUtils.renderRotatingBlockIntoGUI(minecraft.field_71466_p, minecraft.field_71446_o, TransmutationHelper.targetBlockStack, hudBlockX, hudBlockY, -90.0f, blockScale);
        }
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }
}

