/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.core.util;

import com.pahimar.ee3.core.util.GeneralHelper;
import com.pahimar.ee3.core.util.ItemUtil;
import com.pahimar.ee3.core.util.OreStack;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeHelper {
    public static ArrayList getRecipeInputs(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shapedRecipe = (ShapedRecipes)recipe;
            ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
            for (int i = 0; i < shapedRecipe.field_77574_d.length; ++i) {
                if (shapedRecipe.field_77574_d[i] == null) continue;
                ItemStack shapedRecipeStack = shapedRecipe.field_77574_d[i];
                shapedRecipeStack.field_77994_a = 1;
                recipeInputs.add(shapedRecipeStack);
            }
            return ItemUtil.collateStacks(recipeInputs);
        }
        if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes shapelessRecipe = (ShapelessRecipes)recipe;
            return ItemUtil.collateStacks(new ArrayList(shapelessRecipe.field_77579_b));
        }
        if (recipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe shapedOreRecipe = (ShapedOreRecipe)recipe;
            ArrayList<Object> recipeInputs = new ArrayList<Object>();
            for (int i = 0; i < shapedOreRecipe.getInput().length; ++i) {
                if (shapedOreRecipe.getInput()[i] instanceof ArrayList) {
                    ArrayList shapedOreRecipeList = (ArrayList)shapedOreRecipe.getInput()[i];
                    if (shapedOreRecipeList.size() <= 0) continue;
                    recipeInputs.add(new OreStack((ItemStack)shapedOreRecipeList.get(0)));
                    continue;
                }
                if (shapedOreRecipe.getInput()[i] == null) continue;
                recipeInputs.add(shapedOreRecipe.getInput()[i]);
            }
            return ItemUtil.collateStacks(recipeInputs);
        }
        if (recipe instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe shapelessOreRecipe = (ShapelessOreRecipe)recipe;
            ArrayList<OreStack> recipeInputs = new ArrayList<OreStack>();
            for (Object o : shapelessOreRecipe.getInput()) {
                if (o instanceof ArrayList) {
                    ArrayList shapelessOreRecipeList = (ArrayList)o;
                    if (shapelessOreRecipeList.size() <= 0) continue;
                    recipeInputs.add(new OreStack((ItemStack)shapelessOreRecipeList.get(0)));
                    continue;
                }
                if (o == null) continue;
                recipeInputs.add((OreStack)o);
            }
            return ItemUtil.collateStacks(recipeInputs);
        }
        return null;
    }

    public static ArrayList getReverseRecipes(ItemStack itemStack) {
        ArrayList craftingManagerRecipeList = new ArrayList(CraftingManager.func_77594_a().func_77592_b());
        ArrayList<IRecipe> reverseRecipeList = new ArrayList<IRecipe>();
        for (IRecipe recipe : craftingManagerRecipeList) {
            if (recipe.func_77571_b() == null || !ItemUtil.compare(itemStack, recipe.func_77571_b())) continue;
            reverseRecipeList.add(recipe);
        }
        return reverseRecipeList;
    }

    public static void addRecipe(ItemStack output, Object ... input) {
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])input);
    }

    public static void addRecipe(ItemStack output, ItemStack transmutationStone, Object ... input) {
        Object[] inputs = new Object[input.length + 1];
        System.arraycopy(input, 0, inputs, 0, input.length);
        inputs[input.length] = transmutationStone;
        RecipeHelper.addRecipe(output, inputs);
    }

    public static void addRecipe(Block output, Object ... input) {
        RecipeHelper.addRecipe(new ItemStack(output), input);
    }

    public static void addRecipe(Block output, int count, Object ... input) {
        RecipeHelper.addRecipe(new ItemStack(output, count), input);
    }

    public static void addRecipe(Item output, Object ... input) {
        RecipeHelper.addRecipe(new ItemStack(output), input);
    }

    public static void addRecipe(Item output, int count, Object ... input) {
        RecipeHelper.addRecipe(new ItemStack(output, count), input);
    }

    public static Object[] getMetaCycle(Object input, int n) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < n; ++i) {
            ItemStack stack = GeneralHelper.convertObjectToItemStack(input);
            stack.func_77964_b(i);
            list.add(stack);
        }
        return list.toArray();
    }

    public static Object[] getMetaCycle(Object input, int n, int ... excludedMeta) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < n; ++i) {
            for (int j : excludedMeta) {
                if (i != j) continue;
                ++i;
            }
            if (i >= n) break;
            ItemStack stack = GeneralHelper.convertObjectToItemStack(input);
            stack.func_77964_b(i);
            list.add(stack);
        }
        return list.toArray();
    }

    protected static void addMetaCycleRecipe(Object input, ItemStack stone, int n) {
        for (int i = 0; i < n; ++i) {
            int outputI;
            int n2 = outputI = i == n - 1 ? 0 : i + 1;
            if (input instanceof Block) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)input, 1, outputI), (Object[])new Object[]{stone, new ItemStack((Block)input, 1, i)});
                continue;
            }
            if (input instanceof Item) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)input, 1, outputI), (Object[])new Object[]{stone, new ItemStack((Item)input, 1, i)});
                continue;
            }
            if (!(input instanceof ItemStack)) continue;
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(((ItemStack)input).field_77993_c, 1, outputI), (Object[])new Object[]{stone, new ItemStack(((ItemStack)input).field_77993_c, 1, i)});
        }
    }

    protected static void addMetaCycleRecipe(Object input, ItemStack stone, int n, int ... excludedMeta) {
        int i = 0;
        int outputI = 1;
        while (i < n && outputI != 0) {
            outputI = i == n - 1 ? 0 : i + 1;
            for (int j : excludedMeta) {
                if (outputI != j) continue;
                outputI = (outputI + 1) % 16;
            }
            if (input instanceof Block) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)input, 1, outputI), (Object[])new Object[]{stone, new ItemStack((Block)input, 1, i)});
            } else if (input instanceof Item) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)input, 1, outputI), (Object[])new Object[]{stone, new ItemStack((Item)input, 1, i)});
            } else if (input instanceof ItemStack) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(((ItemStack)input).field_77993_c, 1, outputI), (Object[])new Object[]{stone, new ItemStack(((ItemStack)input).field_77993_c, 1, i)});
            }
            i = outputI;
        }
    }

    public static void addSmeltingRecipe(ItemStack input, ItemStack stone, ItemStack fuel) {
        ItemStack result = FurnaceRecipes.func_77602_a().getSmeltingResult(input);
        if (input == null || input.func_77973_b() == null || result == null) {
            return;
        }
        Object[] list = new Object[9];
        list[0] = stone;
        list[1] = fuel;
        for (int i = 2; i < 9; ++i) {
            list[i] = new ItemStack(input.func_77973_b(), 1, input.func_77960_j());
        }
        if (result.field_77994_a * 7 <= result.func_77973_b().func_77639_j()) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(result.func_77973_b(), result.field_77994_a * 7, result.func_77960_j()), (Object[])list);
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(result.func_77973_b(), result.func_77973_b().func_77639_j(), result.func_77960_j()), (Object[])list);
        }
    }
}

