/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.core.util.ItemUtil;
import com.pahimar.ee3.core.util.NBTHelper;
import com.pahimar.ee3.item.ItemEE;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemAlchemicalBag
extends ItemEE {
    private static final String[] ALCHEMICAL_BAG_SUBTYPES = new String[]{"Open", "OpenDrawString", "Closed", "ClosedDrawString"};
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public ItemAlchemicalBag(int id) {
        super(id);
        this.func_77655_b("alchemicalBag");
        this.func_77637_a(EquivalentExchange3.tabsEE3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.icons = new Icon[ALCHEMICAL_BAG_SUBTYPES.length];
        for (int i = 0; i < ALCHEMICAL_BAG_SUBTYPES.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("EE3".toLowerCase() + ":" + "alchemicalBag" + ALCHEMICAL_BAG_SUBTYPES[i]);
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!world.field_72995_K) {
            NBTHelper.setBoolean(itemStack, "itemAlchemicalBagGuiOpen", true);
            entityPlayer.openGui((Object)EquivalentExchange3.instance, 5, entityPlayer.field_70170_p, (int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u, (int)entityPlayer.field_70161_v);
        }
        return itemStack;
    }

    public boolean func_77651_p() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack itemStack, int renderPass) {
        if (NBTHelper.hasTag(itemStack, "itemAlchemicalBagGuiOpen")) {
            if (renderPass != 1) {
                return this.icons[0];
            }
            return this.icons[1];
        }
        if (renderPass != 1) {
            return this.icons[2];
        }
        return this.icons[3];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int renderPass) {
        if (renderPass == 1) {
            return Integer.parseInt("ffffff", 16);
        }
        int bagColor = this.getColor(itemStack);
        if (bagColor < 0) {
            bagColor = Integer.parseInt("ffffff", 16);
        }
        return bagColor;
    }

    public boolean hasColor(ItemStack itemStack) {
        return ItemUtil.hasColor(itemStack);
    }

    public int getColor(ItemStack itemStack) {
        return ItemUtil.getColor(itemStack);
    }

    public void setColor(ItemStack itemStack, int color) {
        if (itemStack != null) {
            if (!(itemStack.func_77973_b() instanceof ItemAlchemicalBag)) {
                throw new UnsupportedOperationException("Can't dye non-bags!");
            }
            ItemUtil.setColor(itemStack, color);
        }
    }

    public void removeColor(ItemStack itemStack) {
        NBTTagCompound displayTagCompound;
        NBTTagCompound nbtTagCompound;
        if (itemStack != null && (nbtTagCompound = itemStack.func_77978_p()) != null && (displayTagCompound = nbtTagCompound.func_74775_l("display")).func_74764_b("color")) {
            displayTagCompound.func_82580_o("color");
        }
    }
}

