/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.packet;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.network.PacketTypeHandler;
import com.pahimar.ee3.network.packet.PacketEE;
import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.INetworkManager;
import net.minecraftforge.common.ForgeDirection;

public class PacketTileUpdate
extends PacketEE {
    public int x;
    public int y;
    public int z;
    public byte orientation;
    public byte state;
    public String customName;

    public PacketTileUpdate() {
        super(PacketTypeHandler.TILE, true);
    }

    public PacketTileUpdate(int x, int y, int z, ForgeDirection orientation, byte state, String customName) {
        super(PacketTypeHandler.TILE, true);
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = (byte)orientation.ordinal();
        this.state = state;
        this.customName = customName;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.x);
        data.writeInt(this.y);
        data.writeInt(this.z);
        data.writeByte(this.orientation);
        data.writeByte(this.state);
        data.writeUTF(this.customName);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.x = data.readInt();
        this.y = data.readInt();
        this.z = data.readInt();
        this.orientation = data.readByte();
        this.state = data.readByte();
        this.customName = data.readUTF();
    }

    @Override
    public void execute(INetworkManager manager, Player player) {
        EquivalentExchange3.proxy.handleTileEntityPacket(this.x, this.y, this.z, ForgeDirection.getOrientation((int)this.orientation), this.state, this.customName);
    }
}

