/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.packet;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.network.PacketTypeHandler;
import com.pahimar.ee3.network.packet.PacketEE;
import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.network.INetworkManager;
import net.minecraftforge.common.ForgeDirection;

public class PacketTileWithItemUpdate
extends PacketEE {
    public int x;
    public int y;
    public int z;
    public byte orientation;
    public byte state;
    public String customName;
    public int itemID;
    public int metaData;
    public int stackSize;
    public int color;

    public PacketTileWithItemUpdate() {
        super(PacketTypeHandler.TILE_WITH_ITEM, true);
    }

    public PacketTileWithItemUpdate(int x, int y, int z, ForgeDirection orientation, byte state, String customName, int itemID, int metaData, int stackSize, int color) {
        super(PacketTypeHandler.TILE_WITH_ITEM, true);
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = (byte)orientation.ordinal();
        this.state = state;
        this.customName = customName;
        this.itemID = itemID;
        this.metaData = metaData;
        this.stackSize = stackSize;
        this.color = color;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.x);
        data.writeInt(this.y);
        data.writeInt(this.z);
        data.writeByte(this.orientation);
        data.writeByte(this.state);
        data.writeUTF(this.customName);
        data.writeInt(this.itemID);
        data.writeInt(this.metaData);
        data.writeInt(this.stackSize);
        data.writeInt(this.color);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.x = data.readInt();
        this.y = data.readInt();
        this.z = data.readInt();
        this.orientation = data.readByte();
        this.state = data.readByte();
        this.customName = data.readUTF();
        this.itemID = data.readInt();
        this.metaData = data.readInt();
        this.stackSize = data.readInt();
        this.color = data.readInt();
    }

    @Override
    public void execute(INetworkManager manager, Player player) {
        EquivalentExchange3.proxy.handleTileWithItemPacket(this.x, this.y, this.z, ForgeDirection.getOrientation((int)this.orientation), this.state, this.customName, this.itemID, this.metaData, this.stackSize, this.color);
    }
}

