/*
 * Decompiled with CFR 0.152.
 */
package me.LlamaGoingNorth.alwaysday;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import me.LlamaGoingNorth.alwaysday.AlwaysDayLogger;
import me.LlamaGoingNorth.alwaysday.util.AutoUpdate;
import me.LlamaGoingNorth.alwaysday.util.ConfigManager;
import me.LlamaGoingNorth.alwaysday.util.CustomWorldSetting;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AlwaysDay
extends JavaPlugin {
    public final Logger logger = Logger.getLogger("Minecraft");
    public static AlwaysDay plugin;
    public static int enabled;
    public static int taskID;
    public final AlwaysDayLogger adl = new AlwaysDayLogger(this);
    public static List<World> worlds;
    private AutoUpdate update;
    private boolean updateIsEnabled = false;

    static {
        enabled = 1;
        taskID = 0;
    }

    public void onDisable() {
        if (this.updateIsEnabled) {
            this.update.stopThreads();
        }
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.update != null && this.update.Updated()) {
            this.getFile().renameTo(new File("plugins/" + this.update.latestLocalFile() + ".jar"));
        }
        this.adl.loadStatus(false);
    }

    public void onEnable() {
        plugin = this;
        new ConfigManager(this).makeBooleanPaths("updates.autoupdate").makeBooleanPaths("updates.remind").makeStringList("worlds.calm").makeStringList("worlds.storm");
        if (this.getConfig().getBoolean("updates.autoupdate")) {
            this.updateIsEnabled = true;
            this.update = new AutoUpdate(this, this.getFile());
        }
        this.adl.loadStatus(true);
        if (!this.getConfig().isSet("worlds") && new File(this.getDataFolder(), "config.yml").exists()) {
            new File(this.getDataFolder(), "config.yml").delete();
        }
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        CustomWorldSetting.loadSetting(false);
        if (this.getConfig().getBoolean("enabled")) {
            AlwaysDay.startRepeat(taskID);
        } else {
            enabled = 0;
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!(sender instanceof Player)) {
            if (commandLabel.equalsIgnoreCase("alwaysday") || commandLabel.equalsIgnoreCase("ad")) {
                if (args[0].equalsIgnoreCase("update")) {
                    if (args.length == 2 && args[1].equalsIgnoreCase("remind")) {
                        if (this.getConfig().getBoolean("updates.remind")) {
                            this.getConfig().set("updates.remind", (Object)false);
                            this.saveConfig();
                            sender.sendMessage(ChatColor.YELLOW + "AlwaysDay update reminders have been disabled");
                        } else {
                            this.getConfig().set("updates.remind", (Object)true);
                            this.saveConfig();
                            sender.sendMessage(ChatColor.YELLOW + "AlwaysDay update reminders have been enabled");
                        }
                        return true;
                    }
                    if (args.length == 1) {
                        if (this.getConfig().getBoolean("updates.autoupdate")) {
                            this.getConfig().set("updates.autoupdate", (Object)false);
                            this.saveConfig();
                            this.getServer().getConsoleSender().sendMessage(ChatColor.YELLOW + "AlwaysDay Auto-update has been disabled");
                            this.update.stopThreads();
                            this.updateIsEnabled = false;
                            this.update = null;
                        } else {
                            this.getConfig().set("updates.autoupdate", (Object)true);
                            this.saveConfig();
                            this.getServer().getConsoleSender().sendMessage(ChatColor.YELLOW + "AlwaysDay Auto-update has been enabled");
                            this.update = new AutoUpdate(this, this.getFile());
                            this.updateIsEnabled = true;
                        }
                        return true;
                    }
                    return false;
                }
                this.getServer().getConsoleSender().sendMessage(ChatColor.YELLOW + "Please use 'ad update' to enable/disable Auto-update or 'ad update remind' to toggle reminders");
                return true;
            }
            this.getServer().getConsoleSender().sendMessage(ChatColor.YELLOW + "Please use 'ad update' to enable/disable Auto-update or 'ad update remind' to toggle reminders");
            return true;
        }
        Player player = (Player)sender;
        if (commandLabel.equalsIgnoreCase("alwaysday") || commandLabel.equalsIgnoreCase("ad")) {
            if (args.length == 0 && player.hasPermission("alwaysday.main.toggleonoff")) {
                if (enabled == 1) {
                    enabled = 0;
                    Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
                    taskID = 0;
                    player.sendMessage("AlwaysDay is now disabled");
                    this.getConfig().set("enabled", (Object)false);
                    this.saveConfig();
                    return true;
                }
                enabled = 1;
                player.sendMessage("AlwaysDay is now enabled");
                this.getConfig().set("enabled", (Object)true);
                this.saveConfig();
                AlwaysDay.startRepeat(taskID);
                return true;
            }
            if (args.length == 1 || args.length == 2) {
                if (args[0].equalsIgnoreCase("all") && player.hasPermission("alwaysday.main.removeworld")) {
                    if (args.length == 2) {
                        if (args[1].equalsIgnoreCase("w")) {
                            worlds = Bukkit.getWorlds();
                            Iterator<World> allAvailiable = worlds.iterator();
                            while (allAvailiable.hasNext()) {
                                String worldnames = allAvailiable.next().getName();
                                player.sendMessage(ChatColor.DARK_AQUA + CustomWorldSetting.noWeather(worldnames));
                            }
                            return true;
                        }
                        return false;
                    }
                    worlds = Bukkit.getWorlds();
                    Iterator<World> allAvailiable = worlds.iterator();
                    while (allAvailiable.hasNext()) {
                        String worldnames = allAvailiable.next().getName();
                        player.sendMessage(ChatColor.DARK_AQUA + CustomWorldSetting.removeSetting(worldnames));
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("list")) {
                    CustomWorldSetting.getSetting(player);
                    if (enabled == 1) {
                        player.sendMessage(ChatColor.DARK_PURPLE + ChatColor.ITALIC + "AlwaysDay is running.");
                    } else {
                        player.sendMessage(ChatColor.DARK_PURPLE + ChatColor.ITALIC + "AlwaysDay is not running.");
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("update") && player.hasPermission("alwaysday.main.update")) {
                    if (args.length == 2 && args[1].equalsIgnoreCase("remind")) {
                        if (this.getConfig().getBoolean("updates.remind")) {
                            this.getConfig().set("updates.remind", (Object)false);
                            this.saveConfig();
                            player.sendMessage(ChatColor.YELLOW + "AlwaysDay update reminders have been disabled");
                        } else {
                            this.getConfig().set("updates.remind", (Object)true);
                            this.saveConfig();
                            player.sendMessage(ChatColor.YELLOW + "AlwaysDay update reminders have been enabled");
                        }
                        return true;
                    }
                    if (args.length == 1) {
                        if (this.getConfig().getBoolean("updates.autoupdate")) {
                            this.getConfig().set("updates.autoupdate", (Object)false);
                            this.saveConfig();
                            player.sendMessage(ChatColor.YELLOW + "AlwaysDay Auto-update has been disabled");
                            this.update.stopThreads();
                            this.updateIsEnabled = false;
                            this.update = null;
                        } else {
                            this.getConfig().set("updates.autoupdate", (Object)true);
                            this.saveConfig();
                            this.update = new AutoUpdate(this, this.getFile());
                            this.updateIsEnabled = true;
                            player.sendMessage(ChatColor.YELLOW + "AlwaysDay Auto-update has been enabled");
                        }
                        return true;
                    }
                    return false;
                }
                player.sendMessage(ChatColor.RED + "You don't have the required permissions");
                return true;
            }
            player.sendMessage(ChatColor.RED + "You don't have the required permissions");
            return true;
        }
        if (commandLabel.equalsIgnoreCase("day") && player.hasPermission("alwaysday.day")) {
            worlds = Bukkit.getServer().getWorlds();
            if (args.length == 0) {
                Iterator<World> allAvailiable = worlds.iterator();
                while (allAvailiable.hasNext()) {
                    String worldnames = allAvailiable.next().getName();
                    player.sendMessage(ChatColor.DARK_AQUA + CustomWorldSetting.saveSetting(worldnames, null));
                }
                return true;
            }
            if (args.length == 1) {
                int checkForWorld = 0;
                Iterator<World> allAvailiable = worlds.iterator();
                while (allAvailiable.hasNext()) {
                    String worldnames = allAvailiable.next().getName();
                    if (!worldnames.equals(args[0])) continue;
                    ++checkForWorld;
                }
                if (checkForWorld == 0) {
                    player.sendMessage(ChatColor.GOLD + "This world does not exist, have you spellt it correctly?");
                } else {
                    player.sendMessage(ChatColor.DARK_AQUA + CustomWorldSetting.saveSetting(args[0], null));
                }
                return true;
            }
            player.sendMessage(ChatColor.GOLD + "Please set only one world at a time!");
            return false;
        }
        if (commandLabel.equalsIgnoreCase("night") && player.hasPermission("alwaysday.night")) {
            taskID = 0;
            worlds = Bukkit.getServer().getWorlds();
            if (args.length == 0) {
                Iterator<World> allAvailiable = worlds.iterator();
                while (allAvailiable.hasNext()) {
                    String worldnames = allAvailiable.next().getName();
                    player.sendMessage(ChatColor.DARK_AQUA + CustomWorldSetting.saveSetting(null, worldnames));
                }
                return true;
            }
            if (args.length == 1) {
                int checkForWorld = 0;
                Iterator<World> allAvailiable = worlds.iterator();
                while (allAvailiable.hasNext()) {
                    String worldnames = allAvailiable.next().getName();
                    if (!worldnames.equals(args[0])) continue;
                    ++checkForWorld;
                }
                if (checkForWorld == 0) {
                    player.sendMessage(ChatColor.GOLD + "This world does not exist, have you spellt it correctly?");
                } else {
                    player.sendMessage(ChatColor.DARK_AQUA + CustomWorldSetting.saveSetting(null, args[0]));
                }
                return true;
            }
            player.sendMessage(ChatColor.GOLD + "Please set only one world at a time!");
            return false;
        }
        if (commandLabel.equalsIgnoreCase("calm") && player.hasPermission("alwaysday.calm")) {
            worlds = Bukkit.getServer().getWorlds();
            if (args.length == 0) {
                Iterator<World> allAvailiable = worlds.iterator();
                while (allAvailiable.hasNext()) {
                    String worldnames = allAvailiable.next().getName();
                    player.sendMessage(ChatColor.DARK_AQUA + CustomWorldSetting.controlWeather(worldnames, false));
                }
                return true;
            }
            if (args.length == 1) {
                int checkForWorld = 0;
                Iterator<World> allAvailiable = worlds.iterator();
                while (allAvailiable.hasNext()) {
                    String worldnames = allAvailiable.next().getName();
                    if (!worldnames.equals(args[0])) continue;
                    ++checkForWorld;
                }
                if (checkForWorld == 0) {
                    player.sendMessage(ChatColor.GOLD + "This world does not exist, have you spellt it correctly?");
                } else {
                    player.sendMessage(ChatColor.DARK_AQUA + CustomWorldSetting.controlWeather(args[0], false));
                }
                return true;
            }
            player.sendMessage(ChatColor.GOLD + "Please set only one world at a time!");
            return false;
        }
        if (commandLabel.equalsIgnoreCase("rain") && player.hasPermission("alwaysday.rain")) {
            worlds = Bukkit.getServer().getWorlds();
            if (args.length == 0) {
                Iterator<World> allAvailiable = worlds.iterator();
                while (allAvailiable.hasNext()) {
                    String worldnames = allAvailiable.next().getName();
                    player.sendMessage(ChatColor.DARK_AQUA + CustomWorldSetting.controlWeather(worldnames, true));
                }
                return true;
            }
            if (args.length == 1) {
                int checkForWorld = 0;
                Iterator<World> allAvailiable = worlds.iterator();
                while (allAvailiable.hasNext()) {
                    String worldnames = allAvailiable.next().getName();
                    if (!worldnames.equals(args[0])) continue;
                    ++checkForWorld;
                }
                if (checkForWorld == 0) {
                    player.sendMessage(ChatColor.GOLD + "This world does not exist, have you spellt it correctly?");
                } else {
                    player.sendMessage(ChatColor.DARK_AQUA + CustomWorldSetting.controlWeather(args[0], true));
                }
                return true;
            }
            player.sendMessage(ChatColor.GOLD + "Please set only one world at a time!");
            return false;
        }
        player.sendMessage(ChatColor.RED + "You don't have the required permissions!");
        return true;
    }

    public static void startRepeat(int task) {
        task = Bukkit.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                if (enabled == 1) {
                    World world;
                    for (String newW : CustomWorldSetting.dayWorld) {
                        world = Bukkit.getWorld((String)newW);
                        if (world != null) {
                            world.setTime(8000L);
                            continue;
                        }
                        Logger.getLogger("Minecraft").warning(String.valueOf(CustomWorldSetting.removeSetting(newW)) + " This is because it may not exist.");
                        Logger.getLogger("Minecraft").warning(String.valueOf(CustomWorldSetting.noWeather(newW)) + " This is because it may not exist.");
                        break;
                    }
                    for (String newW : CustomWorldSetting.nightWorld) {
                        world = Bukkit.getWorld((String)newW);
                        if (world != null) {
                            world.setTime(17000L);
                            continue;
                        }
                        Logger.getLogger("Minecraft").warning(String.valueOf(CustomWorldSetting.removeSetting(newW)) + " This is because it may not exist.");
                        Logger.getLogger("Minecraft").warning(String.valueOf(CustomWorldSetting.noWeather(newW)) + " This is because it may not exist.");
                        break;
                    }
                    for (String newW : CustomWorldSetting.calm) {
                        world = Bukkit.getWorld((String)newW);
                        if (world != null) {
                            world.setStorm(false);
                            world.setThundering(false);
                            continue;
                        }
                        Logger.getLogger("Minecraft").warning(String.valueOf(CustomWorldSetting.removeSetting(newW)) + " This is because it may not exist.");
                        Logger.getLogger("Minecraft").warning(String.valueOf(CustomWorldSetting.noWeather(newW)) + " This is because it may not exist.");
                        break;
                    }
                    for (String newW : CustomWorldSetting.storm) {
                        world = Bukkit.getWorld((String)newW);
                        if (world != null) {
                            world.setStorm(true);
                            world.setThundering(true);
                            continue;
                        }
                        Logger.getLogger("Minecraft").warning(String.valueOf(CustomWorldSetting.removeSetting(newW)) + " This is because it may not exist.");
                        Logger.getLogger("Minecraft").warning(String.valueOf(CustomWorldSetting.noWeather(newW)) + " This is because it may not exist.");
                        break;
                    }
                } else {
                    Bukkit.getServer().getScheduler().cancelTask(taskID);
                    taskID = 0;
                }
            }
        }, 0L, 600L);
    }

    public void sendAllPlayerMessage(String message, Boolean OPOnly) {
        Player[] playerArray = this.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player online = playerArray[n2];
            if (OPOnly.booleanValue()) {
                if (online.isOp()) {
                    online.sendMessage(message);
                }
            } else {
                online.sendMessage(message);
            }
            ++n2;
        }
    }
}

