/*
 * Decompiled with CFR 0.152.
 */
package me.LlamaGoingNorth.alwaysday.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import me.LlamaGoingNorth.alwaysday.AlwaysDay;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutoUpdate {
    private final String FEED_URL = "http://dev.bukkit.org/server-mods/always-day/files.rss";
    private AlwaysDay plugin;
    private File file;
    private URL feed;
    private InputStream rssFeed;
    private String title;
    private String link;
    private String version;
    private String updateFolder = YamlConfiguration.loadConfiguration((File)new File("bukkit.yml")).getString("settings.update-folder");
    private int multiplier;
    private long totalSize;
    private static final int BYTE_SIZE = 1024;
    private ScheduledThreadPoolExecutor stpe;
    private boolean updated = false;

    public AutoUpdate(AlwaysDay plugin, File file) {
        this.plugin = plugin;
        this.file = file;
        try {
            this.feed = new URL("http://dev.bukkit.org/server-mods/always-day/files.rss");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (!file.getName().contains("-DEV")) {
            this.stpe = new ScheduledThreadPoolExecutor(2);
            this.stpe.scheduleAtFixedRate(new UpdateRunner(), 0L, 1L, TimeUnit.DAYS);
        }
    }

    public void stopThreads() {
        this.stpe.shutdown();
    }

    public boolean Updated() {
        return this.updated;
    }

    public String latestLocalFile() {
        return "AlwaysDay-v" + this.title.split(" v")[1];
    }

    private boolean readFeed() {
        try {
            this.rssFeed = this.feed.openStream();
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbfactory.newDocumentBuilder();
            Document doc = dBuilder.parse(this.rssFeed);
            doc.getDocumentElement().normalize();
            NodeList nlist = doc.getElementsByTagName("item");
            int temp = 0;
            while (temp < nlist.getLength()) {
                Node nNode = nlist.item(temp);
                if (nNode.getNodeType() == 1) {
                    Element eElem = (Element)nNode;
                    this.title = eElem.getElementsByTagName("title").item(0).getTextContent();
                    this.link = eElem.getElementsByTagName("link").item(0).getTextContent();
                    break;
                }
                ++temp;
            }
            this.rssFeed.close();
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not connect to dev.bukkit.org, please try again later.");
            return false;
        }
    }

    private String getLatestLink() {
        String dwnLink = null;
        try {
            String line;
            URLConnection lateLink = new URL(this.link).openConnection();
            BufferedReader buff = new BufferedReader(new InputStreamReader(lateLink.getInputStream()));
            int counter = 0;
            while ((line = buff.readLine()) != null) {
                ++counter;
                int SizeLine = 0;
                if (line.contains("<li class=\"user-action user-action-download\">")) {
                    dwnLink = line.split("<a href=\"")[1].split("\">Download</a>")[0];
                    continue;
                }
                if (line.contains("<dt>Size</dt>")) {
                    SizeLine = counter + 1;
                    continue;
                }
                if (SizeLine != counter) continue;
                String size = line.split("<dd>")[1].split("</dd>")[0];
                this.multiplier = size.contains("MiB") ? 0x100000 : 1024;
                size = size.replace("MiB", "").replace("KiB", "");
                this.totalSize = (long)Double.parseDouble(size);
            }
            buff.close();
            buff = null;
            lateLink = null;
            return dwnLink;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.plugin.getLogger().warning("The auto-updater attempted to connect to dev.bukkit.org but failed.");
            return null;
        }
    }

    private void downloadLatest(File folder, String file, String dlLink) {
        if (!folder.exists()) {
            folder.mkdir();
        }
        BufferedInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                int count;
                URL fileUrl = new URL(dlLink);
                int fileLength = fileUrl.openConnection().getContentLength();
                in = new BufferedInputStream(fileUrl.openStream());
                out = new FileOutputStream(String.valueOf(folder.getAbsolutePath()) + "/" + file);
                byte[] data = new byte[1024];
                this.plugin.logger.info("About to download update: " + this.title);
                long downloaded = 0L;
                while ((count = in.read(data, 0, 1024)) != -1) {
                    out.write(data, 0, count);
                    int percent = (int)((downloaded += (long)count) * 100L / (long)fileLength);
                    if (percent % 20 != 0) continue;
                    this.plugin.logger.info("Downloaded " + percent + "% of " + fileLength + " bytes.");
                }
                this.plugin.logger.info("Finished updating, please use the 'reload' command to complete the update");
                this.plugin.sendAllPlayerMessage(ChatColor.GREEN + "AlwaysDay update ready. Please reload the server.", true);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Unable to download the updates, please download them manually.");
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private class UpdateRunner
    implements Runnable {
        private UpdateRunner() {
        }

        @Override
        public void run() {
            String latestLink;
            if (AutoUpdate.this.readFeed() && !AutoUpdate.this.title.split(" v")[1].equalsIgnoreCase(AutoUpdate.this.plugin.getDescription().getVersion()) && (latestLink = AutoUpdate.this.getLatestLink()) != null) {
                if (!new File("plugins/" + AutoUpdate.this.updateFolder + "/AlwaysDay-v" + AutoUpdate.this.title.split(" v")[1] + ".jar").exists()) {
                    AutoUpdate.this.downloadLatest(new File("plugins/" + AutoUpdate.this.updateFolder), "AlwaysDay-v" + AutoUpdate.this.title.split(" v")[1] + ".jar", latestLink);
                    AutoUpdate.this.updated = true;
                } else {
                    AutoUpdate.this.updated = true;
                    if (AutoUpdate.this.plugin.getConfig().getBoolean("updates.remind")) {
                        ((AutoUpdate)AutoUpdate.this).plugin.logger.info("There is an AlwaysDay update ready to be installed, please restart your server.");
                        ((AutoUpdate)AutoUpdate.this).plugin.logger.info("You can disable this message by using '/ad update remind'");
                        AutoUpdate.this.plugin.sendAllPlayerMessage("There is an AlwaysDay update ready to be installed, please restart your server.", true);
                        AutoUpdate.this.plugin.sendAllPlayerMessage("You can disable this message by using '/ad update remind'", true);
                    } else {
                        AutoUpdate.this.stopThreads();
                    }
                }
            }
        }
    }
}

