/*
 * Decompiled with CFR 0.152.
 */
package ic2.bcIntegration.core;

import buildcraft.api.gates.ITriggerParameter;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.bcIntegration.core.Trigger;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.block.wiring.TileEntityElectricBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;

public class TriggerCapacitor
extends Trigger {
    int action = 0;

    public TriggerCapacitor(int id, int action) {
        super(id);
        this.action = action;
    }

    @Override
    public Icon getTextureIcon() {
        return iconProvider.getIcon(this.action);
    }

    @Override
    public String getDescription() {
        switch (this.action) {
            case 0: {
                return "Capacitor Empty";
            }
            case 1: {
                return "Capacitor Has Energy";
            }
            case 2: {
                return "Space For Energy";
            }
            case 3: {
                return "Capacitor Full";
            }
            case 4: {
                return "Charging Empty Item";
            }
            case 5: {
                return "Charging Partially Charged Item";
            }
            case 6: {
                return "Charging Fully Charged Item";
            }
            case 7: {
                return "Discharging Empty Item";
            }
            case 8: {
                return "Discharging Partially Charged Item";
            }
            case 9: {
                return "Discharging Fully Charged Item";
            }
        }
        return "";
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, ITriggerParameter parameter) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEntityStandardMachine) {
            TileEntityStandardMachine teb = (TileEntityStandardMachine)tile;
            boolean hasEnergy = teb.energy >= teb.maxInput;
            boolean hasRoom = teb.energy <= teb.maxEnergy - teb.maxInput;
            boolean dischargeEnergy = this.canDischarge(teb.dischargeSlot.get());
            boolean dischargeRoom = this.canCharge(teb.dischargeSlot.get());
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 7: {
                    return !dischargeEnergy;
                }
                case 8: {
                    return dischargeEnergy && dischargeRoom;
                }
                case 9: {
                    return !dischargeRoom;
                }
            }
        } else if (tile instanceof TileEntityBaseGenerator) {
            TileEntityBaseGenerator teb = (TileEntityBaseGenerator)tile;
            boolean hasEnergy = teb.storage > 0;
            boolean hasRoom = teb.storage < teb.maxStorage;
            boolean chargeEnergy = this.canDischarge(teb.chargeSlot.get());
            boolean chargeRoom = this.canCharge(teb.chargeSlot.get());
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 4: {
                    return !chargeEnergy;
                }
                case 5: {
                    return chargeEnergy && chargeRoom;
                }
                case 6: {
                    return !chargeRoom;
                }
            }
        } else if (tile instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock teb = (TileEntityElectricBlock)tile;
            boolean hasEnergy = teb.energy >= teb.output;
            boolean hasRoom = teb.energy < teb.maxStorage;
            boolean chargeEnergy = this.canDischarge(teb.chargeSlot.get());
            boolean chargeRoom = this.canCharge(teb.chargeSlot.get());
            boolean dischargeEnergy = this.canDischarge(teb.dischargeSlot.get());
            boolean dischargeRoom = this.canCharge(teb.dischargeSlot.get());
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 4: {
                    return !chargeEnergy;
                }
                case 5: {
                    return chargeEnergy && chargeRoom;
                }
                case 6: {
                    return !chargeRoom;
                }
                case 7: {
                    return !dischargeEnergy;
                }
                case 8: {
                    return dischargeEnergy && dischargeRoom;
                }
                case 9: {
                    return !dischargeRoom;
                }
            }
        }
        return false;
    }

    private IElectricItem getElectricItem(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IElectricItem) {
            return (IElectricItem)item;
        }
        return null;
    }

    private boolean canDischarge(ItemStack itemStack) {
        IElectricItem electricItem = this.getElectricItem(itemStack);
        if (electricItem == null) {
            return false;
        }
        return ElectricItem.manager.getCharge(itemStack) > 0;
    }

    private boolean canCharge(ItemStack itemStack) {
        IElectricItem electricItem = this.getElectricItem(itemStack);
        if (electricItem == null) {
            return false;
        }
        return ElectricItem.manager.charge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true) > 0;
    }
}

