/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.tile.ExplosionWhitelist;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IC2Potion;
import ic2.core.block.EntityNuke;
import ic2.core.item.armor.ItemArmorHazmat;
import ic2.core.util.Util;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ExplosionIC2
extends Explosion {
    private final Random ExplosionRNG = new Random();
    private final World worldObj;
    private final int mapHeight;
    public double field_77284_b;
    public double field_77285_c;
    public double field_77282_d;
    public Entity field_77283_e;
    public float power;
    public float explosionDropRate;
    public float explosionDamage;
    public boolean nuclear = false;
    public String igniter;
    public List entitiesInRange = new ArrayList();
    public Map vecMap = new HashMap();
    public Map destroyedBlockPositions = new HashMap();
    private ChunkCache chunkCache;
    private final double dropPowerLimit = 8.0;
    private final double damageAtDropPowerLimit = 32.0;
    private final double accelerationAtDropPowerLimit = 0.7;
    private final int secondaryRayCount = 5;

    public ExplosionIC2(World world, Entity entity, double x, double y, double z, float power, float drop, float entitydamage) {
        super(world, entity, x, y, z, power);
        this.worldObj = world;
        this.mapHeight = IC2.getWorldHeight(world);
        this.field_77283_e = entity;
        this.power = power;
        this.explosionDropRate = drop;
        this.explosionDamage = entitydamage;
        this.field_77284_b = x;
        this.field_77285_c = y;
        this.field_77282_d = z;
    }

    public ExplosionIC2(World world, Entity entity, double x, double y, double z, float power, float drop, float entitydamage, boolean nuclear) {
        this(world, entity, x, y, z, power, drop, entitydamage);
        this.nuclear = nuclear;
    }

    public ExplosionIC2(World world, Entity entity, double x, double y, double z, float power, float drop, float entitydamage, String igniter) {
        this(world, entity, x, y, z, power, drop, entitydamage);
        this.igniter = igniter;
    }

    public void doExplosion() {
        boolean entitiesAreInRange;
        if (this.power <= 0.0f) {
            return;
        }
        double maxDistance = (double)this.power / 0.4;
        int maxDistanceInt = (int)Math.ceil(maxDistance);
        this.chunkCache = new ChunkCache(this.worldObj, (int)this.field_77284_b - maxDistanceInt, (int)this.field_77285_c - maxDistanceInt, (int)this.field_77282_d - maxDistanceInt, (int)this.field_77284_b + maxDistanceInt, (int)this.field_77285_c + maxDistanceInt, (int)this.field_77282_d + maxDistanceInt, 0);
        List entities = this.worldObj.func_72839_b(null, AxisAlignedBB.func_72332_a().func_72299_a(this.field_77284_b - maxDistance, this.field_77285_c - maxDistance, this.field_77282_d - maxDistance, this.field_77284_b + maxDistance, this.field_77285_c + maxDistance, this.field_77282_d + maxDistance));
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving) && !(entity instanceof EntityItem)) continue;
            this.entitiesInRange.add(new AbstractMap.SimpleEntry<Integer, Entity>((int)((entity.field_70165_t - this.field_77284_b) * (entity.field_70165_t - this.field_77284_b) + (entity.field_70163_u - this.field_77285_c) * (entity.field_70163_u - this.field_77285_c) + (entity.field_70161_v - this.field_77282_d) * (entity.field_70161_v - this.field_77282_d)), entity));
        }
        boolean bl = entitiesAreInRange = !this.entitiesInRange.isEmpty();
        if (entitiesAreInRange) {
            Collections.sort(this.entitiesInRange, new Comparator(){

                public int compare(Map.Entry a, Map.Entry b) {
                    return (Integer)a.getKey() - (Integer)b.getKey();
                }
            });
        }
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / maxDistance));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int theta_n = 0; theta_n < steps; ++theta_n) {
                double phi = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)theta_n;
                this.shootRay(this.field_77284_b, this.field_77285_c, this.field_77282_d, phi, theta, this.power, entitiesAreInRange && phi_n % 8 == 0 && theta_n % 8 == 0);
            }
        }
        if (this.isNuclear()) {
            for (EntityLiving entity : this.worldObj.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a(this.field_77284_b - 100.0, this.field_77285_c - 100.0, this.field_77282_d - 100.0, this.field_77284_b + 100.0, this.field_77285_c + 100.0, this.field_77282_d + 100.0))) {
                if (ItemArmorHazmat.hasCompleteHazmat(entity)) continue;
                double distance = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d);
                int hungerLength = (int)(120.0 * (100.0 - distance));
                int poisonLength = (int)(80.0 * (30.0 - distance));
                if (hungerLength >= 0) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, hungerLength, 0));
                }
                if (poisonLength < 0) continue;
                entity.func_70690_d(new PotionEffect(IC2Potion.radiation.field_76415_H, poisonLength, 0));
            }
        }
        IC2.network.initiateExplosionEffect(this.worldObj, this.field_77284_b, this.field_77285_c, this.field_77282_d);
        HashMap blocksToDrop = new HashMap();
        for (Map.Entry entry : this.destroyedBlockPositions.entrySet()) {
            int x = ((ChunkPosition)entry.getKey()).field_76930_a;
            int y = ((ChunkPosition)entry.getKey()).field_76928_b;
            int z = ((ChunkPosition)entry.getKey()).field_76929_c;
            int blockId = this.chunkCache.func_72798_a(x, y, z);
            if (blockId == 0) continue;
            if (((Boolean)entry.getValue()).booleanValue()) {
                double effectX = (float)x + this.worldObj.field_73012_v.nextFloat();
                double effectY = (float)y + this.worldObj.field_73012_v.nextFloat();
                double effectZ = (float)z + this.worldObj.field_73012_v.nextFloat();
                double d3 = effectX - this.field_77284_b;
                double d4 = effectY - this.field_77285_c;
                double d5 = effectZ - this.field_77282_d;
                double effectDistance = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                d3 /= effectDistance;
                d4 /= effectDistance;
                d5 /= effectDistance;
                double d7 = 0.5 / (effectDistance / (double)this.power + 0.1);
                this.worldObj.func_72869_a("explode", (effectX + this.field_77284_b) / 2.0, (effectY + this.field_77285_c) / 2.0, (effectZ + this.field_77282_d) / 2.0, d3 *= (d7 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                this.worldObj.func_72869_a("smoke", effectX, effectY, effectZ, d3, d4, d5);
                Block block = Block.field_71973_m[blockId];
                int meta = this.worldObj.func_72805_g(x, y, z);
                for (ItemStack itemStack : block.getBlockDropped(this.worldObj, x, y, z, meta, 0)) {
                    ItemWithMeta itemWithMeta;
                    Map map;
                    if (!(this.worldObj.field_73012_v.nextFloat() <= this.explosionDropRate)) continue;
                    XZposition xZposition = new XZposition(x / 2, z / 2);
                    if (!blocksToDrop.containsKey(xZposition)) {
                        blocksToDrop.put(xZposition, new HashMap());
                    }
                    if (!(map = (Map)blocksToDrop.get(xZposition)).containsKey(itemWithMeta = new ItemWithMeta(itemStack.field_77993_c, itemStack.func_77960_j()))) {
                        map.put(itemWithMeta, new DropData(itemStack.field_77994_a, y));
                        continue;
                    }
                    map.put(itemWithMeta, ((DropData)map.get(itemWithMeta)).add(itemStack.field_77994_a, y));
                }
            }
            this.worldObj.func_72832_d(x, y, z, 0, 0, 7);
            Block.field_71973_m[blockId].func_71867_k(this.worldObj, x, y, z, (Explosion)this);
        }
        for (Map.Entry entry : blocksToDrop.entrySet()) {
            XZposition xZposition = (XZposition)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                int stackSize;
                ItemWithMeta itemWithMeta = (ItemWithMeta)entry2.getKey();
                for (int count = ((DropData)entry2.getValue()).n; count > 0; count -= stackSize) {
                    stackSize = Math.min(count, 64);
                    EntityItem entityitem = new EntityItem(this.worldObj, (double)((float)xZposition.x + this.worldObj.field_73012_v.nextFloat()) * 2.0, (double)((DropData)entry2.getValue()).maxY + 0.5, (double)((float)xZposition.z + this.worldObj.field_73012_v.nextFloat()) * 2.0, new ItemStack(itemWithMeta.itemId, stackSize, itemWithMeta.metaData));
                    entityitem.field_70293_c = 10;
                    this.worldObj.func_72838_d((Entity)entityitem);
                }
            }
        }
    }

    private void shootRay(double x, double y, double z, double phi, double theta, double power, boolean killEntities) {
        int blockY;
        double deltaX = Math.sin(theta) * Math.cos(phi);
        double deltaY = Math.cos(theta);
        double deltaZ = Math.sin(theta) * Math.sin(phi);
        int step = 0;
        while ((blockY = Util.roundToNegInf(y)) >= 0 && blockY < this.mapHeight) {
            int blockX = Util.roundToNegInf(x);
            int blockZ = Util.roundToNegInf(z);
            int blockId = this.chunkCache.func_72798_a(blockX, blockY, blockZ);
            double absorption = 0.5;
            if (blockId > 0) {
                absorption += ((double)Block.field_71973_m[blockId].getExplosionResistance(this.field_77283_e, this.worldObj, blockX, blockY, blockZ, this.field_77284_b, this.field_77285_c, this.field_77282_d) + 4.0) * 0.3;
            }
            if (absorption > 1000.0 && !ExplosionWhitelist.isBlockWhitelisted(Block.field_71973_m[blockId])) {
                absorption = 0.5;
            } else {
                if (absorption > power) break;
                if (blockId > 0) {
                    ChunkPosition position = new ChunkPosition(blockX, blockY, blockZ);
                    if (power > 8.0) {
                        this.destroyedBlockPositions.put(position, false);
                    } else if (!this.destroyedBlockPositions.containsKey(position)) {
                        this.destroyedBlockPositions.put(position, true);
                    }
                }
            }
            if (killEntities && (step + 4) % 8 == 0 && power >= 0.25) {
                int index;
                if (step != 4) {
                    int distanceMin = step * step - 25;
                    int indexStart = 0;
                    int indexEnd = this.entitiesInRange.size() - 1;
                    do {
                        int distance;
                        if ((distance = ((Integer)((Map.Entry)this.entitiesInRange.get(index = (indexStart + indexEnd) / 2)).getKey()).intValue()) < distanceMin) {
                            indexStart = index + 1;
                            continue;
                        }
                        indexEnd = distance > distanceMin ? index - 1 : index;
                    } while (indexStart < indexEnd);
                } else {
                    index = 0;
                }
                int distanceMax = step * step + 25;
                for (int i = index; i < this.entitiesInRange.size() && (Integer)((Map.Entry)this.entitiesInRange.get(index)).getKey() < distanceMax; ++i) {
                    Entity entity = (Entity)((Map.Entry)this.entitiesInRange.get(index)).getValue();
                    if (!((entity.field_70165_t - x) * (entity.field_70165_t - x) + (entity.field_70163_u - y) * (entity.field_70163_u - y) + (entity.field_70161_v - z) * (entity.field_70161_v - z) <= 25.0)) continue;
                    entity.func_70097_a(this.getDamageSource(), (int)(32.0 * power / 8.0));
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer entityPlayer = (EntityPlayer)entity;
                        if (this.isNuclear() && this.igniter != null && entityPlayer.field_71092_bJ.equals(this.igniter) && entityPlayer.func_70630_aN() <= 0) {
                            IC2.achievements.issueAchievement(entityPlayer, "dieFromOwnNuke");
                        }
                    }
                    double dx = entity.field_70165_t - this.field_77284_b;
                    double dy = entity.field_70163_u - this.field_77285_c;
                    double dz = entity.field_70161_v - this.field_77282_d;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    entity.field_70159_w += dx / distance * 0.7 * power / 8.0;
                    entity.field_70181_x += dy / distance * 0.7 * power / 8.0;
                    entity.field_70179_y += dz / distance * 0.7 * power / 8.0;
                    if (entity.func_70089_S()) continue;
                    this.entitiesInRange.remove(i);
                    --i;
                }
            }
            if (absorption > 10.0) {
                for (int i = 0; i < 5; ++i) {
                    this.shootRay(x, y, z, this.ExplosionRNG.nextDouble() * 2.0 * Math.PI, this.ExplosionRNG.nextDouble() * Math.PI, absorption * 0.4, false);
                }
            }
            power -= absorption;
            x += deltaX;
            y += deltaY;
            z += deltaZ;
            ++step;
        }
    }

    private DamageSource getDamageSource() {
        if (this.isNuclear()) {
            return IC2DamageSource.nuke;
        }
        return DamageSource.func_94539_a((Explosion)this);
    }

    private boolean isNuclear() {
        return this.nuclear || this.field_77283_e instanceof EntityNuke;
    }

    static class DropData {
        int n;
        int maxY;

        DropData(int n, int y) {
            this.n = n;
            this.maxY = y;
        }

        public DropData add(int n, int y) {
            this.n += n;
            if (y > this.maxY) {
                this.maxY = y;
            }
            return this;
        }
    }

    static class ItemWithMeta {
        int itemId;
        int metaData;

        ItemWithMeta(int itemId, int metaData) {
            this.itemId = itemId;
            this.metaData = metaData;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemWithMeta) {
                ItemWithMeta itemWithMeta = (ItemWithMeta)obj;
                return itemWithMeta.itemId == this.itemId && itemWithMeta.metaData == this.metaData;
            }
            return false;
        }

        public int hashCode() {
            return this.itemId * 31 ^ this.metaData;
        }
    }

    static class XZposition {
        int x;
        int z;

        XZposition(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (obj instanceof XZposition) {
                XZposition xZposition = (XZposition)obj;
                return xZposition.x == this.x && xZposition.z == this.z;
            }
            return false;
        }

        public int hashCode() {
            return this.x * 31 ^ this.z;
        }
    }
}

