/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureStitched;
import net.minecraft.client.texturepacks.ITexturePack;

@SideOnly(value=Side.CLIENT)
public class BlockTextureStitched
extends TextureStitched {
    private int[] comparisonImage;
    private TextureStitched mappedTexture;
    private static Map existingTextures = new HashMap();

    public BlockTextureStitched(String name) {
        super(name);
    }

    public void func_94217_a(TextureStitched textureStitched) {
        if (textureStitched.func_94215_i().equals("missingno") && this.mappedTexture != null) {
            super.func_94217_a(this.mappedTexture);
        } else {
            super.func_94217_a(textureStitched);
        }
    }

    public boolean loadTexture(TextureManager manager, ITexturePack texturepack, String name, String fileName, BufferedImage image, ArrayList textures) {
        BufferedImage bufferedImage;
        int extStart = fileName.lastIndexOf(46);
        int indexStart = fileName.lastIndexOf(46, extStart - 1);
        String textureFile = "/" + fileName.substring(0, indexStart) + ".png";
        int index = Integer.parseInt(fileName.substring(indexStart + 1, extStart));
        try {
            bufferedImage = ImageIO.read(texturepack.func_77532_a(textureFile));
        }
        catch (IOException e) {
            IC2.log.warning("can't read texture " + textureFile);
            return false;
        }
        int size = bufferedImage.getHeight();
        int count = bufferedImage.getWidth() / size;
        if (count == 1 || count == 6 || count == 12) {
            index %= count;
        } else if (count == 2) {
            index /= 6;
        } else {
            IC2.log.warning("texture " + textureFile + " is not properly sized");
            return false;
        }
        bufferedImage = bufferedImage.getSubimage(index * size, 0, size, size);
        int[] rgbaData = new int[size * size];
        bufferedImage.getRGB(0, 0, size, size, rgbaData, 0, size);
        int hash = Arrays.hashCode(rgbaData);
        ArrayList<BlockTextureStitched> matchingTextures = (ArrayList<BlockTextureStitched>)existingTextures.get(hash);
        if (matchingTextures != null) {
            for (BlockTextureStitched matchingTexture : matchingTextures) {
                if (!Arrays.equals(rgbaData, matchingTexture.comparisonImage)) continue;
                this.mappedTexture = matchingTexture;
                return true;
            }
            matchingTextures.add(this);
        } else {
            matchingTextures = new ArrayList<BlockTextureStitched>();
            matchingTextures.add(this);
            existingTextures.put(hash, matchingTextures);
        }
        this.comparisonImage = rgbaData;
        Texture texture = new Texture(name, 2, size, size, 10496, 6408, 9728, 9728, bufferedImage);
        textures.add(texture);
        return true;
    }

    public static void onPostStitch() {
        for (List textures : existingTextures.values()) {
            for (BlockTextureStitched texture : textures) {
                texture.comparisonImage = null;
            }
        }
        existingTextures.clear();
    }
}

