/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.invslot.InvSlotConsumableLiquidContainer;
import ic2.core.block.machine.ContainerPump;
import ic2.core.block.machine.gui.GuiPump;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.liquids.ILiquid;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class TileEntityPump
extends TileEntityElectricMachine
implements IHasGui {
    public int soundTicker = IC2.random.nextInt(64);
    public short pumpCharge = 0;
    private AudioSource audioSource;
    private int lastX;
    private int lastY;
    private int lastZ;
    public InvSlotConsumableLiquidContainer containerSlot = new InvSlotConsumableLiquidContainer(this, "container", 0, 1);

    public TileEntityPump() {
        super(200, 1, 1);
    }

    @Override
    public String func_70303_b() {
        return "Pump";
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.isPumpReady()) {
            if (this.energy > 0) {
                --this.energy;
                this.pumpCharge = (short)(this.pumpCharge + 1);
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        } else if (this.operate(null)) {
            this.pumpCharge = 0;
            this.func_70296_d();
            this.setActive(true);
        } else {
            this.setActive(false);
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public boolean operate(ChunkCoordinates coords) {
        LiquidStack liquid;
        if (!this.canHarvest()) {
            return false;
        }
        LiquidStack liquidStack = liquid = coords == null ? this.pump() : this.pump(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (liquid != null) {
            if (liquid.itemID != Block.field_71938_D.field_71990_ca || !this.deliverLavaToGeo()) {
                ItemStack filled = this.containerSlot.fill(liquid, false);
                if (filled != null) {
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    drops.add(filled);
                    StackUtil.distributeDrop(this, drops);
                } else if (!this.putInChestBucket(liquid)) {
                    return false;
                }
            }
            this.clearLastBlock();
            return true;
        }
        return false;
    }

    public LiquidStack pump() {
        return this.pump(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
    }

    public void clearLastBlock() {
        this.field_70331_k.func_94571_i(this.lastX, this.lastY, this.lastZ);
    }

    public LiquidStack pump(int x, int y, int z) {
        this.lastX = x;
        this.lastY = y;
        this.lastZ = z;
        int blockId = this.field_70331_k.func_72798_a(x, y, z);
        if (blockId == 0) {
            return null;
        }
        LiquidStack ret = null;
        if (Block.field_71973_m[blockId] instanceof ILiquid) {
            ILiquid liquid = (ILiquid)Block.field_71973_m[blockId];
            if (this.field_70331_k.func_72805_g(x, y, z) != liquid.stillLiquidMeta() && (blockId != liquid.stillLiquidId() || liquid.isMetaSensitive())) {
                return null;
            }
            ret = new LiquidStack(liquid.stillLiquidId(), 1000, liquid.stillLiquidMeta());
        } else if (blockId == Block.field_71943_B.field_71990_ca || blockId == Block.field_71942_A.field_71990_ca) {
            if (this.field_70331_k.func_72805_g(x, y, z) != 0) {
                return null;
            }
            ret = new LiquidStack(Block.field_71943_B, 1000);
        } else if (blockId == Block.field_71938_D.field_71990_ca || blockId == Block.field_71944_C.field_71990_ca) {
            if (this.field_70331_k.func_72805_g(x, y, z) != 0) {
                return null;
            }
            ret = new LiquidStack(Block.field_71938_D, 1000);
        }
        return ret;
    }

    public boolean putInChestBucket(LiquidStack liquid) {
        return this.putInChestBucket(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, liquid) || this.putInChestBucket(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, liquid) || this.putInChestBucket(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, liquid) || this.putInChestBucket(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, liquid) || this.putInChestBucket(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, liquid) || this.putInChestBucket(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, liquid);
    }

    public boolean putInChestBucket(int x, int y, int z, LiquidStack liquid) {
        if (!(this.field_70331_k.func_72796_p(x, y, z) instanceof TileEntityChest)) {
            return false;
        }
        TileEntityChest chest = (TileEntityChest)this.field_70331_k.func_72796_p(x, y, z);
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            ItemStack filled;
            ItemStack container = chest.func_70301_a(i);
            if (container == null || (filled = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)liquid, (ItemStack)container)) == null) continue;
            --container.field_77994_a;
            if (container.field_77994_a <= 0) {
                chest.func_70299_a(i, filled);
            } else {
                for (int j = 0; j < chest.func_70302_i_(); ++j) {
                    ItemStack itemStack = chest.func_70301_a(j);
                    if (itemStack == null) {
                        chest.func_70299_a(j, filled);
                        return true;
                    }
                    if (!StackUtil.isStackEqual(itemStack, filled) || itemStack.field_77994_a >= itemStack.func_77976_d()) continue;
                    ++itemStack.field_77994_a;
                    return true;
                }
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                drops.add(filled);
                StackUtil.distributeDrop(this, drops);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.pumpCharge = nbttagcompound.func_74765_d("pumpCharge");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("pumpCharge", this.pumpCharge);
    }

    public boolean isPumpReady() {
        return this.pumpCharge >= 200;
    }

    public boolean canHarvest() {
        if (!this.isPumpReady()) {
            return false;
        }
        return !this.containerSlot.isEmpty() || this.isBucketInChestAvaible();
    }

    public boolean isBucketInChestAvaible() {
        return this.isBucketInChestAvaible(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) || this.isBucketInChestAvaible(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) || this.isBucketInChestAvaible(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) || this.isBucketInChestAvaible(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) || this.isBucketInChestAvaible(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) || this.isBucketInChestAvaible(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
    }

    public boolean isBucketInChestAvaible(int x, int y, int z) {
        if (!(this.field_70331_k.func_72796_p(x, y, z) instanceof TileEntityChest)) {
            return false;
        }
        TileEntityChest chest = (TileEntityChest)this.field_70331_k.func_72796_p(x, y, z);
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (chest.func_70301_a(i) == null || chest.func_70301_a((int)i).field_77993_c != Item.field_77788_aw.field_77779_bT) continue;
            return true;
        }
        return false;
    }

    public boolean deliverLavaToGeo() {
        int lava = 3000;
        if (lava > 0 && this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)).distributeLava(lava);
        }
        if (lava > 0 && this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n)).distributeLava(lava);
        }
        if (lava > 0 && this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n)).distributeLava(lava);
        }
        if (lava > 0 && this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n)).distributeLava(lava);
        }
        if (lava > 0 && this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1)).distributeLava(lava);
        }
        if (lava > 0 && this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1)).distributeLava(lava);
        }
        return lava < 2980;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer) {
        return new GuiPump(new ContainerPump(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/PumpOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }
}

