/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.ContainerStandardMachine;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityStandardMachine
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener {
    public short progress = 0;
    public int defaultEnergyConsume;
    public int defaultOperationLength;
    public int defaultMaxInput;
    public int defaultEnergyStorage;
    public int energyConsume;
    public int operationLength;
    public float serverChargeLevel;
    public float serverProgress;
    public AudioSource audioSource;
    private static final int EventStart = 0;
    private static final int EventInterrupt = 1;
    private static final int EventStop = 2;
    public InvSlot inputSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlotUpgrade upgradeSlot;

    public TileEntityStandardMachine(int energyPerTick, int length) {
        super(energyPerTick * length, 1, 1);
        this.defaultEnergyConsume = this.energyConsume = energyPerTick;
        this.defaultOperationLength = this.operationLength = length;
        this.defaultMaxInput = this.maxInput;
        this.defaultEnergyStorage = energyPerTick * length;
        this.outputSlot = new InvSlotOutput(this, "output", 2, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, "upgrade", 3, 4);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public float getChargeLevel() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.energy / (float)(this.maxEnergy - this.maxInput + 1);
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverChargeLevel;
        }
        return ret;
    }

    public float getProgress() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.progress / (float)this.operationLength;
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverProgress;
        }
        return ret;
    }

    public void setChargeLevel(float chargeLevel) {
        assert (!IC2.platform.isSimulating());
        this.serverChargeLevel = chargeLevel;
    }

    public void setProgress(float progress) {
        assert (!IC2.platform.isSimulating());
        this.serverProgress = progress;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 0) {
            return this.getResultFor(itemStack, false) != null;
        }
        return super.func_94041_b(slot, itemStack);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        boolean canOperate = this.canOperate();
        boolean needsInvUpdate = false;
        boolean newActive = this.getActive();
        if (this.progress >= this.operationLength) {
            this.operate();
            needsInvUpdate = true;
            this.progress = 0;
            newActive = false;
            IC2.network.initiateTileEntityEvent(this, 2, true);
        }
        canOperate = this.canOperate();
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy >= this.energyConsume) {
                    newActive = true;
                    IC2.network.initiateTileEntityEvent(this, 0, true);
                }
            } else {
                this.progress = 0;
            }
        } else if (!canOperate || this.energy < this.energyConsume) {
            if (!canOperate) {
                this.progress = 0;
            }
            newActive = false;
            IC2.network.initiateTileEntityEvent(this, 1, true);
        }
        if (newActive) {
            this.progress = (short)(this.progress + 1);
            this.energy -= this.energyConsume;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
    }

    public void setOverclockRates() {
        int overclockerUpgradeCount = 0;
        int transformerUpgradeCount = 0;
        int energyStorageUpgradeCount = 0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack itemStack = this.upgradeSlot.get(i);
            if (itemStack == null) continue;
            if (itemStack.func_77969_a(Ic2Items.overclockerUpgrade)) {
                overclockerUpgradeCount += itemStack.field_77994_a;
                continue;
            }
            if (itemStack.func_77969_a(Ic2Items.transformerUpgrade)) {
                transformerUpgradeCount += itemStack.field_77994_a;
                continue;
            }
            if (!itemStack.func_77969_a(Ic2Items.energyStorageUpgrade)) continue;
            energyStorageUpgradeCount += itemStack.field_77994_a;
        }
        if (overclockerUpgradeCount > 32) {
            overclockerUpgradeCount = 32;
        }
        if (transformerUpgradeCount > 10) {
            transformerUpgradeCount = 10;
        }
        double previousProgress = (double)this.progress / (double)this.operationLength;
        this.energyConsume = (int)((double)this.defaultEnergyConsume * Math.pow(1.6, overclockerUpgradeCount));
        this.operationLength = (int)Math.round((double)this.defaultOperationLength * Math.pow(0.7, overclockerUpgradeCount));
        this.maxInput = this.defaultMaxInput * (int)Math.pow(4.0, transformerUpgradeCount);
        this.maxEnergy = this.defaultEnergyStorage + energyStorageUpgradeCount * 10000 + this.maxInput - 1;
        this.setTier(transformerUpgradeCount + 1);
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.round(previousProgress * (double)this.operationLength);
    }

    public void operate() {
        ItemStack processResult;
        if (!this.canOperate()) {
            return;
        }
        if (this.inputSlot.get().func_77973_b().func_77634_r()) {
            processResult = this.getResultFor(this.inputSlot.get(), false).func_77946_l();
            this.inputSlot.put(this.inputSlot.get().func_77973_b().getContainerItemStack(this.inputSlot.get()));
        } else {
            processResult = this.getResultFor(this.inputSlot.get(), true).func_77946_l();
        }
        if (this.inputSlot.get().field_77994_a <= 0) {
            this.inputSlot.clear();
        }
        this.outputSlot.add(processResult);
    }

    public boolean canOperate() {
        if (this.inputSlot.isEmpty()) {
            return false;
        }
        ItemStack processResult = this.getResultFor(this.inputSlot.get(), false);
        if (processResult == null) {
            return false;
        }
        return this.outputSlot.canAdd(processResult);
    }

    public abstract ItemStack getResultFor(ItemStack var1, boolean var2);

    @Override
    public abstract String func_70303_b();

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerStandardMachine(entityPlayer, this);
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource(this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IC2.audioManager.playOnce(this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }
}

