/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.core.block.wiring.TileEntityCable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;

@SideOnly(value=Side.CLIENT)
public class RenderBlockCable
implements ISimpleBlockRenderingHandler {
    private static final Direction[] directions = Direction.values();
    public static int renderId;

    public RenderBlockCable() {
        renderId = RenderingRegistry.getNextAvailableRenderId();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int x, int y, int z, Block block, int modelId, RenderBlocks renderblocks) {
        TileEntity te = iBlockAccess.func_72796_p(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return true;
        }
        TileEntityCable cable = (TileEntityCable)te;
        if (cable.foamed > 0) {
            renderblocks.func_78570_q(block, x, y, z);
        } else {
            float th = cable.getCableThickness();
            float sp = (1.0f - th) / 2.0f;
            int connectivity = 0;
            int renderSide = 0;
            int mask = 1;
            for (Direction direction : directions) {
                TileEntity neighbor = direction.applyToTileEntity(cable);
                if ((neighbor instanceof IEnergyAcceptor && ((IEnergyAcceptor)neighbor).acceptsEnergyFrom(cable, direction.getInverse()) || neighbor instanceof IEnergyEmitter && ((IEnergyEmitter)neighbor).emitsEnergyTo(cable, direction.getInverse())) && cable.canInteractWith(neighbor)) {
                    connectivity |= mask;
                    if (neighbor instanceof TileEntityCable && ((TileEntityCable)neighbor).getCableThickness() < th) {
                        renderSide |= mask;
                    }
                }
                mask *= 2;
            }
            Icon[] textures = new Icon[6];
            for (int side = 0; side < 6; ++side) {
                Icon icon = block.func_71895_b(iBlockAccess, x, y, z, side);
                textures[side] = icon != null ? icon : renderblocks.field_94177_n.field_71446_o.func_96448_c(0);
            }
            Tessellator tessellator = Tessellator.field_78398_a;
            double xD = x;
            double yD = y;
            double zD = z;
            tessellator.func_78380_c(block.func_71874_e(iBlockAccess, x, y, z));
            if (connectivity == 0) {
                block.func_71905_a(sp, sp, sp, sp + th, sp + th, sp + th);
                renderblocks.func_83018_a(block);
                tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                renderblocks.func_78613_a(block, xD, yD, zD, textures[0]);
                tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                renderblocks.func_78617_b(block, xD, yD, zD, textures[1]);
                tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                renderblocks.func_78611_c(block, xD, yD, zD, textures[2]);
                renderblocks.func_78622_d(block, xD, (double)y, zD, textures[3]);
                tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                renderblocks.func_78573_e(block, xD, yD, zD, textures[4]);
                renderblocks.func_78605_f(block, xD, yD, zD, textures[5]);
            } else if (connectivity == 3) {
                block.func_71905_a(0.0f, sp, sp, 1.0f, sp + th, sp + th);
                renderblocks.func_83018_a(block);
                tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                renderblocks.func_78613_a(block, xD, yD, zD, textures[0]);
                tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                renderblocks.func_78617_b(block, xD, yD, zD, textures[1]);
                tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                renderblocks.func_78611_c(block, xD, yD, zD, textures[2]);
                renderblocks.func_78622_d(block, xD, (double)y, zD, textures[3]);
                if ((renderSide & 1) != 0) {
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_78573_e(block, xD, yD, zD, textures[4]);
                }
                if ((renderSide & 2) != 0) {
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_78605_f(block, xD, yD, zD, textures[5]);
                }
            } else if (connectivity == 12) {
                block.func_71905_a(sp, 0.0f, sp, sp + th, 1.0f, sp + th);
                renderblocks.func_83018_a(block);
                tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                renderblocks.func_78611_c(block, xD, yD, zD, textures[2]);
                renderblocks.func_78622_d(block, xD, (double)y, zD, textures[3]);
                tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                renderblocks.func_78573_e(block, xD, yD, zD, textures[4]);
                renderblocks.func_78605_f(block, xD, yD, zD, textures[5]);
                if ((renderSide & 4) != 0) {
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_78613_a(block, xD, yD, zD, textures[0]);
                }
                if ((renderSide & 8) != 0) {
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_78617_b(block, xD, yD, zD, textures[1]);
                }
            } else if (connectivity == 48) {
                block.func_71905_a(sp, sp, 0.0f, sp + th, sp + th, 1.0f);
                renderblocks.func_83018_a(block);
                tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                renderblocks.func_78613_a(block, xD, yD, zD, textures[0]);
                tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                renderblocks.func_78617_b(block, xD, yD, zD, textures[1]);
                tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                renderblocks.func_78573_e(block, xD, yD, zD, textures[4]);
                renderblocks.func_78605_f(block, xD, yD, zD, textures[5]);
                if ((renderSide & 0x10) != 0) {
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_78611_c(block, xD, (double)y, zD, textures[2]);
                }
                if ((renderSide & 0x20) != 0) {
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_78622_d(block, xD, yD, zD, textures[3]);
                }
            } else {
                if ((connectivity & 1) == 0) {
                    block.func_71905_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_78573_e(block, xD, yD, zD, textures[4]);
                } else {
                    block.func_71905_a(0.0f, sp, sp, sp, sp + th, sp + th);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_78613_a(block, xD, yD, zD, textures[0]);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_78617_b(block, xD, yD, zD, textures[1]);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_78611_c(block, xD, yD, zD, textures[2]);
                    renderblocks.func_78622_d(block, xD, (double)y, zD, textures[3]);
                    if ((renderSide & 1) != 0) {
                        tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                        renderblocks.func_78573_e(block, xD, yD, zD, textures[4]);
                    }
                }
                if ((connectivity & 2) == 0) {
                    block.func_71905_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_78605_f(block, xD, yD, zD, textures[5]);
                } else {
                    block.func_71905_a(sp + th, sp, sp, 1.0f, sp + th, sp + th);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_78613_a(block, xD, yD, zD, textures[0]);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_78617_b(block, xD, yD, zD, textures[1]);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_78611_c(block, xD, yD, zD, textures[2]);
                    renderblocks.func_78622_d(block, xD, (double)y, zD, textures[3]);
                    if ((renderSide & 2) != 0) {
                        tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                        renderblocks.func_78605_f(block, xD, yD, zD, textures[5]);
                    }
                }
                if ((connectivity & 4) == 0) {
                    block.func_71905_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_78613_a(block, xD, yD, zD, textures[0]);
                } else {
                    block.func_71905_a(sp, 0.0f, sp, sp + th, sp, sp + th);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_78611_c(block, xD, yD, zD, textures[2]);
                    renderblocks.func_78622_d(block, xD, (double)y, zD, textures[3]);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_78573_e(block, xD, yD, zD, textures[4]);
                    renderblocks.func_78605_f(block, xD, yD, zD, textures[5]);
                    if ((renderSide & 4) != 0) {
                        tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                        renderblocks.func_78613_a(block, xD, yD, zD, textures[0]);
                    }
                }
                if ((connectivity & 8) == 0) {
                    block.func_71905_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_78617_b(block, xD, yD, zD, textures[1]);
                } else {
                    block.func_71905_a(sp, sp + th, sp, sp + th, 1.0f, sp + th);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_78611_c(block, xD, yD, zD, textures[2]);
                    renderblocks.func_78622_d(block, xD, (double)y, zD, textures[3]);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_78573_e(block, xD, yD, zD, textures[4]);
                    renderblocks.func_78605_f(block, xD, yD, zD, textures[5]);
                    if ((renderSide & 8) != 0) {
                        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                        renderblocks.func_78617_b(block, xD, yD, zD, textures[1]);
                    }
                }
                if ((connectivity & 0x10) == 0) {
                    block.func_71905_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_78611_c(block, xD, (double)y, zD, textures[2]);
                } else {
                    block.func_71905_a(sp, sp, 0.0f, sp + th, sp + th, sp);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_78613_a(block, xD, yD, zD, textures[0]);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_78617_b(block, xD, yD, zD, textures[1]);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_78573_e(block, xD, yD, zD, textures[4]);
                    renderblocks.func_78605_f(block, xD, yD, zD, textures[5]);
                    if ((renderSide & 0x10) != 0) {
                        tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                        renderblocks.func_78611_c(block, xD, (double)y, zD, textures[2]);
                    }
                }
                if ((connectivity & 0x20) == 0) {
                    block.func_71905_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_78622_d(block, xD, yD, zD, textures[3]);
                } else {
                    block.func_71905_a(sp, sp, sp + th, sp + th, sp + th, 1.0f);
                    renderblocks.func_83018_a(block);
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_78613_a(block, xD, yD, zD, textures[0]);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_78617_b(block, xD, yD, zD, textures[1]);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_78573_e(block, xD, yD, zD, textures[4]);
                    renderblocks.func_78605_f(block, xD, yD, zD, textures[5]);
                    if ((renderSide & 0x20) != 0) {
                        tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                        renderblocks.func_78622_d(block, xD, yD, zD, textures[3]);
                    }
                }
            }
            block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            renderblocks.func_83018_a(block);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return false;
    }

    public int getRenderId() {
        return renderId;
    }
}

