/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.tile.IEnergyStorage;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotCharge;
import ic2.core.block.invslot.InvSlotDischarge;
import ic2.core.block.wiring.ContainerElectricBlock;
import ic2.core.block.wiring.GuiElectricBlock;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StringTranslate;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TileEntityElectricBlock
extends TileEntityInventory
implements IEnergySink,
IEnergySource,
IHasGui,
INetworkClientTileEntityEventListener,
IEnergyStorage {
    public StringTranslate translate;
    public final int tier;
    public int output;
    public int maxStorage;
    public int energy = 0;
    public byte redstoneMode = 0;
    public static byte redstoneModes = (byte)6;
    private boolean isEmittingRedstone = false;
    private int redstoneUpdateInhibit = 5;
    public boolean addedToEnergyNet = false;
    public final InvSlotCharge chargeSlot;
    public final InvSlotDischarge dischargeSlot;

    public TileEntityElectricBlock(int tier, int output, int maxStorage) {
        this.tier = tier;
        this.output = output;
        this.maxStorage = maxStorage;
        this.translate = StringTranslate.func_74808_a();
        this.chargeSlot = new InvSlotCharge(this, 0, tier);
        this.dischargeSlot = new InvSlotDischarge(this, 1, tier, InvSlot.InvSide.BOTTOM);
    }

    public String getNameByTier() {
        switch (this.tier) {
            case 1: {
                return this.translate.func_74805_b("ic2.blockBatBox");
            }
            case 2: {
                return this.translate.func_74805_b("ic2.blockMFE");
            }
            case 3: {
                return this.translate.func_74805_b("ic2.blockMFSU");
            }
        }
        return null;
    }

    public float getChargeLevel() {
        float ret = (float)this.energy / (float)this.maxStorage;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.setActiveWithoutNotify(nbttagcompound.func_74767_n("active"));
        this.energy = nbttagcompound.func_74762_e("energy");
        if (this.maxStorage > Integer.MAX_VALUE) {
            this.energy *= 10;
        }
        this.redstoneMode = nbttagcompound.func_74771_c("redstoneMode");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        int write = this.energy;
        if (this.maxStorage > Integer.MAX_VALUE) {
            write /= 10;
        }
        nbttagcompound.func_74768_a("energy", write);
        nbttagcompound.func_74757_a("active", this.getActive());
        nbttagcompound.func_74774_a("redstoneMode", this.redstoneMode);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        boolean shouldEmitRedstone;
        super.func_70316_g();
        boolean needsInvUpdate = false;
        if (this.energy > 0) {
            int sent = this.chargeSlot.charge(this.energy);
            this.energy -= sent;
            boolean bl = needsInvUpdate = sent > 0;
        }
        if (this.demandsEnergy() > 0) {
            int gain = this.dischargeSlot.discharge(this.maxStorage - this.energy, false);
            this.energy += gain;
            boolean bl = needsInvUpdate = gain > 0;
        }
        if (!(this.energy < this.output || this.redstoneMode == 4 && this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) || this.redstoneMode == 5 && this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) && this.energy < this.maxStorage)) {
            EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, this.output);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.energy -= this.output - event.amount;
        }
        if ((shouldEmitRedstone = this.shouldEmitRedstone()) != this.isEmittingRedstone) {
            this.isEmittingRedstone = shouldEmitRedstone;
            this.setActive(this.isEmittingRedstone);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return !this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public int getMaxEnergyOutput() {
        return this.output;
    }

    @Override
    public int demandsEnergy() {
        return this.maxStorage - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.output) {
            IC2.explodeMachineAt(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return 0;
        }
        int need = amount;
        if (this.energy + amount >= this.maxStorage + this.output) {
            need = this.maxStorage + this.output - this.energy - 1;
        }
        this.energy += need;
        return amount - need;
    }

    @Override
    public int getMaxSafeInput() {
        return this.output;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectricBlock(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer) {
        return new GuiElectricBlock(new ContainerElectricBlock(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short facing) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        super.setFacing(facing);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
    }

    public boolean isEmittingRedstone() {
        return this.isEmittingRedstone;
    }

    public boolean shouldEmitRedstone() {
        boolean shouldEmitRedstone = false;
        switch (this.redstoneMode) {
            case 1: {
                shouldEmitRedstone = this.energy >= this.maxStorage;
                break;
            }
            case 2: {
                shouldEmitRedstone = this.energy > this.output && this.energy < this.maxStorage;
                break;
            }
            case 3: {
                boolean bl = shouldEmitRedstone = this.energy < this.output;
            }
        }
        if (this.isEmittingRedstone == shouldEmitRedstone || this.redstoneUpdateInhibit == 0) {
            this.redstoneUpdateInhibit = 5;
            return shouldEmitRedstone;
        }
        --this.redstoneUpdateInhibit;
        return this.isEmittingRedstone;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode >= redstoneModes) {
            this.redstoneMode = 0;
        }
        switch (this.redstoneMode) {
            case 0: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Nothing");
                break;
            }
            case 1: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if full");
                break;
            }
            case 2: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if partially filled");
                break;
            }
            case 3: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if empty");
                break;
            }
            case 4: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Do not output energy");
                break;
            }
            case 5: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Do not output energy unless full");
            }
        }
    }

    @Override
    public int getStored() {
        return this.energy;
    }

    @Override
    public int getCapacity() {
        return this.maxStorage;
    }

    @Override
    public int getOutput() {
        return this.output;
    }

    @Override
    public void setStored(int energy) {
        this.energy = energy;
    }

    @Override
    public int addEnergy(int amount) {
        this.energy += amount;
        return amount;
    }

    @Override
    public boolean isTeleporterCompatible(Direction side) {
        return true;
    }
}

