/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.armor.ItemArmorElectric;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorNanoSuit
extends ItemArmorElectric {
    public ItemArmorNanoSuit(Configuration config, InternalName internalName, int armorType) {
        super(config, internalName, InternalName.nano, armorType, 100000, 160, 2);
        if (armorType == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLiving player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = energyPerDamage > 0 ? 25 * ElectricItem.manager.getCharge(armor) / energyPerDamage : 0;
            return new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @ForgeSubscribe
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLiving entity;
        ItemStack armor;
        if (IC2.platform.isSimulating() && event.entity instanceof EntityLiving && (armor = (entity = (EntityLiving)event.entity).func_82169_q(0)) != null && armor.func_77973_b() == this) {
            int fallDamage = (int)event.distance - 3;
            if (fallDamage >= 8) {
                return;
            }
            int energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false);
                event.setCanceled(true);
            }
        }
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.9;
    }

    @Override
    public int getEnergyPerDamage() {
        return 800;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }
}

