/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.ItemTinCan;
import ic2.core.item.armor.ItemArmorElectric;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorQuantumSuit
extends ItemArmorElectric {
    private static final int[] potionRemovalCost = new int[Potion.field_76425_a.length];
    public static Map speedTickerMap = new HashMap();
    public static Map jumpChargeMap = new HashMap();
    public static Map enableQuantumSpeedOnSprintMap = new HashMap();

    public ItemArmorQuantumSuit(Configuration config, InternalName internalName, int armorType) {
        super(config, internalName, InternalName.quantum, armorType, 1000000, 1000, 3);
        if (armorType == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLiving entity, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = energyPerDamage > 0 ? 25 * ElectricItem.manager.getCharge(armor) / energyPerDamage : 0;
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return super.getProperties(entity, armor, source, damage, slot);
    }

    @ForgeSubscribe
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLiving entity;
        ItemStack armor;
        if (IC2.platform.isSimulating() && event.entity instanceof EntityLiving && (armor = (entity = (EntityLiving)event.entity).func_82169_q(0)) != null && armor.field_77993_c == this.field_77779_bT) {
            int fallDamage = (int)event.distance - 3;
            int energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false);
                event.setCanceled(true);
            }
        }
    }

    @Override
    public double getDamageAbsorptionRatio() {
        if (this.field_77881_a == 1) {
            return 1.1;
        }
        return 1.0;
    }

    @Override
    public int getEnergyPerDamage() {
        return 900;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack) {
        boolean ret = false;
        switch (this.field_77881_a) {
            case 0: {
                IC2.platform.profilerStartSection("QuantumHelmet");
                int air = player.func_70086_ai();
                if (ElectricItem.manager.canUse(itemStack, 1000) && air < 100) {
                    player.func_70050_g(air + 200);
                    ElectricItem.manager.use(itemStack, 1000, null);
                    ret = true;
                } else if (air <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                if (ElectricItem.manager.canUse(itemStack, 1000) && player.func_71024_bL().func_75121_c()) {
                    int slot = -1;
                    for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                        if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].field_77993_c != Ic2Items.filledTinCan.field_77993_c) continue;
                        slot = i;
                        break;
                    }
                    if (slot > -1) {
                        ItemTinCan can = (ItemTinCan)player.field_71071_by.field_70462_a[slot].func_77973_b();
                        player.func_71024_bL().func_75122_a(can.func_77847_f(), can.func_77846_g());
                        can.func_77849_c(player.field_71071_by.field_70462_a[slot], player.field_70170_p, player);
                        can.onEaten(player);
                        if (--player.field_71071_by.field_70462_a[slot].field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[slot] = null;
                        }
                        ElectricItem.manager.use(itemStack, 1000, null);
                        ret = true;
                    }
                } else if (player.func_71024_bL().func_75116_a() <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
                    int cost = potionRemovalCost[effect.func_76456_a()];
                    if (cost <= 0 || !ElectricItem.manager.canUse(itemStack, cost *= effect.func_76458_c() + 1)) continue;
                    ElectricItem.manager.use(itemStack, cost, null);
                    IC2.platform.removePotion((EntityLiving)player, effect.func_76456_a());
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case 1: {
                IC2.platform.profilerStartSection("QuantumBodyarmor");
                player.func_70066_B();
                IC2.platform.profilerEndSection();
                break;
            }
            case 2: {
                IC2.platform.profilerStartSection("QuantumLeggings");
                boolean enableQuantumSpeedOnSprint = true;
                if (IC2.platform.isRendering()) {
                    enableQuantumSpeedOnSprint = IC2.enableQuantumSpeedOnSprint;
                } else if (enableQuantumSpeedOnSprintMap.containsKey(player)) {
                    enableQuantumSpeedOnSprint = (Boolean)enableQuantumSpeedOnSprintMap.get(player);
                }
                if (ElectricItem.manager.canUse(itemStack, 1000) && (player.field_70122_E && Math.abs(player.field_70159_w) + Math.abs(player.field_70179_y) > (double)0.1f || player.func_70090_H()) && (enableQuantumSpeedOnSprint && player.func_70051_ag() || !enableQuantumSpeedOnSprint && IC2.keyboard.isBoostKeyDown(player))) {
                    int speedTicker;
                    int n = speedTicker = speedTickerMap.containsKey(player) ? (Integer)speedTickerMap.get(player) : 0;
                    if (++speedTicker >= 10) {
                        speedTicker = 0;
                        ElectricItem.manager.use(itemStack, 1000, null);
                        ret = true;
                    }
                    speedTickerMap.put(player, speedTicker);
                    float speed = 0.22f;
                    if (player.func_70090_H()) {
                        speed = 0.1f;
                        if (player.field_70703_bu) {
                            player.field_70181_x += (double)0.1f;
                        }
                    }
                    if (speed > 0.0f) {
                        player.func_70060_a(0.0f, 1.0f, speed);
                    }
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case 3: {
                float jumpCharge;
                IC2.platform.profilerStartSection("QuantumBoots");
                float f = jumpCharge = jumpChargeMap.containsKey(player) ? ((Float)jumpChargeMap.get(player)).floatValue() : 1.0f;
                if (ElectricItem.manager.canUse(itemStack, 1000) && player.field_70122_E && jumpCharge < 1.0f) {
                    jumpCharge = 1.0f;
                    ElectricItem.manager.use(itemStack, 1000, null);
                    ret = true;
                }
                if (player.field_70181_x >= 0.0 && jumpCharge > 0.0f && !player.func_70090_H()) {
                    if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                        if (jumpCharge == 1.0f) {
                            player.field_70159_w *= 3.5;
                            player.field_70179_y *= 3.5;
                        }
                        player.field_70181_x += (double)(jumpCharge * 0.3f);
                        jumpCharge = (float)((double)jumpCharge * 0.75);
                    } else if (jumpCharge < 1.0f) {
                        jumpCharge = 0.0f;
                    }
                }
                jumpChargeMap.put(player, Float.valueOf(jumpCharge));
                IC2.platform.profilerEndSection();
            }
        }
        if (ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public static void removePlayerReferences(EntityPlayer player) {
        speedTickerMap.remove(player);
        jumpChargeMap.remove(player);
        enableQuantumSpeedOnSprintMap.remove(player);
    }

    static {
        ItemArmorQuantumSuit.potionRemovalCost[Potion.field_76436_u.field_76415_H] = 10000;
        ItemArmorQuantumSuit.potionRemovalCost[IC2Potion.radiation.field_76415_H] = 10000;
        ItemArmorQuantumSuit.potionRemovalCost[Potion.field_82731_v.field_76415_H] = 25000;
    }
}

