/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.ITickCallback;
import ic2.core.Ic2Items;
import ic2.core.item.ItemCropSeed;
import ic2.core.item.tool.ContainerCropnalyzer;
import ic2.core.item.tool.GuiCropnalyzer;
import ic2.core.util.StackUtil;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class HandHeldCropnalyzer
implements IHasGui,
ITickCallback {
    private final ItemStack itemStack;
    private final ItemStack[] inventory = new ItemStack[3];

    public HandHeldCropnalyzer(EntityPlayer entityPlayer, ItemStack itemStack) {
        this.itemStack = itemStack;
        if (IC2.platform.isSimulating()) {
            NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(itemStack);
            nbtTagCompound.func_74768_a("uid", new Random().nextInt());
            NBTTagList nbtTagList = nbtTagCompound.func_74761_m("Items");
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound nbtTagCompoundSlot = (NBTTagCompound)nbtTagList.func_74743_b(i);
                byte slot = nbtTagCompoundSlot.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompoundSlot);
            }
            IC2.addContinuousTickCallback(entityPlayer.field_70170_p, this);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack ret = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return ret;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "Cropnalyzer";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return false;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCropnalyzer(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer) {
        return new GuiCropnalyzer(new ContainerCropnalyzer(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
        if (IC2.platform.isSimulating()) {
            int i;
            IC2.removeContinuousTickCallback(entityPlayer.field_70170_p, this);
            NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(this.itemStack);
            boolean dropItself = false;
            for (int i2 = 0; i2 < this.func_70302_i_(); ++i2) {
                if (this.inventory[i2] == null) continue;
                NBTTagCompound nbtTagCompoundSlot = StackUtil.getOrCreateNbtData(this.inventory[i2]);
                if (nbtTagCompound.func_74762_e("uid") != nbtTagCompoundSlot.func_74762_e("uid")) continue;
                this.itemStack.field_77994_a = 1;
                this.inventory[i2] = null;
                dropItself = true;
                break;
            }
            NBTTagList nbtTagList = new NBTTagList();
            for (i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                NBTTagCompound nbtTagCompoundSlot = new NBTTagCompound();
                nbtTagCompoundSlot.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(nbtTagCompoundSlot);
                nbtTagList.func_74742_a((NBTBase)nbtTagCompoundSlot);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)nbtTagList);
            if (dropItself) {
                StackUtil.dropAsEntity(entityPlayer.field_70170_p, (int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u, (int)entityPlayer.field_70161_v, this.itemStack);
            } else {
                for (i = -1; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                    NBTTagCompound nbtTagCompoundSlot;
                    ItemStack itemStackSlot = i == -1 ? entityPlayer.field_71071_by.func_70445_o() : entityPlayer.field_71071_by.func_70301_a(i);
                    if (itemStackSlot == null || (nbtTagCompoundSlot = itemStackSlot.func_77978_p()) == null || nbtTagCompound.func_74762_e("uid") != nbtTagCompoundSlot.func_74762_e("uid")) continue;
                    this.itemStack.field_77994_a = 1;
                    if (i == -1) {
                        entityPlayer.field_71071_by.func_70437_b(this.itemStack);
                        break;
                    }
                    entityPlayer.field_71071_by.func_70299_a(i, this.itemStack);
                    break;
                }
            }
        }
    }

    @Override
    public void tickCallback(World world) {
        if (this.inventory[1] == null && this.inventory[0] != null && this.inventory[0].field_77993_c == Ic2Items.cropSeed.field_77993_c) {
            byte level = ItemCropSeed.getScannedFromStack(this.inventory[0]);
            if (level == 4) {
                this.inventory[1] = this.inventory[0];
                this.inventory[0] = null;
                return;
            }
            if (this.inventory[2] == null || !(this.inventory[2].func_77973_b() instanceof IElectricItem)) {
                return;
            }
            int ned = this.energyForLevel(level);
            int got = ElectricItem.manager.discharge(this.inventory[2], ned, 2, true, false);
            if (got < ned) {
                return;
            }
            ItemCropSeed.incrementScannedOfStack(this.inventory[0]);
            this.inventory[1] = this.inventory[0];
            this.inventory[0] = null;
        }
    }

    public int energyForLevel(int i) {
        switch (i) {
            default: {
                return 10;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 900;
            }
            case 3: 
        }
        return 9000;
    }

    public CropCard crop() {
        return Crops.instance.getCropList()[ItemCropSeed.getIdFromStack(this.inventory[1])];
    }

    public int getScannedLevel() {
        if (this.inventory[1] == null || this.inventory[1].func_77973_b() != Ic2Items.cropSeed.func_77973_b()) {
            return -1;
        }
        return ItemCropSeed.getScannedFromStack(this.inventory[1]);
    }

    public String getSeedName() {
        return this.crop().name();
    }

    public String getSeedTier() {
        switch (this.crop().tier()) {
            default: {
                return "0";
            }
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
            case 11: {
                return "XI";
            }
            case 12: {
                return "XII";
            }
            case 13: {
                return "XIII";
            }
            case 14: {
                return "XIV";
            }
            case 15: {
                return "XV";
            }
            case 16: 
        }
        return "XVI";
    }

    public String getSeedDiscovered() {
        return this.crop().discoveredBy();
    }

    public String getSeedDesc(int i) {
        return this.crop().desc(i);
    }

    public int getSeedGrowth() {
        return ItemCropSeed.getGrowthFromStack(this.inventory[1]);
    }

    public int getSeedGain() {
        return ItemCropSeed.getGainFromStack(this.inventory[1]);
    }

    public int getSeedResistence() {
        return ItemCropSeed.getResistanceFromStack(this.inventory[1]);
    }

    public boolean matchesUid(int uid) {
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(this.itemStack);
        return nbtTagCompound.func_74762_e("uid") == uid;
    }
}

