/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.api.Direction;
import ic2.core.block.personal.IPersonalBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public final class StackUtil {
    private static final Direction[] directions = Direction.values();
    private static final Random random = new Random();

    public static List getAdjacentInventories(TileEntity source) {
        ArrayList<IInventory> inventories = new ArrayList<IInventory>();
        for (Direction direction : directions) {
            TileEntity target = direction.applyToTileEntity(source);
            if (!(target instanceof IInventory)) continue;
            IInventory inventory = (IInventory)target;
            if (target instanceof TileEntityChest) {
                for (Direction direction2 : directions) {
                    TileEntity target2;
                    if (direction2 == Direction.YN || direction2 == Direction.YP || !((target2 = direction2.applyToTileEntity(target)) instanceof TileEntityChest)) continue;
                    inventory = new InventoryLargeChest("", inventory, (IInventory)target2);
                    break;
                }
            }
            if (target instanceof IPersonalBlock && (!(source instanceof IPersonalBlock) || !((IPersonalBlock)target).permitsAccess(((IPersonalBlock)source).getUsername()))) continue;
            inventories.add(inventory);
        }
        Collections.sort(inventories, new Comparator(){

            public int compare(IInventory a, IInventory b) {
                if (a instanceof IPersonalBlock || !(b instanceof IPersonalBlock)) {
                    return -1;
                }
                if (b instanceof IPersonalBlock || !(a instanceof IPersonalBlock)) {
                    return 1;
                }
                return b.func_70302_i_() - a.func_70302_i_();
            }
        });
        return inventories;
    }

    public static int distribute(TileEntity source, ItemStack itemStack, boolean simulate) {
        int transferred = 0;
        for (IInventory inventory : StackUtil.getAdjacentInventories(source)) {
            int amount = StackUtil.putInInventory(inventory, itemStack, simulate);
            transferred += amount;
            itemStack.field_77994_a -= amount;
            if (itemStack.field_77994_a != 0) continue;
            break;
        }
        itemStack.field_77994_a += transferred;
        return transferred;
    }

    public static ItemStack fetch(TileEntity source, ItemStack itemStack, boolean simulate) {
        ItemStack ret = null;
        for (IInventory inventory : StackUtil.getAdjacentInventories(source)) {
            ItemStack transferred = StackUtil.getFromInventory(inventory, itemStack, simulate);
            if (transferred == null) continue;
            if (ret == null) {
                ret = transferred;
            } else {
                ret.field_77994_a += transferred.field_77994_a;
            }
            if (ret.field_77994_a != itemStack.field_77994_a) continue;
            break;
        }
        return ret;
    }

    public static void distributeDrop(TileEntity source, List itemStacks) {
        Iterator it = itemStacks.iterator();
        while (it.hasNext()) {
            ItemStack itemStack = (ItemStack)it.next();
            int amount = StackUtil.distribute(source, itemStack, false);
            if (amount == itemStack.field_77994_a) {
                it.remove();
                continue;
            }
            itemStack.field_77994_a -= amount;
        }
        for (ItemStack itemStack : itemStacks) {
            StackUtil.dropAsEntity(source.field_70331_k, source.field_70329_l, source.field_70330_m, source.field_70327_n, itemStack);
        }
        itemStacks.clear();
    }

    public static ItemStack getFromInventory(IInventory inventory, ItemStack itemStackDestination, boolean simulate) {
        ItemStack ret = null;
        int toTransfer = itemStackDestination.field_77994_a;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || !StackUtil.isStackEqual(itemStack, itemStackDestination)) continue;
            if (ret == null) {
                ret = StackUtil.copyWithSize(itemStack, 0);
            }
            int transfer = Math.min(toTransfer, itemStack.field_77994_a);
            if (!simulate) {
                itemStack.field_77994_a -= transfer;
                if (itemStack.field_77994_a == 0) {
                    inventory.func_70299_a(i, null);
                }
            }
            ret.field_77994_a += transfer;
            if ((toTransfer -= transfer) != 0) continue;
            return ret;
        }
        return null;
    }

    public static int putInInventory(IInventory inventory, ItemStack itemStackSource, boolean simulate) {
        int transfer;
        ItemStack itemStack;
        int i;
        int transferred = 0;
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_94041_b(i, itemStackSource) || (itemStack = inventory.func_70301_a(i)) == null || !itemStack.func_77969_a(itemStackSource)) continue;
            transfer = Math.min(itemStackSource.field_77994_a - transferred, itemStack.func_77976_d() - itemStack.field_77994_a);
            if (!simulate) {
                itemStack.field_77994_a += transfer;
            }
            if ((transferred += transfer) != itemStackSource.field_77994_a) continue;
            return transferred;
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_94041_b(i, itemStackSource) || (itemStack = inventory.func_70301_a(i)) != null) continue;
            transfer = Math.min(itemStackSource.field_77994_a - transferred, itemStackSource.func_77976_d());
            if (!simulate) {
                ItemStack dest = StackUtil.copyWithSize(itemStackSource, transfer);
                inventory.func_70299_a(i, dest);
            }
            if ((transferred += transfer) != itemStackSource.field_77994_a) continue;
            return transferred;
        }
        return transferred;
    }

    public static void dropAsEntity(World world, int x, int y, int z, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        double f = 0.7;
        double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, itemStack.func_77946_l());
        entityItem.field_70293_c = 10;
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound("tag");
            itemStack.func_77982_d(ret);
        }
        return ret;
    }

    public static boolean isStackEqual(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.field_77993_c == stack2.field_77993_c && (!stack1.func_77981_g() && !stack1.func_77984_f() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean damageItemStack(ItemStack itemStack, int amount) {
        if (itemStack.func_96631_a(amount, random)) {
            --itemStack.field_77994_a;
            itemStack.func_77964_b(0);
            return itemStack.field_77994_a <= 0;
        }
        return false;
    }
}

