/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.common;

import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.ListIterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class DLTransformer
implements IClassTransformer {
    private final String classNameWorldObfusc = "aab";
    private final String classNameBlockAccessObfusc = "aak";
    private final String computeBlockLightMethodNameO = "a";
    private final String enumSkyBlockObfusc = "aam";
    private final String classNameWorld = "net.minecraft.world.World";
    private final String classNameWorldJava = "net/minecraft/world/World";
    private final String blockAccessJava = "net/minecraft/world/IBlockAccess";
    private final String computeBlockLightMethodName = "func_98179_a";

    public byte[] transform(String name, String newName, byte[] bytes) {
        if (name.equals("aab")) {
            return this.handleWorldTransform(bytes, true);
        }
        if (name.equals("net.minecraft.world.World")) {
            return this.handleWorldTransform(bytes, false);
        }
        return bytes;
    }

    private byte[] handleWorldTransform(byte[] bytes, boolean obfuscated) {
        System.out.println("**************** Dynamic Lights transform running on World *********************** ");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(obfuscated ? "a" : "func_98179_a") || !m.desc.equals(obfuscated ? "(IIILaam;)I" : "(IIILnet/minecraft/world/EnumSkyBlock;)I")) continue;
            System.out.println("In target method! Patching!");
            AbstractInsnNode targetNode = null;
            ListIterator iter = m.instructions.iterator();
            boolean deleting = false;
            boolean replacing = false;
            while (iter.hasNext()) {
                targetNode = (AbstractInsnNode)iter.next();
                if (targetNode instanceof VarInsnNode) {
                    VarInsnNode vNode = (VarInsnNode)targetNode;
                    if (vNode.var == 6) {
                        if (vNode.getOpcode() == 58) {
                            System.out.println("Bytecode ASTORE 6 case!");
                            deleting = true;
                            continue;
                        }
                        if (vNode.getOpcode() == 54) {
                            System.out.println("Bytecode ISTORE 6 case!");
                            replacing = true;
                            targetNode = (AbstractInsnNode)iter.next();
                            break;
                        }
                    }
                    if (vNode.var == 7 && deleting) break;
                }
                if (!deleting) continue;
                System.out.println("Removing " + targetNode);
                iter.remove();
            }
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 5));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "atomicstryker/dynamiclights/client/DynamicLights", "getLightValue", "(L" + (obfuscated ? "aak" : "net/minecraft/world/IBlockAccess") + ";IIII)I"));
            if (replacing) {
                toInject.add((AbstractInsnNode)new VarInsnNode(54, 6));
            }
            m.instructions.insertBefore(targetNode, toInject);
            System.out.println("Patching Complete!");
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

