/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IFlowerProvider;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderCacti
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(World world, IBeeGenome species, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        if (blockid == Block.field_82516_cf.field_71990_ca) {
            return this.checkFlowerPot(world.func_72805_g(x, y, z));
        }
        return blockid == Block.field_72038_aV.field_71990_ca;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        return pollinatable.getPlantType().contains(EnumPlantType.Desert);
    }

    private boolean checkFlowerPot(int meta) {
        return meta == 9;
    }

    @Override
    public boolean growFlower(World world, IBeeGenome species, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        if (blockid == Block.field_82516_cf.field_71990_ca) {
            return this.growInPot(world, x, y, z);
        }
        return false;
    }

    private boolean growInPot(World world, int x, int y, int z) {
        if (world.field_73012_v.nextBoolean()) {
            world.func_72832_d(x, y, z, Block.field_82516_cf.field_71990_ca, 9, 2);
        } else {
            world.func_72832_d(x, y, z, Block.field_82516_cf.field_71990_ca, 10, 2);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.cacti");
    }

    @Override
    public ItemStack[] affectProducts(World world, IBeeGenome genome, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public ItemStack[] getItemStacks() {
        return new ItemStack[]{new ItemStack(Block.field_72038_aV)};
    }
}

