/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import cpw.mods.fml.common.network.Player;
import forestry.api.apiculture.BeeManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.apiculture.gui.ContainerImprinter;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketNBT;
import forestry.core.proxy.Proxies;
import java.io.DataInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;

public class PacketHandlerApiculture
implements IPacketHandler {
    @Override
    public void onPacketData(INetworkManager network, int packetID, DataInputStream data, Player player) {
        try {
            switch (packetID) {
                case 20: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    Proxies.common.setBiomefinderCoordinates((EntityPlayer)player, packetC.getCoordinates());
                    break;
                }
                case 60: {
                    PacketNBT packetN = new PacketNBT();
                    packetN.readData(data);
                    this.onGenomeTrackerUpdate((EntityPlayer)player, packetN);
                    break;
                }
                case 31: {
                    this.onImprintSelectionGet((EntityPlayer)player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onGenomeTrackerUpdate(EntityPlayer player, PacketNBT packet) {
        IBreedingTracker tracker = null;
        String type = packet.getTagCompound().func_74779_i("TYPE");
        if (type.equals("Bee")) {
            tracker = BeeManager.breedingManager.getApiaristTracker(Proxies.common.getRenderWorld(), player.field_71092_bJ);
        }
        if (tracker != null) {
            tracker.decodeFromNBT(packet.getTagCompound());
        }
    }

    private void onImprintSelectionGet(EntityPlayer playerEntity) {
        if (!(playerEntity.field_71070_bA instanceof ContainerImprinter)) {
            return;
        }
        ((ContainerImprinter)playerEntity.field_71070_bA).sendSelection(playerEntity);
    }
}

