/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeInterface;
import forestry.api.genetics.IAllele;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeGenome;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Chromosome;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BeeHelper
implements IBeeInterface {
    @Override
    public EnumBeeType getType(ItemStack stack) {
        if (stack == null) {
            return EnumBeeType.NONE;
        }
        if (stack.field_77993_c == ForestryItem.beeDroneGE.field_77779_bT) {
            return EnumBeeType.DRONE;
        }
        if (stack.field_77993_c == ForestryItem.beePrincessGE.field_77779_bT) {
            return EnumBeeType.PRINCESS;
        }
        if (stack.field_77993_c == ForestryItem.beeQueenGE.field_77779_bT) {
            return EnumBeeType.QUEEN;
        }
        return EnumBeeType.NONE;
    }

    @Override
    public boolean isBee(ItemStack stack) {
        return this.getType(stack) != EnumBeeType.NONE;
    }

    @Override
    public boolean isDrone(ItemStack stack) {
        return this.getType(stack) == EnumBeeType.DRONE;
    }

    @Override
    public boolean isMated(ItemStack stack) {
        if (this.getType(stack) != EnumBeeType.QUEEN) {
            return false;
        }
        IBee bee = this.getBee(stack);
        return bee.getMate() != null;
    }

    @Override
    public IBee getBee(ItemStack stack) {
        if (stack.field_77993_c != ForestryItem.beeQueenGE.field_77779_bT && stack.field_77993_c != ForestryItem.beePrincessGE.field_77779_bT && stack.field_77993_c != ForestryItem.beeDroneGE.field_77779_bT) {
            return null;
        }
        return new Bee(stack.func_77978_p());
    }

    @Override
    public IBee getBee(World world, IBeeGenome genome) {
        return new Bee(world, genome);
    }

    @Override
    public IBee getBee(World world, IBeeGenome genome, IBee mate) {
        return new Bee(world, genome, mate);
    }

    @Override
    public ItemStack getBeeStack(IBee bee, EnumBeeType type) {
        Item beeItem = null;
        switch (type) {
            case QUEEN: {
                beeItem = ForestryItem.beeQueenGE;
                break;
            }
            case PRINCESS: {
                beeItem = ForestryItem.beePrincessGE;
                break;
            }
            case DRONE: {
                beeItem = ForestryItem.beeDroneGE;
                break;
            }
            default: {
                throw new RuntimeException("Cannot instantiate a bee of type " + (Object)((Object)type));
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound("tag");
        bee.writeToNBT(nbttagcompound);
        ItemStack beeStack = new ItemStack(beeItem);
        beeStack.func_77982_d(nbttagcompound);
        return beeStack;
    }

    public Chromosome[] templateAsChromosomes(IAllele[] template) {
        Chromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    public Chromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        Chromosome[] chromosomes = new Chromosome[templateActive.length];
        for (int i = 0; i < templateActive.length; ++i) {
            if (templateActive[i] == null) continue;
            chromosomes[i] = new Chromosome(templateActive[i], templateInactive[i]);
        }
        return chromosomes;
    }

    @Override
    public IBeeGenome templateAsGenome(IAllele[] template) {
        return new BeeGenome(this.templateAsChromosomes(template));
    }

    @Override
    public IBeeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new BeeGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }
}

