/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import cpw.mods.fml.common.FMLCommonHandler;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.IBreedingManager;
import forestry.api.core.IStructureLogic;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.apiculture.BeekeepingLogic;
import forestry.apiculture.gadgets.StructureLogicAlveary;
import forestry.apiculture.genetics.ApiaristTracker;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.plugins.PluginForestryApiculture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class BreedingManager
implements IBreedingManager {
    public static int beeSpeciesCount = -1;
    ArrayList beekeepingModes = new ArrayList();
    public static IBeekeepingMode activeBeekeepingMode;
    private static ArrayList beeMutations;
    public static HashMap speciesTemplates;
    public static ArrayList beeTemplates;

    @Override
    public int getBeeSpeciesCount() {
        if (beeSpeciesCount < 0) {
            beeSpeciesCount = 0;
            for (Map.Entry entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleBeeSpecies) || !((IAlleleBeeSpecies)entry.getValue()).isCounted()) continue;
                ++beeSpeciesCount;
            }
        }
        return beeSpeciesCount;
    }

    @Override
    public ArrayList getBeekeepingModes() {
        return this.beekeepingModes;
    }

    @Override
    public IBeekeepingMode getBeekeepingMode(World world) {
        if (activeBeekeepingMode != null) {
            return activeBeekeepingMode;
        }
        IApiaristTracker tracker = this.getApiaristTracker(world, "__COMMON_");
        String mode = tracker.getModeName();
        if (mode == null || mode.isEmpty()) {
            mode = PluginForestryApiculture.beekeepingMode;
        }
        this.setBeekeepingMode(world, mode);
        FMLCommonHandler.instance().getFMLLogger().fine("Set beekeeping mode for a world to " + mode);
        return activeBeekeepingMode;
    }

    @Override
    public void registerBeekeepingMode(IBeekeepingMode mode) {
        this.beekeepingModes.add(mode);
    }

    @Override
    public void setBeekeepingMode(World world, String name) {
        activeBeekeepingMode = this.getBeekeepingMode(name);
        this.getApiaristTracker(world, "__COMMON_").setModeName(name);
    }

    @Override
    public IBeekeepingMode getBeekeepingMode(String name) {
        for (IBeekeepingMode mode : this.beekeepingModes) {
            if (!mode.getName().equals(name) && !mode.getName().equals(name.toLowerCase(Locale.ENGLISH))) continue;
            return mode;
        }
        FMLCommonHandler.instance().getFMLLogger().fine("Failed to find a beekeeping mode called '%s', reverting to fallback.");
        return (IBeekeepingMode)this.beekeepingModes.get(0);
    }

    @Override
    public void blacklistBeeSpecies(String uid) {
        AlleleManager.alleleRegistry.blacklistAllele(uid);
    }

    @Override
    public ArrayList getBeeSpeciesBlacklist() {
        return AlleleManager.alleleRegistry.getAlleleBlacklist();
    }

    @Override
    public boolean isBlacklisted(String uid) {
        return AlleleManager.alleleRegistry.isBlacklisted(uid);
    }

    @Override
    public ArrayList getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(beeMutations);
        }
        return beeMutations;
    }

    @Override
    public void registerBeeMutation(IBeeMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        beeMutations.add(mutation);
    }

    @Override
    public void registerBeeTemplate(IAllele[] template) {
        this.registerBeeTemplate(template[0].getUID(), template);
    }

    @Override
    public void registerBeeTemplate(String identifier, IAllele[] template) {
        beeTemplates.add(new Bee(BeeManager.beeInterface.templateAsGenome(template)));
        speciesTemplates.put(identifier, template);
    }

    @Override
    public IAllele[] getBeeTemplate(String identifier) {
        return (IAllele[])speciesTemplates.get(identifier);
    }

    @Override
    public IAllele[] getDefaultBeeTemplate() {
        return BeeTemplates.getDefaultTemplate();
    }

    @Override
    public IApiaristTracker getApiaristTracker(World world, String player) {
        String filename = "ApiaristTracker." + player;
        ApiaristTracker tracker = (ApiaristTracker)world.func_72943_a(ApiaristTracker.class, filename);
        if (tracker == null) {
            tracker = new ApiaristTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        return tracker;
    }

    @Override
    public IBeekeepingLogic createBeekeepingLogic(IBeeHousing housing) {
        return new BeekeepingLogic(housing);
    }

    @Override
    public IStructureLogic createAlvearyStructureLogic(IAlvearyComponent structure) {
        return new StructureLogicAlveary(structure);
    }

    static {
        beeMutations = new ArrayList();
        speciesTemplates = new HashMap();
        beeTemplates = new ArrayList();
    }
}

