/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class HiveDrop
implements IHiveDrop {
    private IAllele[] template;
    private ArrayList additional = new ArrayList();
    private int chance;

    public HiveDrop(IAllele[] template, ItemStack[] bonus, int chance) {
        this.template = template;
        this.chance = chance;
        for (ItemStack stack : bonus) {
            this.additional.add(stack);
        }
    }

    @Override
    public ItemStack getPrincess(World world, int x, int y, int z, int fortune) {
        return BeeManager.beeInterface.getBeeStack(BeeManager.beeInterface.getBee(world, BeeManager.beeInterface.templateAsGenome(this.template)), EnumBeeType.PRINCESS);
    }

    @Override
    public ArrayList getDrones(World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(BeeManager.beeInterface.getBeeStack(BeeManager.beeInterface.getBee(world, BeeManager.beeInterface.templateAsGenome(this.template)), EnumBeeType.DRONE));
        return ret;
    }

    @Override
    public ArrayList getAdditional(World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : this.additional) {
            ret.add(stack.func_77946_l());
        }
        return ret;
    }

    @Override
    public int getChance(World world, int x, int y, int z) {
        return this.chance;
    }
}

