/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.genetics.IJubilanceProvider;
import forestry.core.utils.Vect;
import net.minecraft.util.AxisAlignedBB;

public class JubilanceDefault
implements IJubilanceProvider {
    @Override
    public boolean isJubilant(IAlleleBeeSpecies species, IBeeGenome genome, IBeeHousing housing) {
        if (!EnumTemperature.getBiomeIds(species.getTemperature()).contains(housing.getBiomeId())) {
            return false;
        }
        return EnumHumidity.getBiomeIds(species.getHumidity()).contains(housing.getBiomeId());
    }

    protected AxisAlignedBB getBounding(IBeeGenome genome, IBeeHousing housing, float modifier) {
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(modifier);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        Vect min = new Vect(housing.getXCoord() + offset.x, housing.getYCoord() + offset.y, housing.getZCoord() + offset.z);
        Vect max = new Vect(housing.getXCoord() + offset.x + area.x, housing.getYCoord() + offset.y + area.y, housing.getZCoord() + offset.z + area.z);
        return AxisAlignedBB.func_72332_a().func_72299_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }
}

