/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleFlowers;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.gui.ContainerBeealyzer;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.items.ItemBeealyzer;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.AlleleArea;
import forestry.core.genetics.AlleleBoolean;
import forestry.core.genetics.AlleleTolerance;
import forestry.core.genetics.ClimateHelper;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiAlyzer;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Vect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiBeealyzer
extends GuiAlyzer {
    private static final int COLUMN_0 = 12;
    private static final int COLUMN_1 = 52;
    private static final int COLUMN_2 = 108;
    private ItemStack[] tempProductList;
    private IApiaristTracker breedingTracker;

    public GuiBeealyzer(EntityPlayer player, ItemBeealyzer.BeealyzerInventory inventory) {
        super("/gfx/forestry/gui/beealyzer.png", (ContainerForestry)new ContainerBeealyzer(player.field_71071_by, inventory), inventory, 1, inventory.func_70302_i_());
        this.xSize = 196;
        this.ySize = 238;
        ArrayList beeList = new ArrayList();
        ((ItemBeeGE)ForestryItem.beeDroneGE).addCreativeItems(beeList, false);
        for (ItemStack beeStack : beeList) {
            this.iconStacks.put(BeeManager.beeInterface.getBee(beeStack).getIdent(), beeStack);
        }
        this.breedingTracker = BeeManager.breedingManager.getApiaristTracker(player.field_70170_p, player.field_71092_bJ);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        this.drawBackground();
        int page = 0;
        IBee bee = null;
        for (int k = 1; k < 7; ++k) {
            if (k == 5 || this.inventory.func_70301_a(k) == null || (bee = BeeManager.beeInterface.getBee(this.inventory.func_70301_a(k))) == null || !bee.isAnalyzed()) continue;
            page = k;
            break;
        }
        switch (page) {
            case 1: {
                this.drawAnalyticsPage1(bee);
                break;
            }
            case 2: {
                this.drawAnalyticsPage2(bee);
                break;
            }
            case 3: {
                this.drawAnalyticsPage3(bee);
                break;
            }
            case 4: {
                this.drawAnalyticsPage4(bee);
                break;
            }
            case 6: {
                this.drawAnalyticsPageClassification(bee);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private void drawAnalyticsOverview() {
        this.startPage();
        this.newLine();
        String title = StringUtil.localize("gui.beealyzer").toUpperCase();
        this.drawCenteredLine(title, 8, 158);
        this.newLine();
        this.field_73886_k.func_78279_b(StringUtil.localize("gui.beealyzer.help"), (int)((float)(this.guiLeft + 12 + 4) * 1.3333334f), (int)((float)(this.guiTop + 42) * 1.3333334f), 210, this.fontColor.get("gui.screen"));
        this.newLine();
        this.newLine();
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.beealyzer.overview") + ":", 16);
        this.newLine();
        this.drawLine("I  : " + StringUtil.localize("gui.general"), 16);
        this.newLine();
        this.drawLine("II : " + StringUtil.localize("gui.environment"), 16);
        this.newLine();
        this.drawLine("III: " + StringUtil.localize("gui.produce"), 16);
        this.newLine();
        this.drawLine("IV : " + StringUtil.localize("gui.evolution"), 16);
        this.newLine();
        String mode = this.breedingTracker.getModeName();
        if (mode != null && !mode.isEmpty()) {
            this.newLine();
            String rules = StringUtil.localize("gui.beealyzer.behaviour") + ": " + StringUtil.capitalize(mode);
            this.drawLine(rules, 8 + this.getCenteredOffset(title, 158), this.fontColor.get("gui.beealyzer.binomial"));
        }
        this.endPage();
    }

    private void drawAnalyticsPage1(IBee bee) {
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.active"), 52);
        this.drawLine(StringUtil.localize("gui.inactive"), 108);
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.species"), 12);
        this.drawSplitLine(bee.getGenome().getPrimaryAsBee().getName(), 52, 52, bee, EnumBeeChromosome.SPECIES, false);
        this.drawSplitLine(bee.getGenome().getSecondaryAsBee().getName(), 108, 52, bee, EnumBeeChromosome.SPECIES, true);
        this.newLine();
        this.newLine();
        this.drawRow(StringUtil.localize("gui.lifespan"), Bee.rateLifespan(bee.getGenome().getLifespan()), Bee.rateLifespan(((IAlleleInteger)bee.getGenome().getInactiveAllele(EnumBeeChromosome.LIFESPAN.ordinal())).getValue()), bee, EnumBeeChromosome.LIFESPAN);
        this.drawRow(StringUtil.localize("gui.speed"), Bee.rateSpeed(bee.getGenome().getSpeed()), Bee.rateSpeed(((IAlleleFloat)bee.getGenome().getInactiveAllele(EnumBeeChromosome.SPEED.ordinal())).getValue()), bee, EnumBeeChromosome.SPEED);
        this.drawRow(StringUtil.localize("gui.pollination"), Bee.rateFlowering(bee.getGenome().getFlowering()), Bee.rateFlowering(((IAlleleInteger)bee.getGenome().getInactiveAllele(EnumBeeChromosome.FLOWERING.ordinal())).getValue()), bee, EnumBeeChromosome.FLOWERING);
        this.drawRow(StringUtil.localize("gui.flowers"), StringUtil.localize(bee.getGenome().getFlowerProvider().getDescription()), StringUtil.localize(((IAlleleFlowers)bee.getGenome().getInactiveAllele(EnumBeeChromosome.FLOWER_PROVIDER.ordinal())).getProvider().getDescription()), bee, EnumBeeChromosome.FLOWER_PROVIDER);
        this.drawLine(StringUtil.localize("gui.fertility"), 12);
        this.drawFertilityInfo(bee.getGenome().getFertility(), 52, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.FERTILITY.ordinal()).isDominant()));
        this.drawFertilityInfo(((IAlleleInteger)bee.getGenome().getInactiveAllele(EnumBeeChromosome.FERTILITY.ordinal())).getValue(), 108, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.FERTILITY.ordinal()).isDominant()));
        this.newLine();
        int[] areaAr = bee.getGenome().getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        this.drawRow(StringUtil.localize("gui.area"), area.toString(), ((AlleleArea)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TERRITORY.ordinal())).getArea().toString(), bee, EnumBeeChromosome.TERRITORY);
        this.drawRow(StringUtil.localize("gui.effect"), StringUtil.localize(bee.getGenome().getEffect().getIdentifier()), StringUtil.localize(((IAlleleBeeEffect)bee.getGenome().getInactiveAllele(EnumBeeChromosome.EFFECT.ordinal())).getIdentifier()), bee, EnumBeeChromosome.EFFECT);
        this.newLine();
        this.endPage();
    }

    private void drawAnalyticsPage2(IBee bee) {
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.active"), 52);
        this.drawLine(StringUtil.localize("gui.inactive"), 108);
        this.newLine();
        this.newLine();
        this.drawRow(StringUtil.localize("gui.climate"), ClimateHelper.toDisplay(bee.getGenome().getPrimaryAsBee().getTemperature()), ClimateHelper.toDisplay(bee.getGenome().getSecondaryAsBee().getTemperature()), bee, EnumBeeChromosome.SPECIES);
        this.drawLine(StringUtil.localize("gui.temptol"), 12);
        this.drawToleranceInfo(bee.getGenome().getToleranceTemp(), 52, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()).isDominant()));
        this.drawToleranceInfo(((AlleleTolerance)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal())).getValue(), 108, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()).isDominant()));
        this.newLine();
        this.drawRow(StringUtil.localize("gui.humidity"), ClimateHelper.toDisplay(bee.getGenome().getPrimaryAsBee().getHumidity()), ClimateHelper.toDisplay(bee.getGenome().getSecondaryAsBee().getHumidity()), bee, EnumBeeChromosome.SPECIES);
        this.drawLine(StringUtil.localize("gui.humidtol"), 12);
        this.drawToleranceInfo(bee.getGenome().getToleranceHumid(), 52, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()).isDominant()));
        this.drawToleranceInfo(((AlleleTolerance)bee.getGenome().getInactiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal())).getValue(), 108, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()).isDominant()));
        this.newLine();
        this.newLine();
        String yes = StringUtil.localize("yes");
        String no = StringUtil.localize("no");
        String primary = StringUtil.readableBoolean(bee.getGenome().getNocturnal(), yes, no);
        String secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.NOCTURNAL.ordinal())).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.nocturnal"), primary, secondary, bee, EnumBeeChromosome.NOCTURNAL);
        primary = StringUtil.readableBoolean(bee.getGenome().getTolerantFlyer(), yes, no);
        secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TOLERANT_FLYER.ordinal())).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.flyer"), primary, secondary, bee, EnumBeeChromosome.TOLERANT_FLYER);
        primary = StringUtil.readableBoolean(bee.getGenome().getCaveDwelling(), yes, no);
        secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.CAVE_DWELLING.ordinal())).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.cave"), primary, secondary, bee, EnumBeeChromosome.CAVE_DWELLING);
        this.newLine();
        this.newLine();
        String origin = "gui.beealyzer.natural";
        if (!bee.isNatural()) {
            origin = "gui.beealyzer.artificial";
        }
        origin = StringUtil.localize(origin);
        this.drawCenteredLine(origin, 8, 158, this.fontColor.get("gui.beealyzer.binomial"));
        if (bee.getGeneration() >= 0) {
            this.newLine();
            origin = bee.getGeneration() + " " + StringUtil.localize("gui.beealyzer.generations");
            this.drawCenteredLine(origin, 8, 158, this.fontColor.get("gui.beealyzer.binomial"));
        }
        this.endPage();
    }

    private void drawAnalyticsPage3(IBee bee) {
        this.tempProductList = bee.getProduceList();
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.beealyzer.produce") + ":", 12);
        this.newLine();
        int x = 12;
        for (ItemStack stack : this.tempProductList) {
            itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, stack, (int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f));
            if ((x += 18) <= this.adjustToFactor(148)) continue;
            x = 12;
            this.newLine();
        }
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.beealyzer.specialty") + ":", 12);
        this.newLine();
        x = 12;
        for (ItemStack stack : bee.getSpecialtyList()) {
            itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, stack, (int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f));
            if ((x += 18) <= this.adjustToFactor(148)) continue;
            x = 12;
            this.newLine();
        }
        this.endPage();
    }

    private void drawAnalyticsPage4(IBee bee) {
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.beealyzer.mutations") + ":", 12);
        this.newLine();
        this.newLine();
        RenderHelper.func_74520_c();
        HashMap<IMutation, IAlleleBeeSpecies> combinations = new HashMap<IMutation, IAlleleBeeSpecies>();
        for (IMutation iMutation : BeeTemplates.getCombinations(bee.getGenome().getPrimaryAsBee())) {
            combinations.put(iMutation, bee.getGenome().getPrimaryAsBee());
        }
        for (IMutation iMutation : BeeTemplates.getCombinations(bee.getGenome().getSecondaryAsBee())) {
            combinations.put(iMutation, bee.getGenome().getSecondaryAsBee());
        }
        int columnWidth = 50;
        int x = 0;
        for (Map.Entry entry : combinations.entrySet()) {
            if (this.breedingTracker.isDiscovered((IMutation)entry.getKey())) {
                this.drawMutationInfo((IMutation)entry.getKey(), (IAllele)entry.getValue(), 12 + x);
            } else {
                if (((IMutation)entry.getKey()).isSecret()) continue;
                this.drawUnknownMutation((IMutation)entry.getKey(), (IAllele)entry.getValue(), 12 + x);
            }
            if ((x += columnWidth) <= 150) continue;
            x = 0;
            this.newLine();
            this.newLine();
        }
        this.endPage();
    }

    private void drawFertilityInfo(int fertility, int x, int textColor) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b((int)((float)(this.guiLeft + x + 19) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f), 196, 43, 12, 9);
        this.drawLine(Integer.toString(fertility) + " x", x, textColor);
    }

    private void drawToleranceInfo(EnumTolerance tolerance, int x, int textColor) {
        int length = tolerance.toString().length();
        String text = "(" + tolerance.toString().substring(length - 1) + ")";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                this.drawBothSymbol(x, this.getLineY() - 1);
                this.drawLine(text, x + 15, textColor);
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                this.drawDownSymbol(x, this.getLineY() - 1);
                this.drawLine(text, x + 15, textColor);
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                this.drawUpSymbol(x, this.getLineY() - 1);
                this.drawLine(text, x + 15, textColor);
                break;
            }
            default: {
                this.drawNoneSymbol(x, this.getLineY() - 1);
                this.drawLine("(0)", x + 15, textColor);
            }
        }
    }

    private void drawDownSymbol(int x, int y) {
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b((int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f), 196, 34, 15, 9);
    }

    private void drawUpSymbol(int x, int y) {
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b((int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f), 211, 34, 15, 9);
    }

    private void drawBothSymbol(int x, int y) {
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b((int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f), 226, 34, 15, 9);
    }

    private void drawNoneSymbol(int x, int y) {
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b((int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f), 241, 34, 15, 9);
    }
}

