/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.proxy;

import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.render.EntityBeeFX;
import forestry.core.config.Config;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import forestry.core.render.RenderAnalyzer;
import forestry.core.render.TextureManager;
import forestry.core.utils.Localization;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;

public class ClientProxyApiculture
extends ProxyApiculture {
    @Override
    public void addBeeHiveFX(String icon, World world, double xCoord, double yCoord, double zCoord, int color, int areaX, int areaY, int areaZ) {
        EntityBeeFX fx;
        if (!Config.enableParticleFX) {
            return;
        }
        Minecraft mc = Proxies.common.getClientInstance();
        if (world.field_73012_v.nextBoolean()) {
            fx = new EntityBeeFX(world, xCoord + 0.5, yCoord + 0.75, zCoord + 0.5, 0.0f, 0.0f, 0.0f, color);
        } else {
            double spawnX = xCoord + (double)world.field_73012_v.nextInt(areaX * 2) - (double)areaX;
            double spawnY = yCoord + (double)world.field_73012_v.nextInt(areaY);
            double spawnZ = zCoord + (double)world.field_73012_v.nextInt(areaZ * 2) - (double)areaZ;
            fx = new EntityBeeFX(world, spawnX, spawnY, spawnZ, 0.0f, 0.0f, 0.0f, color);
        }
        fx.func_94052_a(mc.field_71446_o, TextureManager.getInstance().getDefault(icon));
        mc.field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    public void addBeeSwarmFX(String icon, World world, double xCoord, double yCoord, double zCoord, int color) {
        EntityBeeFX fx;
        if (!Config.enableParticleFX) {
            return;
        }
        Minecraft mc = Proxies.common.getClientInstance();
        if (world.field_73012_v.nextBoolean()) {
            fx = new EntityBeeFX(world, xCoord, yCoord, zCoord, 0.0f, 0.0f, 0.0f, color);
        } else {
            double spawnX = xCoord + (double)world.field_73012_v.nextInt(4) - 2.0;
            double spawnY = yCoord + (double)world.field_73012_v.nextInt(4) - 2.0;
            double spawnZ = zCoord + (double)world.field_73012_v.nextInt(4) - 2.0;
            fx = new EntityBeeFX(world, spawnX, spawnY, spawnZ, 0.0f, 0.0f, 0.0f, color);
        }
        fx.func_94052_a(mc.field_71446_o, TextureManager.getInstance().getDefault(icon));
        mc.field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    public IBlockRenderer getRendererAnalyzer(String gfxBase) {
        return new RenderAnalyzer(gfxBase);
    }

    @Override
    public void addLocalizations() {
        Localization.instance.addLocalization("/lang/forestry/apiculture/");
    }
}

