/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import forestry.apiculture.gadgets.TileBeehouse;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.ClimateHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.ComponentVillage;
import net.minecraft.world.gen.structure.ComponentVillageStartPiece;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class ComponentVillageBeeHouse
extends ComponentVillage {
    protected ItemStack[] buildingBlocks = new ItemStack[]{new ItemStack(ForestryBlock.planks1, 1, 15), new ItemStack(Block.field_71951_J, 1, 0)};
    protected int averageGroundLevel = -1;

    public ComponentVillageBeeHouse(ComponentVillageStartPiece startPiece, int componentType, Random random, StructureBoundingBox boundingBox, int coordBaseMode) {
        super(startPiece, componentType);
        Block woodBlock;
        this.field_74885_f = coordBaseMode;
        this.field_74887_e = boundingBox;
        this.buildingBlocks[0] = new ItemStack(ForestryBlock.planks1, 1, random.nextInt(16));
        switch (random.nextInt(4)) {
            case 1: {
                woodBlock = ForestryBlock.log2;
                break;
            }
            case 2: {
                woodBlock = ForestryBlock.log3;
                break;
            }
            case 3: {
                woodBlock = ForestryBlock.log4;
                break;
            }
            default: {
                woodBlock = ForestryBlock.log1;
            }
        }
        this.buildingBlocks[1] = new ItemStack(woodBlock, 1, random.nextInt(4));
    }

    public static ComponentVillageBeeHouse buildComponent(ComponentVillageStartPiece startPiece, List par1List, Random random, int par3, int par4, int par5, int par6, int par7) {
        StructureBoundingBox bbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (int)par6);
        return ComponentVillageBeeHouse.func_74895_a((StructureBoundingBox)bbox) && StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)bbox) == null ? new ComponentVillageBeeHouse(startPiece, par7, random, bbox, par6) : null;
    }

    protected boolean isDesertVillage() {
        return this.field_74897_k.field_74927_b;
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox structBoundingBox) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, structBoundingBox);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 8 - 1, 0);
        }
        this.func_74884_a(world, structBoundingBox, 1, 1, 1, 7, 4, 4, 0, 0, false);
        this.func_74884_a(world, structBoundingBox, 2, 1, 6, 8, 4, 10, 0, 0, false);
        this.buildGarden(world, structBoundingBox);
        this.func_74884_a(world, structBoundingBox, 1, 1, 6, 1, 1, 10, Block.field_72031_aZ.field_71990_ca, Block.field_72031_aZ.field_71990_ca, false);
        this.func_74884_a(world, structBoundingBox, 8, 1, 6, 8, 1, 10, Block.field_72031_aZ.field_71990_ca, Block.field_72031_aZ.field_71990_ca, false);
        this.func_74884_a(world, structBoundingBox, 2, 1, 10, 7, 1, 10, Block.field_72031_aZ.field_71990_ca, Block.field_72031_aZ.field_71990_ca, false);
        this.plantFlowerGarden(world, structBoundingBox, 2, 1, 5, 7, 1, 9);
        this.buildApiaries(world, structBoundingBox, 3, 1, 4, 6, 1, 8);
        this.func_74884_a(world, structBoundingBox, 1, 0, 1, 7, 0, 4, Block.field_71988_x.field_71990_ca, Block.field_71988_x.field_71990_ca, false);
        this.func_74884_a(world, structBoundingBox, 0, 0, 0, 0, 3, 5, Block.field_71978_w.field_71990_ca, Block.field_71978_w.field_71990_ca, false);
        this.func_74884_a(world, structBoundingBox, 8, 0, 0, 8, 3, 5, Block.field_71978_w.field_71990_ca, Block.field_71978_w.field_71990_ca, false);
        this.func_74884_a(world, structBoundingBox, 1, 0, 0, 7, 1, 0, Block.field_71978_w.field_71990_ca, Block.field_71978_w.field_71990_ca, false);
        this.func_74884_a(world, structBoundingBox, 1, 0, 5, 7, 1, 5, Block.field_71978_w.field_71990_ca, Block.field_71978_w.field_71990_ca, false);
        this.fillBoxWith(world, structBoundingBox, 1, 2, 0, 7, 3, 0, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 1, 2, 5, 7, 3, 5, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 0, 4, 1, 8, 4, 1, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 0, 4, 4, 8, 4, 4, this.buildingBlocks[0], false);
        this.fillBoxWith(world, structBoundingBox, 0, 5, 2, 8, 5, 3, this.buildingBlocks[0], false);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 0, 4, 2, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 0, 4, 3, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 8, 4, 2, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 8, 4, 3, structBoundingBox);
        this.buildRoof(world, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 0, 2, 1, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 0, 2, 4, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 8, 2, 1, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[1], 8, 2, 4, structBoundingBox);
        this.func_74864_a(world, Block.field_72003_bq.field_71990_ca, 0, 0, 2, 2, structBoundingBox);
        this.func_74864_a(world, Block.field_72003_bq.field_71990_ca, 0, 0, 2, 3, structBoundingBox);
        this.func_74864_a(world, Block.field_72003_bq.field_71990_ca, 0, 8, 2, 2, structBoundingBox);
        this.func_74864_a(world, Block.field_72003_bq.field_71990_ca, 0, 8, 2, 3, structBoundingBox);
        this.func_74864_a(world, Block.field_72003_bq.field_71990_ca, 0, 2, 2, 5, structBoundingBox);
        this.func_74864_a(world, Block.field_72003_bq.field_71990_ca, 0, 3, 2, 5, structBoundingBox);
        this.func_74864_a(world, Block.field_72003_bq.field_71990_ca, 0, 4, 2, 5, structBoundingBox);
        this.func_74864_a(world, Block.field_72003_bq.field_71990_ca, 0, 5, 2, 0, structBoundingBox);
        this.func_74864_a(world, Block.field_72003_bq.field_71990_ca, 0, 6, 2, 5, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.buildingBlocks[0], 1, 1, 3, structBoundingBox);
        this.func_74864_a(world, 0, 0, 2, 1, 0, structBoundingBox);
        this.func_74864_a(world, 0, 0, 2, 2, 0, structBoundingBox);
        this.func_74881_a(world, structBoundingBox, random, 2, 1, 0, this.func_74863_c(Block.field_72054_aE.field_71990_ca, 1));
        if (this.func_74866_a(world, 2, 0, -1, structBoundingBox) == 0 && this.func_74866_a(world, 2, -1, -1, structBoundingBox) != 0) {
            this.func_74864_a(world, Block.field_72057_aH.field_71990_ca, this.func_74863_c(Block.field_72057_aH.field_71990_ca, 3), 2, 0, -1, structBoundingBox);
        }
        this.func_74864_a(world, 0, 0, 6, 1, 5, structBoundingBox);
        this.func_74864_a(world, 0, 0, 6, 2, 5, structBoundingBox);
        this.func_74864_a(world, ForestryBlock.candle.field_71990_ca, 0, 2, 3, 4, structBoundingBox);
        this.func_74864_a(world, ForestryBlock.candle.field_71990_ca, 0, 6, 3, 4, structBoundingBox);
        this.func_74864_a(world, ForestryBlock.candle.field_71990_ca, 0, 2, 3, 1, structBoundingBox);
        this.func_74864_a(world, ForestryBlock.candle.field_71990_ca, 0, 6, 3, 1, structBoundingBox);
        this.func_74881_a(world, structBoundingBox, random, 6, 1, 5, this.func_74863_c(Block.field_72054_aE.field_71990_ca, 1));
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_74871_b(world, j, 7, i, structBoundingBox);
                this.func_74870_b(world, Block.field_71978_w.field_71990_ca, 0, j, -1, i, structBoundingBox);
            }
        }
        this.func_74893_a(world, this.field_74887_e, 7, 1, 1, 2);
        return true;
    }

    private void buildRoof(World world, StructureBoundingBox structBoundingBox) {
        int rotatedMetaDoor = this.func_74863_c(Block.field_72063_at.field_71990_ca, 3);
        int rotatedMetaGarden = this.func_74863_c(Block.field_72063_at.field_71990_ca, 2);
        for (int i = -1; i <= 2; ++i) {
            for (int j = 0; j <= 8; ++j) {
                this.func_74864_a(world, Block.field_72063_at.field_71990_ca, rotatedMetaDoor, j, 4 + i, i, structBoundingBox);
                this.func_74864_a(world, Block.field_72063_at.field_71990_ca, rotatedMetaGarden, j, 4 + i, 5 - i, structBoundingBox);
            }
        }
    }

    protected void buildGarden(World world, StructureBoundingBox box) {
        int groundId = Block.field_71979_v.field_71990_ca;
        if (this.isDesertVillage()) {
            groundId = Block.field_71939_E.field_71990_ca;
        }
        for (int i = 1; i <= 8; ++i) {
            for (int j = 6; j <= 10; ++j) {
                this.func_74870_b(world, groundId, 0, i, 0, j, box);
            }
        }
    }

    protected void plantFlowerGarden(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.isDesertVillage()) {
            this.func_74864_a(world, Block.field_72038_aV.field_71990_ca, 0, 4, 1, 7, box);
            return;
        }
        for (int i = minY; i <= maxY; ++i) {
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    int zCoord;
                    int yCoord;
                    int xCoord;
                    if (!world.field_73012_v.nextBoolean() || !Block.field_72107_ae.func_71854_d(world, xCoord = this.func_74865_a(j, k), yCoord = this.func_74862_a(i), zCoord = this.func_74873_b(j, k))) continue;
                    ItemStack flower = (ItemStack)FlowerManager.plainFlowers.get(world.field_73012_v.nextInt(FlowerManager.plainFlowers.size()));
                    this.func_74864_a(world, flower.field_77993_c, flower.func_77960_j(), j, i, k, box);
                }
            }
        }
    }

    protected void buildApiaries(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.populateApiary(world, box, 3, 1, 8);
        this.populateApiary(world, box, 6, 1, 8);
    }

    private void populateApiary(World world, StructureBoundingBox box, int x, int y, int z) {
        int zCoord;
        int yCoord;
        int xCoord = this.func_74865_a(x, z);
        if (box.func_78890_b(xCoord, yCoord = this.func_74862_a(y), zCoord = this.func_74873_b(x, z)) && world.func_72798_a(xCoord, yCoord, zCoord) != ForestryBlock.apiculture.field_71990_ca && world.func_72899_e(xCoord, yCoord - 1, zCoord)) {
            world.func_72832_d(xCoord, yCoord, zCoord, ForestryBlock.apiculture.field_71990_ca, 0, 2);
            ForestryBlock.apiculture.func_71861_g(world, xCoord, yCoord, zCoord);
            TileEntity tile = world.func_72796_p(xCoord, yCoord, zCoord);
            if (tile instanceof TileBeehouse) {
                TileBeehouse apiary = (TileBeehouse)tile;
                apiary.initialize();
                apiary.func_70299_a(0, BeeManager.beeInterface.getBeeStack(this.getVillageBee(world, xCoord, yCoord, zCoord), EnumBeeType.PRINCESS));
                apiary.func_70299_a(1, BeeManager.beeInterface.getBeeStack(this.getVillageBee(world, xCoord, yCoord, zCoord), EnumBeeType.DRONE));
                for (int i = 9; i < 12; ++i) {
                    float roll = world.field_73012_v.nextFloat();
                    if (roll < 0.2f) {
                        apiary.func_70299_a(i, new ItemStack(ForestryItem.frameUntreated));
                        continue;
                    }
                    if (roll < 0.4f) {
                        apiary.func_70299_a(i, new ItemStack(ForestryItem.frameImpregnated));
                        continue;
                    }
                    if (!((double)roll < 0.6)) continue;
                    apiary.func_70299_a(i, new ItemStack(ForestryItem.frameProven));
                }
            }
        }
    }

    private IBee getVillageBee(World world, int xCoord, int yCoord, int zCoord) {
        BiomeGenBase biome = world.func_72807_a(xCoord, zCoord);
        ArrayList candidates = BeeManager.villageBees[1] != null && BeeManager.villageBees[1].size() > 0 && world.field_73012_v.nextDouble() < 0.2 ? BeeManager.villageBees[1] : BeeManager.villageBees[0];
        ArrayList<IBeeGenome> valid = new ArrayList<IBeeGenome>();
        for (IBeeGenome genome : candidates) {
            if (!this.checkBiomeHazard(genome, biome.field_76750_F, biome.field_76751_G)) continue;
            valid.add(genome);
        }
        if (valid.isEmpty()) {
            return BeeManager.beeInterface.getBee(world, (IBeeGenome)BeeManager.villageBees[0].get(world.field_73012_v.nextInt(BeeManager.villageBees[0].size())));
        }
        return BeeManager.beeInterface.getBee(world, (IBeeGenome)valid.get(world.field_73012_v.nextInt(valid.size())));
    }

    private boolean checkBiomeHazard(IBeeGenome genome, float temperature, float humidity) {
        EnumTemperature beeTemperature = genome.getPrimaryAsBee().getTemperature();
        EnumTolerance temperatureTolerance = genome.getToleranceTemp();
        ArrayList toleratedTemperatures = ClimateHelper.getToleratedTemperature(beeTemperature, temperatureTolerance);
        boolean validTemp = false;
        validTemp = toleratedTemperatures.contains((Object)ClimateHelper.getTemperature(temperature));
        if (!validTemp) {
            return false;
        }
        EnumHumidity beeHumidity = genome.getPrimaryAsBee().getHumidity();
        EnumTolerance humidityTolerance = genome.getToleranceHumid();
        ArrayList toleratedHumidity = ClimateHelper.getToleratedHumidity(beeHumidity, humidityTolerance);
        boolean validHumidity = false;
        validHumidity = toleratedHumidity.contains((Object)ClimateHelper.getHumidity(humidity));
        return validHumidity;
    }

    protected void fillBoxWith(World world, StructureBoundingBox box, int par3, int par4, int par5, int par6, int par7, int par8, ItemStack buildingBlock, boolean replace) {
        for (int var14 = par4; var14 <= par7; ++var14) {
            for (int var15 = par3; var15 <= par6; ++var15) {
                for (int var16 = par5; var16 <= par8; ++var16) {
                    if (replace && this.func_74866_a(world, var15, var14, var16, box) == 0) continue;
                    this.func_74864_a(world, buildingBlock.field_77993_c, buildingBlock.func_77960_j(), var15, var14, var16, box);
                }
            }
        }
    }

    protected void placeBlockAtCurrentPosition(World world, ItemStack buildingBlock, int par4, int par5, int par6, StructureBoundingBox par7StructureBoundingBox) {
        int var10;
        int var9;
        int var8 = this.func_74865_a(par4, par6);
        if (par7StructureBoundingBox.func_78890_b(var8, var9 = this.func_74862_a(par5), var10 = this.func_74873_b(par4, par6))) {
            world.func_72832_d(var8, var9, var10, buildingBlock.field_77993_c, buildingBlock.func_77960_j(), 2);
        }
    }

    protected int func_74888_b(int villagerCount) {
        if (villagerCount <= 0) {
            return 80;
        }
        return 81;
    }
}

