/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.core.config.Version;
import forestry.core.proxy.Proxies;
import forestry.core.utils.CommandMC;
import forestry.core.utils.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class CommandTreekeepingMode
extends CommandMC {
    String[] modeStrings = new String[TreeManager.breedingManager.getTreekeepingModes().size()];

    public CommandTreekeepingMode() {
        for (int i = 0; i < TreeManager.breedingManager.getTreekeepingModes().size(); ++i) {
            this.modeStrings[i] = ((ITreekeepingMode)TreeManager.breedingManager.getTreekeepingModes().get(i)).getName();
        }
    }

    public int compareTo(Object arg0) {
        return this.func_71517_b().compareTo(((ICommand)arg0).func_71517_b());
    }

    public String func_71517_b() {
        return "treekeeping";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/" + this.func_71517_b() + " help";
    }

    public List func_71514_a() {
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 0) {
            throw new WrongUsageException("Type '" + this.func_71518_a(sender) + "' for help.", new Object[0]);
        }
        if (arguments[0].matches("list")) {
            this.listModes(sender, arguments);
        } else if (arguments[0].matches("info")) {
            this.listModeInfo(sender, arguments);
        } else if (arguments[0].matches("set")) {
            if (arguments.length <= 1) {
                throw new WrongUsageException("/" + this.func_71517_b() + " set [<world-#>] <mode-name>", new Object[0]);
            }
            World world = this.getWorld(sender, arguments);
            String desired = arguments[arguments.length - 1];
            ITreekeepingMode mode = TreeManager.breedingManager.getTreekeepingMode(desired);
            if (mode == null) {
                throw new CommandException("A treekeeping mode called '%s' is not available.", new Object[]{desired});
            }
            TreeManager.breedingManager.setTreekeepingMode(world, mode.getName());
            CommandTreekeepingMode.func_71522_a((ICommandSender)sender, (String)"Treekeeping mode set to %s.", (Object[])new Object[]{mode.getName()});
        } else if (arguments[0].matches("save")) {
            if (arguments.length <= 1) {
                throw new WrongUsageException("/" + this.func_71517_b() + " save <player-name>", new Object[0]);
            }
            this.saveStatistics(sender, arguments);
        } else if (arguments[0].matches("help")) {
            sender.func_70006_a("Format: '/" + this.func_71517_b() + " <command> <arguments>'");
            sender.func_70006_a("Available commands:");
            sender.func_70006_a("- list [<world-#>]: lists current and available treekeeping modes.");
            sender.func_70006_a("- info <mode-name> : information on treekeeping mode.");
            sender.func_70006_a("- set [<world-#>] <mode-name>: set treekeeping mode for world.");
            sender.func_70006_a("- save [<world-#>] <player-name>: save treekeeping statistics for the given player.");
        }
    }

    private void saveStatistics(ICommandSender sender, String[] arguments) {
        String newLine = System.getProperty("line.separator");
        World world = this.getWorld(sender, arguments);
        String player = arguments[1];
        ArrayList<String> statistics = new ArrayList<String>();
        statistics.add(String.format("Treekeeping statistics for %s on %s:", player, DateFormat.getInstance().format(new Date())));
        statistics.add("");
        statistics.add("MODE: " + TreeManager.breedingManager.getTreekeepingMode(world).getName());
        statistics.add("");
        IArboristTracker tracker = TreeManager.breedingManager.getArboristTracker(world, player);
        if (tracker == null) {
            statistics.add("No statistics found.");
        } else {
            statistics.add("BRED:");
            statistics.add("-----");
            statistics.add("");
            ArrayList<IAlleleTreeSpecies> species = new ArrayList<IAlleleTreeSpecies>();
            for (IAllele iAllele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(iAllele instanceof IAlleleTreeSpecies)) continue;
                species.add((IAlleleTreeSpecies)iAllele);
            }
            statistics.add(String.format("SPECIES (%s):", species.size()));
            statistics.add("-------------");
            statistics.add("");
            for (IAlleleTreeSpecies iAlleleTreeSpecies : species) {
                statistics.add(this.generateSpeciesListEntry(iAlleleTreeSpecies, tracker));
            }
        }
        File file = new File(Proxies.common.getForestryRoot(), "config/" + "Forestry".toLowerCase(Locale.ENGLISH) + "/stats/" + player + ".log");
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists() && !file.createNewFile()) {
                sender.func_70006_a("Log file could not be created. Failed to save statistics.");
                return;
            }
            if (!file.canWrite()) {
                sender.func_70006_a("Cannot write to log file. Failed to save statistics.");
                return;
            }
            FileOutputStream fileout = new FileOutputStream(file);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, "UTF-8"));
            bufferedWriter.write("# Forestry" + newLine + "# " + Version.getVersion() + newLine);
            for (String line : statistics) {
                bufferedWriter.write(line + newLine);
            }
            bufferedWriter.close();
        }
        catch (Exception ex) {
            sender.func_70006_a("Write operation threw an exception. Failed to save statistics.");
            ex.printStackTrace();
        }
        sender.func_70006_a("Saved statistics for player " + player);
    }

    private String generateSpeciesListEntry(IAlleleTreeSpecies species, IArboristTracker tracker) {
        String discovered = "[   ]";
        if (tracker.isDiscovered(species)) {
            discovered = "[ X ]";
        }
        String blacklisted = "[    ]";
        if (AlleleManager.alleleRegistry.isBlacklisted(species.getUID())) {
            blacklisted = "[ BL ]";
        }
        String notcounted = "[    ]";
        if (!species.isCounted()) {
            notcounted = "[ NC ]";
        }
        return String.format("%s %s %s\t%-40s %-20s %-20s", discovered, blacklisted, notcounted, species.getUID(), species.getName(), species.getAuthority());
    }

    private void listModes(ICommandSender sender, String[] arguments) {
        World world = this.getWorld(sender, arguments);
        sender.func_70006_a("Current: " + TreeManager.breedingManager.getTreekeepingMode(world).getName() + " (#" + world.func_72912_H().func_76076_i() + ")");
        String help = "";
        for (ITreekeepingMode mode : TreeManager.breedingManager.getTreekeepingModes()) {
            if (!help.isEmpty()) {
                help = help + ", ";
            }
            help = help + mode.getName();
        }
        sender.func_70006_a("Available modes: " + help);
    }

    private void listModeInfo(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 1) {
            throw new WrongUsageException("/" + this.func_71517_b() + " info <mode-name>", new Object[0]);
        }
        ITreekeepingMode found = null;
        for (ITreekeepingMode mode : TreeManager.breedingManager.getTreekeepingModes()) {
            if (!mode.getName().equalsIgnoreCase(arguments[1])) continue;
            found = mode;
            break;
        }
        if (found == null) {
            throw new CommandException("No treekeeping mode called '%s' is available.", new Object[]{arguments[1]});
        }
        sender.func_70006_a("\u00a7aMode: " + found.getName());
        for (String desc : found.getDescription()) {
            sender.func_70006_a(StringUtil.localize(desc));
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return Proxies.common.isOp((EntityPlayer)sender);
        }
        return sender.func_70003_b(4, this.func_71517_b());
    }

    public List func_71516_a(ICommandSender sender, String[] incomplete) {
        return CommandTreekeepingMode.func_71530_a((String[])incomplete, (String[])this.modeStrings);
    }
}

