/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitProviderRipening
extends FruitProviderNone {
    HashMap products = new HashMap();
    int colourRipe = 0xFFFFFF;
    int colourCallow = 0xFFFFFF;
    int diffR;
    int diffG;
    int diffB = 0;

    public FruitProviderRipening(String key, IFruitFamily family, ItemStack product, float modifier) {
        super(key, family);
        this.products.put(product, Float.valueOf(modifier));
    }

    public FruitProviderRipening setColours(int ripe, int callow) {
        this.colourRipe = ripe;
        this.colourCallow = callow;
        this.diffR = (ripe >> 16 & 0xFF) - (callow >> 16 & 0xFF);
        this.diffG = (ripe >> 8 & 0xFF) - (callow >> 8 & 0xFF);
        this.diffB = (ripe & 0xFF) - (callow & 0xFF);
        return this;
    }

    public FruitProviderRipening setRipeningPeriod(int period) {
        this.ripeningPeriod = period;
        return this;
    }

    private float getRipeningStage(int ripeningTime) {
        if (ripeningTime >= this.ripeningPeriod) {
            return 1.0f;
        }
        return (float)ripeningTime / (float)this.ripeningPeriod;
    }

    @Override
    public ItemStack[] getFruits(ITreeGenome genome, World world, int x, int y, int z, int ripeningTime) {
        ArrayList<ItemStack> product = new ArrayList<ItemStack>();
        float stage = this.getRipeningStage(ripeningTime);
        if (stage < 0.5f) {
            return new ItemStack[0];
        }
        float modeYieldMod = TreeManager.breedingManager.getTreekeepingMode(world).getYieldModifier(genome, 1.0f);
        for (Map.Entry entry : this.products.entrySet()) {
            if (!(world.field_73012_v.nextFloat() <= genome.getYield() * ((Float)entry.getValue()).floatValue() * modeYieldMod * 5.0f * stage)) continue;
            product.add(((ItemStack)entry.getKey()).func_77946_l());
        }
        return product.toArray(new ItemStack[0]);
    }

    @Override
    public ItemStack[] getProducts() {
        return this.products.keySet().toArray(new ItemStack[0]);
    }

    @Override
    public ItemStack[] getSpecialty() {
        return new ItemStack[0];
    }

    @Override
    public boolean markAsFruitLeaf(ITreeGenome genome, World world, int x, int y, int z) {
        return true;
    }

    @Override
    public int getColour(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime) {
        float stage = this.getRipeningStage(ripeningTime);
        int r = (this.colourCallow >> 16 & 0xFF) + (int)((float)this.diffR * stage);
        int g = (this.colourCallow >> 8 & 0xFF) + (int)((float)this.diffG * stage);
        int b = (this.colourCallow & 0xFF) + (int)((float)this.diffB * stage);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }
}

