/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodType;
import forestry.core.config.ForestryBlock;
import forestry.plugins.PluginForestryArboriculture;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockArbFence
extends BlockFence
implements IWoodTyped {
    private FenceCat cat;

    public BlockArbFence(int id, FenceCat cat) {
        super(id, "", Material.field_76245_d);
        this.cat = cat;
        this.func_71848_c(2.0f);
        this.func_71894_b(5.0f);
        this.func_71884_a(field_71967_e);
        this.func_71849_a(Tabs.tabArboriculture);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        int count = this.cat == FenceCat.CAT0 ? 16 : 8;
        for (int i = 0; i < count; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean func_72250_d(IBlockAccess world, int x, int y, int z) {
        if (!this.isFence(world, x, y, z)) {
            int blockid = world.func_72798_a(x, y, z);
            Block block = Block.field_71973_m[blockid];
            return block != null && block.field_72018_cp.func_76218_k() && block.func_71886_c() ? block.field_72018_cp != Material.field_76266_z : false;
        }
        return true;
    }

    public int func_71857_b() {
        return PluginForestryArboriculture.modelIdFences;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        WoodType.registerIcons();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return this.getWoodType(meta).getPlankIcon();
    }

    public boolean isFence(IBlockAccess world, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        return blockid == ForestryBlock.fences1.field_71990_ca || blockid == ForestryBlock.fences2.field_71990_ca || blockid == Block.field_72031_aZ.field_71990_ca || blockid == Block.field_71993_bv.field_71990_ca || blockid == Block.field_72098_bB.field_71990_ca;
    }

    public boolean isWood(World world, int x, int y, int z) {
        return true;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 5;
    }

    @Override
    public WoodType getWoodType(int meta) {
        if (this.cat.ordinal() * 16 + meta < WoodType.VALUES.length) {
            return WoodType.VALUES[this.cat.ordinal() * 16 + meta];
        }
        return WoodType.LARCH;
    }

    @Override
    public String getBlockKind() {
        return "fences";
    }

    public static enum FenceCat {
        CAT0,
        CAT1;

    }
}

