/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.arboriculture.gadgets.TileTreeContainer;
import forestry.arboriculture.network.PacketLeafUpdate;
import forestry.core.genetics.Allele;
import forestry.core.network.ForestryPacket;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.plugins.PluginForestryArboriculture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.EnumPlantType;

public class TileLeaves
extends TileTreeContainer
implements IPollinatable,
IFruitBearer {
    private int colourLeaves;
    private int colourFruits;
    private short textureIndexFancy = (short)48;
    private short textureIndexPlain = (short)64;
    private short textureIndexFruits = (short)-1;
    private boolean isFruitLeaf;
    private int ripeningTime;

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.isFruitLeaf = nbttagcompound.func_74767_n("FL");
        this.ripeningTime = nbttagcompound.func_74762_e("RT");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("FL", this.isFruitLeaf);
        nbttagcompound.func_74768_a("RT", this.ripeningTime);
    }

    @Override
    public void onBlockTick() {
        if (!this.hasFruit()) {
            return;
        }
        if (this.ripeningTime >= 32766) {
            return;
        }
        float sappiness = this.getTree().getGenome().getSappiness() * TreeManager.breedingManager.getTreekeepingMode(this.field_70331_k).getSappinessModifier(this.getTree().getGenome(), 1.0f);
        if (this.field_70331_k.field_73012_v.nextFloat() < sappiness) {
            ++this.ripeningTime;
            this.sendNetworkUpdateRipening();
        }
    }

    @Override
    public void setTree(ITree tree) {
        if (tree.canBearFruit()) {
            this.isFruitLeaf = tree.getGenome().getFruitProvider().markAsFruitLeaf(tree.getGenome(), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        super.setTree(tree);
    }

    public int getFoliageColour() {
        return this.colourLeaves;
    }

    public int getFruitColour() {
        return this.colourFruits;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBlockTexture(boolean fancy) {
        if (fancy) {
            return TextureManager.getInstance().getIcon(this.textureIndexFancy);
        }
        return TextureManager.getInstance().getIcon(this.textureIndexPlain);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getFruitTexture() {
        if (this.textureIndexFruits >= 0) {
            return TextureManager.getInstance().getIcon(this.textureIndexFruits);
        }
        return null;
    }

    public int getRipeningTime() {
        return this.ripeningTime;
    }

    @Override
    public EnumSet getPlantType() {
        if (this.getTree() == null) {
            return EnumSet.noneOf(EnumPlantType.class);
        }
        return this.getTree().getPlantTypes();
    }

    @Override
    public boolean canMateWith(IIndividual individual) {
        if (this.getTree() == null) {
            return false;
        }
        if (this.getTree().getMate() != null) {
            return false;
        }
        return !this.getTree().getGenome().isGeneticEqual(individual.getGenome());
    }

    @Override
    public void mateWith(IIndividual individual) {
        if (this.getTree() == null) {
            return;
        }
        this.getTree().mate((ITree)individual);
    }

    @Override
    public IIndividual getPollen() {
        return this.getTree();
    }

    public int determineFoliageColour() {
        if (this.getTree() == null) {
            return PluginForestryArboriculture.proxy.getFoliageColorBasic();
        }
        return this.getTree().getGenome().getPrimaryAsTree().getLeafColour(this.getTree());
    }

    public int determineFruitColour() {
        if (this.getTree() == null) {
            return 0xFFFFFF;
        }
        IFruitProvider fruit = this.getTree().getGenome().getFruitProvider();
        return fruit.getColour(this.getTree().getGenome(), (IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getRipeningTime());
    }

    public short determineTextureIndex(boolean fancy) {
        if (this.getTree() != null) {
            return this.getTree().getGenome().getPrimaryAsTree().getLeafIconIndex(this.getTree(), fancy);
        }
        return 0;
    }

    public short determineOverlayIndex() {
        if (this.getTree() == null) {
            return -1;
        }
        if (!this.hasFruit()) {
            return -1;
        }
        IFruitProvider fruit = this.getTree().getGenome().getFruitProvider();
        if (this.getTree().getGenome().getPrimary() == Allele.treeOak && fruit == ((IAlleleFruit)((Object)Allele.fruitApple)).getProvider()) {
            return -1;
        }
        return fruit.getIconIndex(this.getTree().getGenome(), (IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getRipeningTime(), true);
    }

    @Override
    public Packet func_70319_e() {
        return new PacketLeafUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this).getPacket();
    }

    @Override
    public void sendNetworkUpdate() {
        Proxies.net.sendNetworkPacket(new PacketLeafUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this), this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private void sendNetworkUpdateRipening() {
        Proxies.net.sendNetworkPacket(new PacketLeafUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.determineFruitColour()), this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        PacketLeafUpdate packet = (PacketLeafUpdate)packetRaw;
        if (packet.isRipeningUpdate()) {
            this.colourFruits = packet.colourFruits;
        } else {
            this.isFruitLeaf = packet.isFruitLeaf > 0;
            this.textureIndexFancy = packet.textureIndexFancy;
            this.textureIndexPlain = packet.textureIndexPlain;
            this.textureIndexFruits = packet.textureIndexFruit;
            this.colourLeaves = packet.colourLeaves;
            this.colourFruits = packet.colourFruits;
        }
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public Collection pickFruit(ItemStack tool) {
        if (!this.hasFruit()) {
            return new ArrayList();
        }
        if (this.getTree() == null) {
            return new ArrayList();
        }
        ArrayList<ItemStack> picked = new ArrayList<ItemStack>(Arrays.asList(this.getTree().produceStacks(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getRipeningTime())));
        this.ripeningTime = 0;
        this.sendNetworkUpdateRipening();
        return picked;
    }

    @Override
    public IFruitFamily getFruitFamily() {
        if (this.getTree() == null) {
            return null;
        }
        return this.getTree().getGenome().getFruitProvider().getFamily();
    }

    @Override
    public float getRipeness() {
        if (this.getTree() == null) {
            return 0.0f;
        }
        int ripeningPeriod = this.getTree().getGenome().getFruitProvider().getRipeningPeriod();
        if (ripeningPeriod == 0) {
            return 1.0f;
        }
        return (float)this.ripeningTime / (float)ripeningPeriod;
    }

    @Override
    public boolean hasFruit() {
        return this.isFruitLeaf;
    }

    @Override
    public void addRipeness(float add) {
        if (this.getTree() == null) {
            return;
        }
        this.ripeningTime = (int)((float)this.ripeningTime + (float)this.getTree().getGenome().getFruitProvider().getRipeningPeriod() * add);
        this.sendNetworkUpdateRipening();
    }
}

