/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenBalsa;
import forestry.core.genetics.AlleleSpecies;
import forestry.core.render.TextureManager;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;

public class AlleleTreeSpecies
extends AlleleSpecies
implements IAlleleTreeSpecies,
IIconProvider {
    private static HashMap leafTypes = new HashMap();
    private Class generatorClass = WorldGenBalsa.class;
    private int primaryColour;
    private int secondaryColour;
    private LeafType leafType;
    private int girth = 1;
    private EnumPlantType nativeType = EnumPlantType.Plains;
    private ArrayList fruits = new ArrayList();
    private int vanillaMap = -1;
    @SideOnly(value=Side.CLIENT)
    Icon icon;

    public AlleleTreeSpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial, int primaryColor, int secondaryColor) {
        super(uid, isDominant, name, branch, binomial);
        this.primaryColour = primaryColor;
        this.secondaryColour = secondaryColor;
        this.leafType = (LeafType)leafTypes.get("deciduous");
    }

    public AlleleTreeSpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial, int primaryColor, Class generator) {
        this(uid, isDominant, name, branch, binomial, primaryColor, Utils.multiplyRGBComponents(primaryColor, 1.35f), generator);
    }

    public AlleleTreeSpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial, int primaryColor, int secondaryColor, Class generator) {
        super(uid, isDominant, name, branch, binomial);
        this.generatorClass = generator;
        this.primaryColour = primaryColor;
        this.secondaryColour = secondaryColor;
        this.leafType = (LeafType)leafTypes.get("deciduous");
    }

    public AlleleTreeSpecies setPlantType(EnumPlantType type) {
        this.nativeType = type;
        return this;
    }

    public AlleleTreeSpecies setGirth(int girth) {
        this.girth = girth;
        return this;
    }

    public AlleleTreeSpecies addFruitFamily(IFruitFamily family) {
        this.fruits.add(family);
        return this;
    }

    public AlleleTreeSpecies setLeafIndices(String ident) {
        this.leafType = (LeafType)leafTypes.get(ident);
        return this;
    }

    public AlleleTreeSpecies setVanillaMap(int vanillaMeta) {
        this.vanillaMap = vanillaMeta;
        return this;
    }

    @Override
    public EnumPlantType getPlantType() {
        return this.nativeType;
    }

    @Override
    public ArrayList getSuitableFruit() {
        return this.fruits;
    }

    @Override
    public int getGirth() {
        return this.girth;
    }

    @Override
    public WorldGenerator getGenerator(ITree tree, World world, int x, int y, int z) {
        try {
            return (WorldGenerator)this.generatorClass.getConstructor(ITreeGenData.class).newInstance(tree);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to instantiate generator of class " + this.generatorClass.getName());
        }
    }

    @Override
    public Class[] getGeneratorClasses() {
        return new Class[]{this.generatorClass};
    }

    @Override
    public short getLeafIconIndex(ITree tree, boolean fancy) {
        if (!fancy) {
            return this.leafType.plainUID;
        }
        if (tree.getMate() != null) {
            return this.leafType.changedUID;
        }
        return this.leafType.fancyUID;
    }

    public AlleleTreeSpecies setGenerator(Class generatorClass) {
        this.generatorClass = generatorClass;
        return this;
    }

    @Override
    public int getLeafColour(ITree tree) {
        if (tree.getMate() != null) {
            return this.secondaryColour;
        }
        return this.primaryColour;
    }

    @Override
    public int getGermlingIconColour(int renderPass) {
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemIcons(IconRegister itemMap) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTerrainIcons(IconRegister terrainMap) {
        this.icon = this.vanillaMap < 0 ? TextureManager.getInstance().registerTerrainTex("germlings/sapling." + this.uid) : Block.field_71987_y.func_71858_a(0, this.vanillaMap);
        TextureManager.getInstance().registerTerrainTexUID(this.leafType.plainUID, "leaves/" + this.leafType.ident + ".plain");
        TextureManager.getInstance().registerTerrainTexUID(this.leafType.changedUID, "leaves/" + this.leafType.ident + ".changed");
        TextureManager.getInstance().registerTerrainTexUID(this.leafType.fancyUID, "leaves/" + this.leafType.ident + ".fancy");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getGermlingIcon(EnumGermlingType type, int renderPass) {
        return this.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(short texUID) {
        return TextureManager.getInstance().getIcon(texUID);
    }

    static {
        leafTypes.put("deciduous", new LeafType("deciduous", 10, 11, 12));
        leafTypes.put("conifers", new LeafType("conifers", 15, 16, 17));
        leafTypes.put("jungle", new LeafType("jungle", 20, 21, 22));
        leafTypes.put("willow", new LeafType("willow", 25, 26, 27));
        leafTypes.put("maple", new LeafType("maple", 30, 31, 32));
        leafTypes.put("palm", new LeafType("palm", 35, 36, 37));
    }

    private static class LeafType {
        public final String ident;
        public final short fancyUID;
        public final short plainUID;
        public final short changedUID;

        public LeafType(String ident, short fancyUID, short plainUID, short changedUID) {
            this.ident = ident;
            this.fancyUID = fancyUID;
            this.plainUID = plainUID;
            this.changedUID = changedUID;
        }
    }
}

