/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import cpw.mods.fml.common.FMLCommonHandler;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ITreeBreedingManager;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.genetics.ArboristTracker;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.plugins.PluginForestryArboriculture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class BreedingManager
implements ITreeBreedingManager {
    public static HashMap speciesTemplates = new HashMap();
    public static ArrayList treeTemplates = new ArrayList();
    ArrayList treekeepingModes = new ArrayList();
    public static ITreekeepingMode activeTreekeepingMode;
    private static ArrayList treeMutations;

    @Override
    public void registerTreeTemplate(IAllele[] template) {
        this.registerTreeTemplate(template[0].getUID(), template);
    }

    @Override
    public void registerTreeTemplate(String identifier, IAllele[] template) {
        treeTemplates.add(new Tree(TreeManager.treeInterface.templateAsGenome(template)));
        speciesTemplates.put(identifier, template);
    }

    @Override
    public IAllele[] getRandomTreeTemplate(Random rand) {
        return ((IAllele[][])speciesTemplates.values().toArray((T[])new IAllele[0][]))[rand.nextInt(speciesTemplates.values().size())];
    }

    @Override
    public IAllele[] getTreeTemplate(String identifier) {
        return (IAllele[])speciesTemplates.get(identifier);
    }

    @Override
    public IAllele[] getDefaultTreeTemplate() {
        return TreeTemplates.getDefaultTemplate();
    }

    @Override
    public IArboristTracker getArboristTracker(World world, String player) {
        String filename = "ArboristTracker." + player;
        ArboristTracker tracker = (ArboristTracker)world.func_72943_a(ArboristTracker.class, filename);
        if (tracker == null) {
            tracker = new ArboristTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        return tracker;
    }

    @Override
    public ArrayList getTreekeepingModes() {
        return this.treekeepingModes;
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(World world) {
        if (activeTreekeepingMode != null) {
            return activeTreekeepingMode;
        }
        IArboristTracker tracker = this.getArboristTracker(world, "__COMMON_");
        String mode = tracker.getModeName();
        if (mode == null || mode.isEmpty()) {
            mode = PluginForestryArboriculture.treekeepingMode;
        }
        this.setTreekeepingMode(world, mode);
        FMLCommonHandler.instance().getFMLLogger().fine("Set Treekeeping mode for a world to " + mode);
        return activeTreekeepingMode;
    }

    @Override
    public void registerTreekeepingMode(ITreekeepingMode mode) {
        this.treekeepingModes.add(mode);
    }

    @Override
    public void setTreekeepingMode(World world, String name) {
        activeTreekeepingMode = this.getTreekeepingMode(name);
        this.getArboristTracker(world, "__COMMON_").setModeName(name);
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(String name) {
        for (ITreekeepingMode mode : this.treekeepingModes) {
            if (!mode.getName().equals(name) && !mode.getName().equals(name.toLowerCase(Locale.ENGLISH))) continue;
            return mode;
        }
        FMLCommonHandler.instance().getFMLLogger().fine("Failed to find a Treekeeping mode called '%s', reverting to fallback.");
        return (ITreekeepingMode)this.treekeepingModes.get(0);
    }

    @Override
    public ArrayList getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(treeMutations);
        }
        return treeMutations;
    }

    @Override
    public void registerTreeMutation(ITreeMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        treeMutations.add(mutation);
    }

    static {
        treeMutations = new ArrayList();
    }
}

