/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class GrowthProvider
implements IGrowthProvider {
    @Override
    public boolean canGrow(ITreeGenome genome, World world, int xPos, int yPos, int zPos, int expectedGirth, int expectedHeight) {
        return this.hasRoom(genome, world, xPos, yPos, zPos, expectedGirth, expectedHeight) && this.getGrowthConditions(genome, world, xPos, yPos, zPos) != EnumGrowthConditions.HOSTILE && this.hasSufficientSaplings(genome, world, xPos, yPos, zPos, expectedGirth);
    }

    @Override
    public EnumGrowthConditions getGrowthConditions(ITreeGenome genome, World world, int xPos, int yPos, int zPos) {
        return this.getConditionFromLight(world, xPos, yPos, zPos);
    }

    @Override
    public String getDescription() {
        return "Light";
    }

    @Override
    public String[] getInfo() {
        return new String[0];
    }

    protected EnumGrowthConditions getConditionsFromRainfall(World world, int xPos, int yPos, int zPos, float min, float max) {
        BiomeGenBase biome = world.func_72959_q().func_76935_a(xPos, zPos);
        if (biome.field_76751_G < min || biome.field_76751_G > max) {
            return EnumGrowthConditions.HOSTILE;
        }
        return EnumGrowthConditions.EXCELLENT;
    }

    protected EnumGrowthConditions getConditionsFromTemperature(World world, int xPos, int yPos, int zPos, float min, float max) {
        BiomeGenBase biome = world.func_72959_q().func_76935_a(xPos, zPos);
        if (biome.field_76750_F < min || biome.field_76750_F > max) {
            return EnumGrowthConditions.HOSTILE;
        }
        return EnumGrowthConditions.EXCELLENT;
    }

    protected EnumGrowthConditions getConditionFromLight(World world, int xPos, int yPos, int zPos) {
        int lightvalue = world.func_72957_l(xPos, yPos + 1, zPos);
        if (lightvalue > 13) {
            return EnumGrowthConditions.EXCELLENT;
        }
        if (lightvalue > 11) {
            return EnumGrowthConditions.GOOD;
        }
        if (lightvalue > 8) {
            return EnumGrowthConditions.NORMAL;
        }
        if (lightvalue > 6) {
            return EnumGrowthConditions.PALTRY;
        }
        return EnumGrowthConditions.HOSTILE;
    }

    protected boolean hasRoom(ITreeGenome genome, World world, int xPos, int yPos, int zPos, int expectedGirth, int expectedHeight) {
        int offset = (expectedGirth - 1) / 2;
        return this.checkArea(world, new Vect(xPos - offset, yPos + 1, zPos + offset), new Vect(-offset + expectedGirth, expectedHeight + 1, -offset + expectedGirth));
    }

    protected final boolean checkArea(World world, Vect start, Vect area) {
        for (int x = start.x; x < start.x + area.x; ++x) {
            for (int y = start.y; y < start.y + area.y; ++y) {
                for (int z = start.z; z < start.z + area.z; ++z) {
                    if (world.func_72799_c(x, y, z) || Utils.isReplaceableBlock(world, x, y, z)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean hasSufficientSaplings(ITreeGenome genome, World world, int xPos, int yPos, int zPos, int expectedGirth) {
        if (expectedGirth == 1) {
            return true;
        }
        int offset = (expectedGirth - 1) / 2;
        for (int x = xPos - offset; x < xPos - offset + expectedGirth; ++x) {
            for (int z = zPos - offset; z < zPos - offset + expectedGirth; ++z) {
                if (world.func_72799_c(x, yPos, z)) {
                    return false;
                }
                TileEntity tile = world.func_72796_p(x, yPos, z);
                if (!(tile instanceof TileSapling)) {
                    return false;
                }
                ITree tree = ((TileSapling)tile).getTree();
                if (tree.getGenome().getPrimary().getUID().equals(genome.getPrimary().getUID())) continue;
                return false;
            }
        }
        return true;
    }
}

